/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.codegeneration.lang;

import io.intino.tara.compiler.codegeneration.Format;
import io.intino.tara.compiler.codegeneration.lang.LanguageModelAdapter;
import io.intino.tara.compiler.codegeneration.lang.LanguageTemplate;
import io.intino.tara.compiler.core.CompilerConfiguration;
import io.intino.tara.compiler.model.Model;
import java.util.Collection;
import org.siani.itrules.Adapter;
import org.siani.itrules.Template;
import org.siani.itrules.engine.FrameBuilder;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

class LanguageCreator {
    private final CompilerConfiguration conf;
    private Collection<Model> models;

    LanguageCreator(CompilerConfiguration conf, Collection<Model> models) {
        this.conf = conf;
        this.models = models;
    }

    public String create() {
        Template template = LanguageTemplate.create();
        template.add("string", Format.string());
        template.add("reference", Format.reference());
        template.add("toCamelCase", Format.toCamelCase());
        Frame frame = null;
        for (Model model : this.models) {
            if (frame == null) {
                frame = this.createFrame(model);
                continue;
            }
            this.merge(frame, this.createFrame(model));
        }
        return template.format(frame).replace("$", "");
    }

    private void merge(Frame main, Frame newFrame) {
        newFrame.frames("node").forEachRemaining(n -> main.addFrame("node", new AbstractFrame[]{n}));
    }

    private Frame createFrame(Model model) {
        FrameBuilder builder = new FrameBuilder();
        CompilerConfiguration.DSL dsl = this.conf.languages().stream().filter(d -> d.name().equals(model.language())).findFirst().orElse(null);
        builder.register(Model.class, (Adapter)new LanguageModelAdapter(this.conf.outDSL(), this.conf.getLocale(), model.getLanguage(), this.conf.level(), this.conf.workingPackage(), dsl.generationPackage()));
        return (Frame)builder.build((Object)model);
    }
}

