/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.codegeneration;

import io.intino.tara.compiler.codegeneration.magritte.NamesValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.siani.itrules.Formatter;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;

public class Format {
    protected static final String DOT = ".";

    public static Template customize(Template template) {
        template.add("string", Format.string());
        template.add("reference", Format.reference());
        template.add("toCamelCase", Format.toCamelCase());
        template.add("withDollar", Format.withDollar());
        template.add("noPackage", Format.noPackage());
        template.add("key", Format.key());
        template.add("returnValue", (trigger, type) -> ((AbstractFrame)trigger.frame().frames("returnValue").next()).value().equals(type));
        template.add("WithoutType", Format.nativeParameterWithoutType());
        template.add("javaValidName", Format.javaValidName());
        template.add("javaValidWord", Format.javaValidWord());
        template.add("taraValidWord", Format.javaValidWord());
        template.add("withoutGeneric", Format.withoutGeneric());
        return template;
    }

    private Format() {
    }

    public static Formatter string() {
        return new StringFormatter();
    }

    public static Formatter reference() {
        return value -> {
            String val = value.toString();
            return !val.contains(DOT) ? Format.referenceFormat(val) : Format.firstLowerCase(Format.javaValidName().format((Object)val).toString()).replace(":", "").replace("#", "");
        };
    }

    private static String firstLowerCase(String val) {
        return val.substring(0, 1).toLowerCase() + val.substring(1);
    }

    public static Formatter qualifiedName() {
        return value -> {
            String val = value.toString();
            if (!val.contains(DOT)) {
                return Format.referenceFormat(val);
            }
            String[] split = val.split("\\.");
            String result = "";
            for (String name : split) {
                result = result + DOT + Format.referenceFormat(name);
            }
            return result.substring(1);
        };
    }

    private static String referenceFormat(String val) {
        return Format.javaValidName().format((Object)val).toString().replace(":", "");
    }

    public static Formatter toCamelCase() {
        return s -> {
            String value = s.toString();
            if (value.isEmpty()) {
                return "";
            }
            if (value.contains("_")) {
                value = value.toLowerCase();
            }
            return Format.toCamelCase(value, "_");
        };
    }

    public static Formatter withDollar() {
        return s -> {
            String value = s.toString();
            return value.replace(DOT, "$");
        };
    }

    public static Formatter noPackage() {
        return s -> {
            String value = s.toString();
            String[] split = value.split("\\.");
            String result = "";
            for (String word : split) {
                if (word.toLowerCase().equals(word)) continue;
                result = result + DOT + word;
            }
            return result.isEmpty() ? result : result.substring(1);
        };
    }

    public static Formatter javaValidName() {
        return s -> {
            String value = s.toString();
            return Format.toCamelCase(value, "-");
        };
    }

    public static Formatter taraValidWord() {
        return s -> {
            String value = s.toString();
            return NamesValidator.isKeyword(value) || NamesValidator.isTaraKeyword(value) ? value + "$" : value;
        };
    }

    public static Formatter javaValidWord() {
        return s -> {
            String value = s.toString();
            return NamesValidator.isKeyword(value) ? value + "$" : value;
        };
    }

    public static Formatter javaClassNames() {
        return s -> {
            List<String> names = Arrays.asList(s.toString().split("\\$"));
            List collect = names.stream().map(n -> Format.firstUpperCase().format(Format.javaValidName().format(n)).toString()).collect(Collectors.toList());
            return String.join((CharSequence)"$", collect);
        };
    }

    public static Formatter withoutGeneric() {
        return s -> {
            String value = s.toString();
            return value.contains("<") ? value.substring(0, value.indexOf("<")) : value;
        };
    }

    private static String toCamelCase(String value, String regex) {
        if (value.isEmpty()) {
            return "";
        }
        String[] parts = value.split(regex);
        if (parts.length == 1) {
            return value.substring(0, 1).toUpperCase() + value.substring(1);
        }
        String caseString = "";
        for (String part : parts) {
            caseString = caseString + Format.capitalize(part);
        }
        return caseString;
    }

    public static Formatter nativeParameterWithoutType() {
        return withType -> {
            String result = "";
            for (String parameter : Format.split(withType.toString())) {
                String split = parameter.trim().substring(parameter.trim().lastIndexOf(" ") + 1);
                result = result + ", " + split;
            }
            return result.isEmpty() ? result : result.substring(2);
        };
    }

    public static String[] split(String parameters) {
        String[] stringArray;
        ArrayList<String> list = new ArrayList<String>();
        List<Integer> commas = Format.recollectCommas(parameters);
        for (int i = 0; i < commas.size(); ++i) {
            list.add(parameters.substring(i == 0 ? 0 : commas.get(i - 1) + 1, commas.get(i)).trim());
        }
        if (!commas.isEmpty()) {
            list.add(parameters.substring(commas.get(commas.size() - 1) + 1).trim());
        }
        if (list.isEmpty()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = parameters.trim();
        } else {
            stringArray = list.toArray(new String[list.size()]);
        }
        return stringArray;
    }

    private static List<Integer> recollectCommas(String parameters) {
        ArrayList<Integer> commas = new ArrayList<Integer>();
        int anchor = 0;
        while (anchor >= 0) {
            if ((anchor = parameters.indexOf(",", anchor + 1)) <= 0 || Format.inType(parameters, Format.last(commas), anchor)) continue;
            commas.add(anchor);
        }
        return commas;
    }

    private static Integer last(List<Integer> commas) {
        return commas.isEmpty() ? Integer.valueOf(0) : commas.get(commas.size() - 1);
    }

    private static boolean inType(String parameters, int last, int anchor) {
        boolean greater;
        boolean minor = parameters.substring(last, anchor).contains("<");
        return minor != (greater = parameters.substring(last, anchor).contains(">"));
    }

    public static String capitalize(String value) {
        if (value.isEmpty()) {
            return "";
        }
        return value.substring(0, 1).toUpperCase() + value.substring(1).toLowerCase();
    }

    private static Formatter key() {
        return value -> {
            try {
                Long.parseLong(String.valueOf(value));
                return "$(" + value.toString() + ")";
            }
            catch (NumberFormatException e) {
                return value;
            }
        };
    }

    public static Formatter firstUpperCase() {
        return value -> value.toString().isEmpty() ? "" : value.toString().substring(0, 1).toUpperCase() + value.toString().substring(1);
    }

    private static class StringFormatter
    implements Formatter {
        private StringFormatter() {
        }

        public Object format(Object value) {
            String val = value.toString().trim();
            if (val.isEmpty()) {
                return val;
            }
            if (val.startsWith("\n") || val.startsWith("---")) {
                return this.transformMultiLineString((String)value);
            }
            return val;
        }

        private String transformMultiLineString(String value) {
            String val = value.replace("\r", "");
            int i = value.indexOf(45);
            String indent = value.substring(0, i).replace("\t", "    ");
            if ((val = val.replace(indent, "\n").trim()).startsWith("---")) {
                val = val.replaceAll("----+", "").trim();
            }
            return val.replaceAll("\n\n+", "\n").replace("\n", "\" +\n\"").replace("\"\"", "");
        }
    }
}

