/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.codegeneration;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.FileSystemException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileSystemUtils {
    private static final Logger LOG = Logger.getGlobal();

    private FileSystemUtils() {
    }

    public static Boolean removeDir(String sDirname) {
        File oFile = new File(sDirname);
        return FileSystemUtils.removeDir(oFile);
    }

    public static Boolean removeDir(File oFile) {
        if (oFile.exists()) {
            File[] aFiles = oFile.listFiles();
            assert (aFiles != null);
            for (File aFile : aFiles) {
                if (aFile.isDirectory()) {
                    FileSystemUtils.removeDir(aFile.getAbsolutePath());
                    continue;
                }
                aFile.delete();
            }
        } else {
            return true;
        }
        return oFile.delete();
    }

    public static Boolean copyDir(String sSource, String sDestination) throws FileSystemException {
        File oSource = new File(sSource);
        File oDestination = new File(sDestination);
        return FileSystemUtils.copyDir(oSource, oDestination);
    }

    public static Boolean copyDir(File oSource, File oDestination) throws FileSystemException {
        try {
            if (oSource.exists()) {
                if (oSource.isDirectory()) {
                    String[] children;
                    if (!oDestination.exists()) {
                        oDestination.mkdir();
                    }
                    for (String aChildren : children = oSource.list()) {
                        FileSystemUtils.copyDir(new File(oSource, aChildren), new File(oDestination, aChildren));
                    }
                } else {
                    int len;
                    FileInputStream in = new FileInputStream(oSource);
                    FileOutputStream out = new FileOutputStream(oDestination);
                    byte[] buf = new byte[1024];
                    while ((len = ((InputStream)in).read(buf)) > 0) {
                        ((OutputStream)out).write(buf, 0, len);
                    }
                    ((InputStream)in).close();
                    ((OutputStream)out).close();
                }
                return true;
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
            throw new FileSystemException(e.getMessage(), oSource.getName(), e.getMessage());
        }
        return false;
    }

    public static Boolean forceDir(String sDirname) {
        return new File(sDirname).mkdirs();
    }

    public static Boolean createFile(String sFilename) {
        try {
            new File(sFilename).createNewFile();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
        return true;
    }

    public static Boolean copyFile(String source, String destination) {
        try {
            return FileSystemUtils.copyFile(new FileInputStream(new File(source)), new File(destination));
        }
        catch (FileNotFoundException | FileSystemException e) {
            LOG.log(Level.SEVERE, "Could not copy the file: " + source + "\n" + e.getMessage(), e);
            return false;
        }
    }

    public static Boolean copyFile(InputStream source, File destination) throws FileSystemException {
        FileSystemUtils.forceDir(destination.getParentFile().getAbsolutePath());
        try {
            int len;
            FileOutputStream out = new FileOutputStream(destination);
            byte[] buf = new byte[1024];
            while ((len = source.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            source.close();
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
            throw new FileSystemException("Could not copy the file");
        }
        return true;
    }

    public static Boolean writeFile(String sFilename, String sContent) throws FileSystemException {
        try {
            OutputStreamWriter oWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(sFilename), "UTF-8");
            oWriter.write(sContent);
            oWriter.close();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
            throw new FileSystemException("Could not write file", sFilename, e.getMessage());
        }
        return true;
    }

    public static void writeInputStream(InputStream in, File outFile) throws IOException {
        int len;
        byte[] buffer = new byte[8192];
        if (outFile.isDirectory()) {
            outFile.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(outFile);
        while ((len = in.read(buffer)) >= 0) {
            ((OutputStream)out).write(buffer, 0, len);
        }
        in.close();
        ((OutputStream)out).close();
    }

    public static void getAllFiles(File dir, List<File> fileList) {
        File[] files = dir.listFiles();
        for (File file : files != null ? files : new File[]{}) {
            if (!file.isDirectory()) {
                fileList.add(file);
                continue;
            }
            FileSystemUtils.getAllFiles(file, fileList);
        }
    }

    public static String getNameWithoutExtension(String name) {
        int i = name.lastIndexOf(46);
        if (i != -1) {
            name = name.substring(0, i);
        }
        return name;
    }

    public static void zipDir(String name, String directory) throws IOException {
        File directoryToZip = new File(directory);
        ArrayList<File> fileList = new ArrayList<File>();
        FileSystemUtils.getAllFiles(directoryToZip, fileList);
        FileSystemUtils.writeZipFile(name, directoryToZip, fileList);
    }

    public static void writeZipFile(String name, File directoryToZip, List<File> fileList) throws IOException {
        FileOutputStream fos = new FileOutputStream(name);
        ZipOutputStream zos = new ZipOutputStream(fos);
        for (File file : fileList) {
            if (file.isDirectory()) continue;
            FileSystemUtils.addToZip(directoryToZip, file, zos);
        }
        zos.close();
        fos.close();
    }

    public static void addToZip(File directoryToZip, File file, ZipOutputStream zos) throws IOException {
        int length;
        FileInputStream fis = new FileInputStream(file);
        String zipFilePath = file.getCanonicalPath().substring(directoryToZip.getCanonicalPath().length() + 1, file.getCanonicalPath().length());
        zipFilePath = zipFilePath.replace("\\", "/");
        ZipEntry zipEntry = new ZipEntry(zipFilePath);
        zipEntry.setTime(file.lastModified());
        zos.putNextEntry(zipEntry);
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes, 0, 1024)) >= 0) {
            zos.write(bytes, 0, length);
        }
        zos.closeEntry();
        fis.close();
    }

    public static void jarDir(String name, String directory) throws IOException {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        JarOutputStream target = new JarOutputStream((OutputStream)new FileOutputStream(name), manifest);
        for (File file : new File(directory).listFiles()) {
            FileSystemUtils.add(directory, file, target);
        }
        target.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void add(String directory, File source, JarOutputStream target) throws IOException {
        try (BufferedInputStream in = null;){
            int count;
            if (source.isDirectory()) {
                String name;
                try {
                    name = source.getCanonicalPath().substring(new File(directory).getCanonicalPath().length() + 1, source.getCanonicalPath().length());
                    name = name.replace("\\", "/");
                }
                catch (Exception e) {
                    LOG.log(Level.INFO, e.getMessage(), e);
                    name = "";
                }
                if (!name.isEmpty()) {
                    if (!name.endsWith("/")) {
                        name = name + "/";
                    }
                    JarEntry entry = new JarEntry(name);
                    entry.setTime(source.lastModified());
                    target.putNextEntry(entry);
                    target.closeEntry();
                }
                for (File nestedFile : source.listFiles()) {
                    FileSystemUtils.add(directory, nestedFile, target);
                }
                return;
            }
            String name = source.getCanonicalPath().substring(new File(directory).getCanonicalPath().length() + 1, source.getCanonicalPath().length());
            JarEntry entry = new JarEntry(name.replace("\\", "/"));
            entry.setTime(source.lastModified());
            target.putNextEntry(entry);
            in = new BufferedInputStream(new FileInputStream(source));
            byte[] buffer = new byte[1024];
            while ((count = in.read(buffer)) != -1) {
                target.write(buffer, 0, count);
            }
            target.closeEntry();
        }
    }

    public static void extractJar(String jarFile, File destDir) {
        try {
            JarFile jar = new JarFile(jarFile);
            Enumeration<JarEntry> enumEntries = jar.entries();
            while (enumEntries.hasMoreElements()) {
                JarEntry file = enumEntries.nextElement();
                File f = new File(destDir + File.separator + file.getName());
                if (file.isDirectory()) continue;
                f.getParentFile().mkdirs();
                InputStream is = jar.getInputStream(file);
                FileOutputStream fos = new FileOutputStream(f);
                while (is.available() > 0) {
                    fos.write(is.read());
                }
                fos.close();
                is.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

