/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara;

import io.intino.tara.CompilationInfoExtractor;
import io.intino.tara.compiler.TaraCompiler;
import io.intino.tara.compiler.core.CompilationUnit;
import io.intino.tara.compiler.core.CompilerConfiguration;
import io.intino.tara.compiler.core.CompilerMessage;
import io.intino.tara.compiler.core.SourceUnit;
import io.intino.tara.compiler.shared.Configuration;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class TaraCompilerRunner {
    private final boolean verbose;

    TaraCompilerRunner(boolean verbose) {
        this.verbose = verbose;
    }

    boolean run(File argsFile) {
        CompilerConfiguration config = new CompilerConfiguration();
        config.setVerbose(this.verbose);
        LinkedHashMap<File, Boolean> sources = new LinkedHashMap<File, Boolean>();
        CompilationInfoExtractor.getInfoFromArgsFile(argsFile, config, sources);
        if (sources.isEmpty()) {
            return true;
        }
        if (this.verbose) {
            System.out.println("@#$%@# Presentable:Tarac: loading sources...");
        }
        ArrayList<CompilerMessage> messages = new ArrayList<CompilerMessage>();
        List<TaraCompiler.OutputItem> compiled = this.compile(config, sources, messages);
        if (this.verbose) {
            this.report(sources, compiled);
        }
        TaraCompilerRunner.processErrors(messages);
        return false;
    }

    boolean run(CompilerConfiguration config, File source) {
        config.setVerbose(this.verbose);
        if (this.verbose) {
            System.out.println("@#$%@# Presentable:Tarac: loading sources...");
        }
        ArrayList<CompilerMessage> messages = new ArrayList<CompilerMessage>();
        Map<File, Boolean> sources = Collections.singletonMap(source, true);
        List<TaraCompiler.OutputItem> compiled = this.compile(config, sources, messages);
        if (this.verbose) {
            this.report(sources, compiled);
        }
        TaraCompilerRunner.processErrors(messages);
        return false;
    }

    private List<TaraCompiler.OutputItem> compile(CompilerConfiguration config, Map<File, Boolean> sources, List<CompilerMessage> messages) {
        ArrayList<TaraCompiler.OutputItem> compiled = new ArrayList<TaraCompiler.OutputItem>();
        if (!sources.values().contains(false)) {
            CompilationUnit.cleanOut(config);
        }
        if (!config.isTest()) {
            compiled.addAll(this.compileSources(config, sources, messages));
        } else {
            compiled.addAll(this.compileTests(config, sources, messages));
        }
        return compiled;
    }

    private List<TaraCompiler.OutputItem> compileSources(CompilerConfiguration config, Map<File, Boolean> sources, List<CompilerMessage> messages) {
        if (this.verbose) {
            System.out.println("@#$%@# Presentable:Tarac: Compiling model...");
        }
        System.out.println();
        CompilationUnit unit = new CompilationUnit(config);
        TaraCompilerRunner.addSources(sources, unit);
        return new TaraCompiler(messages).compile(unit);
    }

    private void report(Map<File, Boolean> srcFiles, List<TaraCompiler.OutputItem> compiled) {
        if (compiled.isEmpty()) {
            TaraCompilerRunner.reportNotCompiledItems(srcFiles);
        } else {
            TaraCompilerRunner.reportCompiledItems(compiled);
        }
        System.out.println();
    }

    private List<TaraCompiler.OutputItem> compileTests(CompilerConfiguration config, Map<File, Boolean> testFiles, List<CompilerMessage> compilerMessages) {
        if (testFiles.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.verbose) {
            System.out.println("@#$%@# Presentable:Tarac: compiling tests...");
        }
        CompilerConfiguration testConf = config.clone();
        testConf.setTest(true);
        if (config.outDSL() != null) {
            testConf.addLanguage(config.outDSL(), config.version());
        }
        if (config.level() != null) {
            testConf.level(Configuration.Level.values()[config.level().ordinal() == 0 ? 0 : config.level().ordinal() - 1]);
        }
        ArrayList<TaraCompiler.OutputItem> compiledFiles = new ArrayList<TaraCompiler.OutputItem>();
        for (Map.Entry<File, Boolean> file : testFiles.entrySet()) {
            CompilationUnit unit = new CompilationUnit(testConf);
            if (this.verbose) {
                System.out.println("@#$%@# Presentable:Tarac: compiling test: " + file.getKey().getName());
            }
            unit.addSource(new SourceUnit(file.getKey(), unit.getConfiguration(), unit.getErrorCollector(), file.getValue()));
            compiledFiles.addAll(new TaraCompiler(compilerMessages).compile(unit));
            System.out.println();
        }
        return compiledFiles;
    }

    private static void processErrors(List<CompilerMessage> compilerMessages) {
        int errorCount = 0;
        for (CompilerMessage message : compilerMessages) {
            if (message.getCategory().equals("error")) {
                if (errorCount > 100) continue;
                ++errorCount;
            }
            TaraCompilerRunner.printMessage(message);
        }
    }

    private static void addSources(Map<File, Boolean> srcFiles, CompilationUnit unit) {
        srcFiles.entrySet().forEach(file -> unit.addSource(new SourceUnit((File)file.getKey(), unit.getConfiguration(), unit.getErrorCollector(), (Boolean)file.getValue())));
    }

    private static void printMessage(CompilerMessage message) {
        System.out.print("%%m");
        System.out.print(message.getCategory());
        System.out.print("#%%#%%%#%%%%%%%%%#");
        System.out.print(message.getMessage());
        System.out.print("#%%#%%%#%%%%%%%%%#");
        System.out.print(message.getUrl());
        System.out.print("#%%#%%%#%%%%%%%%%#");
        System.out.print(message.getLineNum());
        System.out.print("#%%#%%%#%%%%%%%%%#");
        System.out.print(message.getColumnNum());
        System.out.print("#%%#%%%#%%%%%%%%%#");
        System.out.print("/%m");
        System.out.println();
    }

    private static void reportCompiledItems(List<TaraCompiler.OutputItem> compiledFiles) {
        for (TaraCompiler.OutputItem compiledFile : compiledFiles) {
            System.out.print("%%c");
            System.out.print(compiledFile.getOutputPath());
            System.out.print("#%%#%%%#%%%%%%%%%#");
            System.out.print(compiledFile.getSourceFile());
            System.out.print("/%c");
            System.out.println();
        }
    }

    private static void reportNotCompiledItems(Map<File, Boolean> toRecompile) {
        for (File file : toRecompile.keySet()) {
            System.out.print("%%rc");
            System.out.print(file.getAbsolutePath());
            System.out.print("/%rc");
            System.out.println();
        }
    }
}

