/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.semantic;

import io.intino.tara.Checker;
import io.intino.tara.Resolver;
import io.intino.tara.compiler.model.Model;
import io.intino.tara.compiler.model.NodeImpl;
import io.intino.tara.lang.model.Node;
import io.intino.tara.lang.semantics.errorcollector.SemanticException;
import io.intino.tara.lang.semantics.errorcollector.SemanticFatalException;
import java.util.ArrayList;
import java.util.List;

public class SemanticAnalyzer {
    private final Model model;
    private final Resolver resolver;
    private Checker checker;
    private List<SemanticException> notifications;

    public SemanticAnalyzer(Model model) {
        this.model = model;
        this.resolver = new Resolver(model.getLanguage());
        this.checker = new Checker(model.getLanguage());
        this.notifications = new ArrayList<SemanticException>();
    }

    public void analyze() throws SemanticFatalException {
        this.resolveTypes((Node)this.model);
        this.checkNode((Node)this.model);
        this.check((Node)this.model);
        if (!this.notifications.isEmpty()) {
            throw new SemanticFatalException(this.notifications);
        }
    }

    private void resolveTypes(Node node) {
        node.components().forEach(this::resolveNode);
    }

    private void check(Node node) {
        node.components().forEach(this::checkNode);
    }

    private void resolveNode(Node node) {
        this.resolver.resolve(node);
        if (node instanceof NodeImpl) {
            this.resolveTypes(node);
        }
    }

    private void checkNode(Node node) {
        block3: {
            try {
                this.checker.check(node);
                if (node instanceof NodeImpl) {
                    this.check(node);
                }
            }
            catch (SemanticFatalException e) {
                this.notifications.addAll(e.exceptions());
                if (this.hasFatal(e.exceptions()) || !(node instanceof NodeImpl)) break block3;
                this.check(node);
            }
        }
    }

    private boolean hasFatal(List<SemanticException> exceptions) {
        for (SemanticException exception : exceptions) {
            if (!exception.isFatal()) continue;
            return true;
        }
        return false;
    }
}

