/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.model;

import io.intino.tara.lang.model.Node;
import io.intino.tara.lang.model.NodeContainer;
import io.intino.tara.lang.model.NodeRoot;
import io.intino.tara.lang.model.Parameter;
import io.intino.tara.lang.model.Primitive;
import io.intino.tara.lang.model.Tag;
import io.intino.tara.lang.model.Variable;
import io.intino.tara.lang.model.rules.variable.VariableRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ParameterImpl
implements Parameter {
    private final List<Object> values = new ArrayList<Object>();
    private String name;
    private int position;
    private String facet = "";
    private String scope;
    private String file;
    private int line;
    private int column;
    private String metric = "";
    private VariableRule rule;
    private Primitive inferredType;
    private boolean multiple;
    private boolean hasReferenceValue = false;
    private List<Tag> flags = new ArrayList<Tag>();
    private Node container;
    private String uid;

    public ParameterImpl(String name, int position, String metric, List<Object> values) {
        this.name = name;
        this.position = position;
        this.metric = metric == null ? "" : metric;
        this.addValues(values);
    }

    public ParameterImpl(int position, String metric, List<Object> values) {
        this("", position, metric, values);
    }

    public Node container() {
        return this.container;
    }

    public void owner(Node owner) {
        this.container = owner;
    }

    public Primitive type() {
        return this.inferredType;
    }

    public void type(Primitive type) {
        this.inferredType = type;
        this.hasReferenceValue = Primitive.REFERENCE.equals((Object)this.inferredType);
    }

    public String facet() {
        return this.facet;
    }

    public void facet(String facet) {
        this.facet = facet;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public void multiple(boolean multiple) {
        this.multiple = multiple;
    }

    public List<Tag> flags() {
        return Collections.unmodifiableList(this.flags);
    }

    public void flags(List<Tag> flags) {
        this.flags = flags;
    }

    public String name() {
        return this.name;
    }

    public void name(String name) {
        this.name = name;
    }

    public int position() {
        return this.position;
    }

    public List<Object> values() {
        return Collections.unmodifiableList(this.makeUp(this.model().resourcesRoot(), this.inferredType, this.values));
    }

    private NodeRoot model() {
        Node container = this.container;
        while (!(container instanceof NodeRoot)) {
            container = container.container();
        }
        return (NodeRoot)container;
    }

    public void values(List<Object> objects) {
        this.addValues(objects);
    }

    public VariableRule rule() {
        return this.rule;
    }

    public void rule(VariableRule rule) {
        this.rule = rule;
    }

    public void scope(String scope) {
        this.scope = scope;
    }

    public String scope() {
        return this.scope;
    }

    public String file() {
        return this.file;
    }

    public void file(String file) {
        this.file = file;
    }

    public int line() {
        return this.line;
    }

    public void line(int line) {
        this.line = line;
    }

    public int column() {
        return this.column;
    }

    public void column(int column) {
        this.column = column;
    }

    public String metric() {
        return this.metric;
    }

    public void metric(String metric) {
        this.metric = metric == null ? "" : metric;
    }

    public boolean isVariableInit() {
        return false;
    }

    public boolean hasReferenceValue() {
        return this.hasReferenceValue;
    }

    public String toString() {
        return this.name + ":" + this.position + ":" + this.values;
    }

    public void substituteValues(List<?> newValues) {
        this.addValues(newValues);
    }

    public String getUID() {
        if (this.uid == null) {
            this.uid = Variable.NativeCounter.next((NodeContainer)this.container(), (String)this.name()) + "";
        }
        return this.uid;
    }

    private void addValues(List<Object> values) {
        this.values.clear();
        this.values.addAll(values);
    }
}

