/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.dependencyresolution;

import io.intino.tara.compiler.codegeneration.FileSystemUtils;
import io.intino.tara.compiler.model.Model;
import io.intino.tara.compiler.model.NodeImpl;
import io.intino.tara.compiler.model.NodeReference;
import io.intino.tara.compiler.model.VariableReference;
import io.intino.tara.lang.model.FacetTarget;
import io.intino.tara.lang.model.Node;
import io.intino.tara.lang.model.NodeContainer;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ReferenceManager {
    private Model model;

    ReferenceManager(Model model) {
        this.model = model;
    }

    public NodeImpl resolve(NodeReference reference) {
        return (NodeImpl)this.resolve(reference.getReference(), reference.container());
    }

    Node resolve(FacetTarget target, Node owner) {
        Node result = this.resolve(target.target(), owner);
        return result instanceof NodeReference ? ((NodeReference)result).getDestiny() : result;
    }

    NodeImpl resolve(VariableReference variable, Node container) {
        Node result = this.resolve(variable.destinyName(), container);
        return result instanceof NodeReference ? ((NodeReference)result).getDestiny() : (NodeImpl)result;
    }

    Node resolve(String reference, Node node) {
        String[] path = reference.split("\\.");
        Collection<Node> roots = this.findRoots(node, path);
        if (roots.isEmpty()) {
            return null;
        }
        if (roots.size() == 1 && path.length == 1) {
            return roots.iterator().next();
        }
        for (Node root : roots) {
            Node candidate = this.resolvePathInNode(path, root);
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    private Collection<Node> findRoots(Node node, String[] path) {
        Collection<Node> roots = this.searchPossibleRoots(node, path[0], false);
        if (!roots.isEmpty()) {
            return roots;
        }
        for (Node root : this.model.components()) {
            if (!FileSystemUtils.getNameWithoutExtension(new File(root.file()).getName()).equals(path[0])) continue;
            roots = this.searchPossibleRoots(root, path[1], false);
            break;
        }
        return roots;
    }

    Node resolveFacetConstraint(String facet, String target) {
        for (Node node : this.model.components()) {
            if (!facet.equals(node.name()) || node.facetTarget() == null || !target.equals(node.facetTarget().target())) continue;
            return node;
        }
        return null;
    }

    Node resolveParent(String reference, Node node) {
        String[] path = reference.split("\\.");
        Collection<Node> roots = this.searchPossibleRoots(node, path[0], true);
        if (roots.isEmpty()) {
            return null;
        }
        if (roots.size() == 1 && path.length == 1) {
            return roots.iterator().next();
        }
        for (Node root : roots) {
            Node candidate = this.resolvePathInNode(path, root);
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    private Node resolvePathInNode(String[] path, Node node) {
        Node reference = null;
        for (String name : path) {
            if (reference == null) {
                reference = ReferenceManager.areNamesake(name, node) ? node : null;
                continue;
            }
            List components = reference.component(name);
            if (components.isEmpty() && reference.parent() != null) {
                reference = (Node)reference.parent().component(name).get(0);
            } else {
                Node node2 = reference = components.isEmpty() ? null : (Node)components.get(0);
            }
            if (reference != null) continue;
            return null;
        }
        return reference;
    }

    private static boolean areNamesake(String name, Node node) {
        return name.equals(node.name());
    }

    private Collection<Node> searchPossibleRoots(Node node, String name, boolean parent) {
        LinkedHashSet<Node> set = new LinkedHashSet<Node>();
        String[] names = name.split("\\+");
        this.namesake(names[0], set, (NodeContainer)node);
        this.addInContext(names[0], set, node, parent);
        ReferenceManager.addNodeSiblings(names[0], node, set);
        this.addRoots(names[0], set);
        return names.length == 1 || set.isEmpty() ? set : this.filterByFacet(set, names[1]);
    }

    private Collection<Node> filterByFacet(Set<Node> set, String name) {
        return set.stream().filter(node -> {
            FacetTarget target = node.facetTarget() == null ? this.findTargetInParent((Node)node) : node.facetTarget();
            return target != null && (target.target().endsWith("." + name) || target.target().equals(name));
        }).collect(Collectors.toSet());
    }

    private FacetTarget findTargetInParent(Node node) {
        for (Node parent = node.parent(); parent != null; parent = parent.parent()) {
            if (parent.facetTarget() == null) continue;
            return parent.facetTarget();
        }
        return null;
    }

    private static void addNodeSiblings(String identifier, Node container, Set<Node> set) {
        if (container == null) {
            return;
        }
        set.addAll(container.components().stream().filter(node -> ReferenceManager.areNamesake(identifier, node)).collect(Collectors.toList()));
    }

    private void addRoots(String name, Set<Node> set) {
        set.addAll(this.model.components().stream().filter(node -> ReferenceManager.areNamesake(name, node)).collect(Collectors.toList()));
    }

    private void addInContext(String name, Set<Node> set, Node node, boolean parent) {
        this.checkSiblings(name, set, node);
        for (Node container = node.container(); container != null; container = container.container()) {
            Node parentNode;
            this.namesake(name, set, (NodeContainer)container);
            this.checkSiblings(name, set, container);
            if (!parent || (parentNode = node.parent()) == null) continue;
            ReferenceManager.collectParentComponents(name, set, container, parentNode);
        }
    }

    private static void collectParentComponents(String identifier, Set<Node> set, Node container, Node parent) {
        set.addAll(parent.components().stream().filter(sibling -> ReferenceManager.areNamesake(identifier, sibling) && !sibling.equals((Object)container)).collect(Collectors.toList()));
    }

    private void checkSiblings(String name, Set<Node> set, Node container) {
        for (Node sibling : container.siblings()) {
            this.namesake(name, set, (NodeContainer)sibling);
        }
    }

    private void namesake(String name, Set<Node> set, NodeContainer container) {
        if (container instanceof NodeImpl && this.namesake((Node)container, name)) {
            set.add((Node)container);
        }
    }

    private boolean namesake(Node node, String name) {
        return ReferenceManager.areNamesake(name, node);
    }
}

