/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.dependencyresolution;

import io.intino.tara.compiler.core.errorcollection.DependencyException;
import io.intino.tara.compiler.model.FacetTargetImpl;
import io.intino.tara.compiler.model.Model;
import io.intino.tara.compiler.model.NodeImpl;
import io.intino.tara.compiler.model.NodeReference;
import io.intino.tara.lang.model.Element;
import io.intino.tara.lang.model.Facet;
import io.intino.tara.lang.model.FacetTarget;
import io.intino.tara.lang.model.Flags;
import io.intino.tara.lang.model.Node;
import io.intino.tara.lang.model.NodeContainer;
import io.intino.tara.lang.model.Rule;
import io.intino.tara.lang.model.Tag;
import io.intino.tara.lang.model.Variable;
import io.intino.tara.lang.model.rules.Size;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class InheritanceResolver {
    private static final Logger LOG = Logger.getGlobal();
    private Model model;

    public InheritanceResolver(Model model) {
        this.model = model;
    }

    public void resolve() throws DependencyException {
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.addAll(this.collectNodes(this.model));
        this.sort(nodes);
        this.model.components().forEach(this::resolveAsMetaFacet);
        for (Node node : nodes) {
            this.resolve(node);
        }
        this.model.components().forEach(this::resolveAsFacetTargetFragment);
        this.mergeFragmentNodes(this.model);
    }

    private void resolve(Node node) throws DependencyException {
        List<Node> children = this.getChildrenSorted(node);
        if (!children.isEmpty() && !node.isAbstract() && node.isSub()) {
            node.addFlag(Tag.Abstract);
        }
        for (Node child : children) {
            this.resolve(node, child);
        }
        this.resolveAsFacetTargetFragment(node);
    }

    private void resolveAsMetaFacet(Node node) {
        if (node.type().startsWith("MetaFacet:") && node.facetTarget() != null && !node.facetTarget().targetNode().children().isEmpty()) {
            for (Node child : node.facetTarget().targetNode().children()) {
                node.container().add(this.createChildMetaFacet(node, child), node.container().rulesOf(node));
            }
        }
    }

    private Node createChildMetaFacet(Node node, Node child) {
        NodeImpl metaFacet = new NodeImpl();
        metaFacet.setVirtual(true);
        metaFacet.setDirty(true);
        metaFacet.file(node.file());
        metaFacet.line(node.line());
        metaFacet.column(node.column());
        metaFacet.doc(node.doc());
        metaFacet.container(node.container());
        metaFacet.name(node.name());
        metaFacet.type(node.type());
        metaFacet.setParent(node);
        FacetTargetImpl target = new FacetTargetImpl();
        target.targetNode(child);
        target.target(child.qualifiedName());
        target.setConstraints(node.facetTarget().constraints());
        target.owner(metaFacet);
        metaFacet.facetTarget(target);
        return metaFacet;
    }

    private void resolve(Node node, Node child) throws DependencyException {
        this.resolveComponents(node, child);
        this.resolveVariables(node, child);
        this.resolveFlags(node, child);
        this.resolveAnnotations(node, child);
        this.resolveAllowedFacets(node, child);
        this.resolveAppliedFacets(node, child);
        this.resolveFacetTarget(node, child);
        this.resolveNodeRules(node, child);
        this.resolve(child);
    }

    private void mergeFragmentNodes(Model model) throws DependencyException {
        Map<String, List<Node>> toMerge = this.fragmentNodes(model);
        for (List<Node> nodes : toMerge.values()) {
            this.merge(nodes);
        }
    }

    private void merge(List<Node> nodes) throws DependencyException {
        if (nodes.size() < 2) {
            return;
        }
        if (!this.correctParent(nodes)) {
            throw new DependencyException("Error merging extension elements. Parents are not homogeneous.", (Element)nodes.get(0), new String[0]);
        }
        Node parent = this.selectParent(nodes);
        if (parent == null) {
            return;
        }
        ArrayList<Node> receivers = new ArrayList<Node>(nodes);
        receivers.remove(parent);
        for (Node node : receivers) {
            ((NodeImpl)node).absorb((NodeImpl)parent);
        }
    }

    private boolean correctParent(List<Node> nodes) {
        String parent = nodes.get(0).parentName() == null ? "" : nodes.get(0).parentName();
        for (Node node : nodes) {
            if (parent.equals(node.parentName() == null ? "" : node.parentName())) continue;
            return false;
        }
        return true;
    }

    private Node selectParent(List<Node> nodes) {
        for (Node node : nodes) {
            if (node.facetTarget() == null || !node.facetTarget().targetNode().isAbstract() || this.hasParent(node, nodes)) continue;
            return node;
        }
        return null;
    }

    private boolean hasParent(Node node, List<Node> nodes) {
        for (Node candidate : nodes) {
            if (!candidate.equals((Object)node.parent())) continue;
            return true;
        }
        return false;
    }

    private Map<String, List<Node>> fragmentNodes(Model model) {
        LinkedHashMap<String, List<Node>> toMerge = new LinkedHashMap<String, List<Node>>();
        for (Node node : model.components()) {
            if (node.isAnonymous()) continue;
            if (!toMerge.containsKey(node.name())) {
                toMerge.put(node.name(), new ArrayList());
            }
            ((List)toMerge.get(node.name())).add(node);
        }
        return toMerge;
    }

    private void resolveAsFacetTargetFragment(Node node) {
        if (node.facetTarget() == null || node.facetTarget().parent() == null) {
            return;
        }
        this.resolveComponents(node.facetTarget().parent(), node);
        this.resolveVariables(node.facetTarget().parent(), node);
    }

    private void resolveNodeRules(Node parent, Node child) {
        List parentRules = parent.container().rulesOf(parent);
        List childRules = child.container().rulesOf(child);
        Size size = child.container().sizeOf(child);
        for (Rule rule : parentRules) {
            if (!(rule instanceof Size)) {
                childRules.add(rule);
                continue;
            }
            if (!this.isMoreRestrictiveThan((Size)rule, size)) continue;
            childRules.remove(size);
            childRules.add(rule);
        }
    }

    private boolean isMoreRestrictiveThan(Size parent, Size child) {
        return parent.min() > child.min() || parent.max() < child.max();
    }

    private void resolveAllowedFacets(Node parent, Node child) {
        child.addAllowedFacets(parent.allowedFacets().toArray(new String[parent.allowedFacets().size()]));
    }

    private void resolveAppliedFacets(Node parent, Node child) {
        parent.facets().stream().filter(facet -> !this.isOverridden(child, (Facet)facet)).forEach(xva$0 -> child.addFacets(new Facet[]{xva$0}));
    }

    private void resolveFacetTarget(Node parent, Node child) {
        if (parent.facetTarget() != null && child.facetTarget() == null) {
            try {
                FacetTargetImpl clone = ((FacetTargetImpl)parent.facetTarget()).clone();
                clone.inherited(true);
                clone.owner(child);
                child.facetTarget((FacetTarget)clone);
            }
            catch (CloneNotSupportedException e) {
                LOG.severe(e.getMessage());
            }
            if (child.isSub()) {
                child.parent().children().stream().filter(sibling -> !sibling.equals((Object)child)).forEach(s -> child.facetTarget().constraints().add(this.rejectSiblings((Node)s)));
            }
        }
    }

    private FacetTarget.Constraint rejectSiblings(final Node node) {
        return new FacetTarget.Constraint(){

            public String name() {
                return node.qualifiedName();
            }

            public Node node() {
                return node;
            }

            public void node(Node node2) {
            }

            public boolean negated() {
                return true;
            }

            public String toString() {
                return "without " + node.qualifiedName();
            }

            public FacetTarget.Constraint clone() throws CloneNotSupportedException {
                return (FacetTarget.Constraint)super.clone();
            }
        };
    }

    private boolean isOverridden(Node child, Facet facet) {
        for (Facet childFacet : child.facets()) {
            if (!childFacet.type().equals(facet.type())) continue;
            return true;
        }
        return false;
    }

    private Set<Node> collectNodes(Model model) {
        HashSet<Node> collection = new HashSet<Node>();
        for (Node node : model.components()) {
            if (!node.children().isEmpty()) {
                collection.add(node);
            }
            this.collect(node, collection);
        }
        return collection;
    }

    private void collect(Node node, Set<Node> collection) {
        if (!(node instanceof NodeImpl)) {
            return;
        }
        if (!node.children().isEmpty()) {
            collection.add(node);
        }
        for (Node component : node.components()) {
            this.collect(component, collection);
        }
    }

    private List<Node> resolveComponents(Node parent, Node child) {
        LinkedHashMap<NodeReference, List> nodes = new LinkedHashMap<NodeReference, List>();
        for (Node node : parent.components()) {
            if (this.isOverridden((NodeContainer)child, node)) continue;
            NodeReference reference = node.isReference() ? new NodeReference(((NodeReference)node).getDestiny()) : new NodeReference((NodeImpl)node);
            this.addTags(node, reference);
            reference.setHas(false);
            reference.file(child.file());
            reference.line(child.line());
            reference.container(child);
            nodes.put(reference, node.container().rulesOf(node));
        }
        for (Map.Entry entry : nodes.entrySet()) {
            child.add((Node)entry.getKey(), (List)entry.getValue());
        }
        return new ArrayList<Node>(nodes.keySet());
    }

    private void addTags(Node component, NodeReference reference) {
        component.flags().stream().filter(tag -> !reference.flags().contains(tag) && Flags.forReference().contains(tag)).forEach(reference::addFlag);
        component.annotations().stream().filter(tag -> !reference.annotations().contains(tag)).forEach(xva$0 -> reference.addAnnotations((Tag)xva$0));
    }

    private void resolveFlags(Node parent, Node child) {
        parent.flags().stream().filter(tag -> !tag.equals((Object)Tag.Abstract) && !child.flags().contains(tag)).forEach(arg_0 -> ((Node)child).addFlag(arg_0));
    }

    private void resolveAnnotations(Node parent, Node child) {
        parent.annotations().stream().filter(tag -> !tag.equals((Object)Tag.Abstract) && !child.annotations().contains(tag)).forEach(xva$0 -> child.addAnnotations(new Tag[]{xva$0}));
    }

    private void resolveVariables(Node parent, Node child) {
        ArrayList<Variable> variables = new ArrayList<Variable>();
        for (Variable variable : parent.variables()) {
            if (this.isOverridden(child, variable)) {
                Variable overridenVariable = this.findVariable(child, variable.name());
                overridenVariable.addFlags(variable.flags().toArray(new Tag[variable.flags().size()]));
                overridenVariable.overriden(true);
                continue;
            }
            variables.add(variable.cloneIt(child));
        }
        child.add(0, variables.toArray(new Variable[variables.size()]));
    }

    private Variable findVariable(Node child, String name) {
        for (Variable variable : child.variables()) {
            if (!variable.name().equals(name)) continue;
            return variable;
        }
        return null;
    }

    private boolean isOverridden(NodeContainer child, Node node) {
        for (Node c : child.components()) {
            if (this.isHasReference(c) || !this.areNamesake(node, c) || !c.type().equals(node.type())) continue;
            if (c instanceof NodeImpl && c.parent() == null) {
                ((NodeImpl)c).setParent(node);
            }
            return true;
        }
        return false;
    }

    private boolean areNamesake(Node node, Node c) {
        return c.name() != null && c.name().equals(node.name());
    }

    private boolean isHasReference(Node component) {
        return component instanceof NodeReference && ((NodeReference)component).isHas();
    }

    private boolean isOverridden(Node child, Variable variable) {
        for (Variable childVar : child.variables()) {
            if (!childVar.name().equals(variable.name()) || !childVar.type().equals((Object)variable.type())) continue;
            return true;
        }
        return false;
    }

    private List<Node> getChildrenSorted(Node parent) {
        List<Node> children = parent.children().stream().map(node -> node).collect(Collectors.toList());
        this.sort(children);
        return children;
    }

    private void sort(List<Node> nodes) {
        if (nodes.isEmpty()) {
            return;
        }
        Collections.sort(nodes, this.inheritanceComparator());
        Collections.reverse(nodes);
    }

    private Comparator<Node> inheritanceComparator() {
        return new Comparator<Node>(){

            @Override
            public int compare(Node o1, Node o2) {
                return this.maxLevel(o1) - this.maxLevel(o2);
            }

            private int maxLevel(Node node) {
                ArrayList<Integer> levels = new ArrayList<Integer>(Collections.singletonList(0));
                levels.addAll(node.children().stream().map(child -> this.maxLevel((Node)child)).collect(Collectors.toList()));
                Collections.sort(levels, Collections.reverseOrder());
                return 1 + (Integer)levels.get(0);
            }

            @Override
            public boolean equals(Object obj) {
                return false;
            }

            public int hashCode() {
                return super.hashCode();
            }
        };
    }
}

