/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.dependencyresolution;

import io.intino.tara.compiler.core.errorcollection.DependencyException;
import io.intino.tara.compiler.model.Model;
import io.intino.tara.compiler.model.NodeImpl;
import io.intino.tara.lang.model.FacetTarget;
import io.intino.tara.lang.model.Node;
import java.util.List;

public class FacetTargetResolver {
    private final Model model;

    public FacetTargetResolver(Model model) {
        this.model = model;
    }

    public void resolve() throws DependencyException {
        this.resolve((Node)this.model);
    }

    private void resolve(Node node) {
        node.components().stream().filter(component -> component instanceof NodeImpl).forEach(component -> {
            this.resolveFacetTarget((Node)component);
            this.resolve((Node)component);
        });
    }

    private void resolveFacetTarget(Node node) {
        if (node.facetTarget() != null) {
            node.facetTarget().targetNode().addAllowedFacets(new String[]{node.name()});
            this.addToChildren(node, node.facetTarget());
            this.addToFacetTargets(node.facetTarget().targetNode(), node.name());
        }
    }

    private void addToFacetTargets(Node node, String name) {
        node.container().components().stream().filter(component -> !component.isAnonymous() && component.name().equals(node.name()) && !component.equals((Object)node) && component.facetTarget() != null).forEach(component -> component.addAllowedFacets(new String[]{name}));
    }

    private void addToChildren(Node node, FacetTarget target) {
        this.propagate(node, target.targetNode().children());
    }

    private void propagate(Node node, List<Node> children) {
        for (Node child : children) {
            child.addAllowedFacets(new String[]{node.name()});
            this.propagate(node, child.children());
        }
    }
}

