/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.dependencyresolution;

import io.intino.tara.Language;
import io.intino.tara.compiler.core.errorcollection.DependencyException;
import io.intino.tara.compiler.core.errorcollection.TaraException;
import io.intino.tara.compiler.dependencyresolution.CustomRuleLoader;
import io.intino.tara.compiler.dependencyresolution.ReferenceManager;
import io.intino.tara.compiler.model.Model;
import io.intino.tara.compiler.model.NodeImpl;
import io.intino.tara.compiler.model.NodeReference;
import io.intino.tara.compiler.model.VariableReference;
import io.intino.tara.lang.model.Element;
import io.intino.tara.lang.model.FacetTarget;
import io.intino.tara.lang.model.Node;
import io.intino.tara.lang.model.NodeContainer;
import io.intino.tara.lang.model.Parameter;
import io.intino.tara.lang.model.Parametrized;
import io.intino.tara.lang.model.Primitive;
import io.intino.tara.lang.model.Rule;
import io.intino.tara.lang.model.Variable;
import io.intino.tara.lang.model.rules.CustomRule;
import io.intino.tara.lang.model.rules.variable.ReferenceRule;
import io.intino.tara.lang.model.rules.variable.VariableCustomRule;
import io.intino.tara.lang.model.rules.variable.VariableRule;
import io.intino.tara.lang.model.rules.variable.WordRule;
import io.intino.tara.lang.semantics.DeclarationContext;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DependencyResolver {
    private final File rulesDirectory;
    private final File semanticLib;
    private final File tempDirectory;
    private Model model;
    private ReferenceManager manager;
    private Map<String, Class<?>> loadedRules = new HashMap();
    private String workingPackage;

    public DependencyResolver(Model model, String workingPackage, File rulesDirectory, File semanticLib, File tempDirectory) throws DependencyException {
        this.model = model;
        this.workingPackage = workingPackage;
        this.rulesDirectory = rulesDirectory;
        this.semanticLib = semanticLib;
        this.tempDirectory = tempDirectory;
        this.manager = new ReferenceManager(this.model);
        model.setRules(this.loadedRules);
    }

    public void resolve() throws DependencyException {
        this.resolveParentReference((Node)this.model);
        this.resolveInNodes((Node)this.model);
        this.resolveFacetTargets((Node)this.model);
    }

    private void resolveParentReference(Node node) throws DependencyException {
        if (node instanceof NodeReference) {
            return;
        }
        this.resolveParent(node);
        if (node.facetTarget() != null) {
            this.resolveParent(node.facetTarget());
        }
        for (Node component : node.components()) {
            this.resolveParentReference(component);
        }
    }

    private void resolveParent(FacetTarget facetTarget) {
        Node owner = facetTarget.owner();
        for (Node component : owner.container().components()) {
            if (component.name() == null || !component.name().equals(owner.name()) || !component.isAbstract() || component.equals((Object)owner) || component.facetTarget() != null) continue;
            facetTarget.parent(component);
            component.addChild(facetTarget.owner());
            return;
        }
    }

    private void resolveInNodes(Node node) throws DependencyException {
        this.resolveCustomRules(node);
        for (Node component : node.components()) {
            this.resolve(component);
        }
    }

    private void resolveFacetTargets(Node node) throws DependencyException {
        if (node instanceof NodeReference) {
            return;
        }
        this.resolveInTargets(node);
    }

    private void resolve(Node node) throws DependencyException {
        if (!(node instanceof NodeImpl)) {
            return;
        }
        this.resolveComponentReferenceNodes(node);
        this.resolveVariables(node);
        this.resolveParametersReference((Parametrized)node);
        this.resolveInNodes(node);
    }

    private void resolveCustomRules(Node node) throws DependencyException {
        if (node.container() == null) {
            return;
        }
        for (Rule rule : node.container().rulesOf(node)) {
            if (!(rule instanceof CustomRule)) continue;
            this.loadCustomRule(node, (CustomRule)rule);
        }
    }

    private void resolveParametersReference(Parametrized parametrized) throws DependencyException {
        for (Parameter parameter : parametrized.parameters()) {
            this.resolveParameterValue((Node)parametrized, parameter);
        }
    }

    private void resolveParameterValue(Node node, Parameter parameter) throws DependencyException {
        if (parameter.values().isEmpty() || !this.areReferenceValues(parameter)) {
            return;
        }
        ArrayList<Object> nodes = new ArrayList<Object>();
        for (Object value : parameter.values()) {
            Node reference = this.resolveReferenceParameter(node, (Primitive.Reference)value);
            if (reference != null) {
                nodes.add(reference);
                continue;
            }
            if (!this.tryWithAnInstance((Primitive.Reference)value)) continue;
            nodes.add(value);
        }
        if (!nodes.isEmpty()) {
            parameter.type(Primitive.REFERENCE);
            parameter.substituteValues(nodes);
        }
    }

    private boolean tryWithAnInstance(Primitive.Reference value) {
        Language language = this.model.getLanguage();
        if (language != null && language.instances().keySet().contains(value.get())) {
            value.setToInstance(true);
            value.instanceTypes(((DeclarationContext)language.instances().get(value.get())).types());
            value.path(((DeclarationContext)language.instances().get(value.get())).path());
            return true;
        }
        return false;
    }

    private Node resolveReferenceParameter(Node node, Primitive.Reference reference) throws DependencyException {
        return this.manager.resolve(reference.get(), node);
    }

    private boolean areReferenceValues(Parameter parameter) {
        return parameter.values().get(0) instanceof Primitive.Reference;
    }

    private void resolveParent(Node node) throws DependencyException {
        if (node.parent() == null && node.parentName() != null) {
            Node parent = this.manager.resolveParent(node.parentName(), this.getNodeContainer((NodeContainer)node.container()));
            if (parent == null) {
                throw new DependencyException("reject.dependency.parent.node.not.found", (Element)node, new String[0]);
            }
            ((NodeImpl)node).setParent(parent);
            parent.addChild(node);
        }
    }

    private void resolveComponentReferenceNodes(Node node) throws DependencyException {
        for (Node nodeReference : node.referenceComponents()) {
            this.resolveNodeReference((NodeReference)nodeReference);
            this.resolveCustomRules(nodeReference);
        }
    }

    private void resolveNodeReference(NodeReference nodeReference) throws DependencyException {
        if (nodeReference.getDestiny() != null) {
            return;
        }
        NodeImpl destiny = this.manager.resolve(nodeReference);
        if (destiny == null) {
            throw new DependencyException("reject.dependency.reference.node.not.found", (Element)nodeReference, new String[0]);
        }
        nodeReference.setDestiny(destiny);
    }

    private void resolveInTargets(Node node) throws DependencyException {
        if (node.facetTarget() != null) {
            this.resolveFacetTarget(node.facetTarget());
            this.resolveConstraints(node.facetTarget());
        }
        for (Node component : node.components()) {
            this.resolveFacetTargets(component);
        }
    }

    private void resolveConstraints(FacetTarget facet) throws DependencyException {
        for (FacetTarget.Constraint constraint : facet.constraints()) {
            Node destiny = this.resolve(facet, constraint);
            if (destiny == null) {
                throw new DependencyException("reject.facet.target.not.found", (Element)facet, new String[0]);
            }
            constraint.node(destiny);
        }
    }

    private Node resolve(FacetTarget facet, FacetTarget.Constraint constraint) {
        Node resolve = this.manager.resolveFacetConstraint(constraint.name(), facet.targetNode().qualifiedName());
        return resolve == null ? this.manager.resolve(constraint.name(), facet.owner()) : resolve;
    }

    private void resolveVariables(Node container) throws DependencyException {
        for (Variable variable : container.variables()) {
            if (variable instanceof VariableReference) {
                this.resolveVariable((VariableReference)variable, container);
            }
            if (!(variable.rule() instanceof VariableCustomRule)) continue;
            this.loadCustomRule(variable);
        }
    }

    private void loadCustomRule(Variable variable) throws DependencyException {
        Class<?> aClass;
        VariableCustomRule rule = (VariableCustomRule)variable.rule();
        String source = rule.getSource();
        try {
            aClass = this.loadedRules.containsKey(source) ? this.loadedRules.get(source) : CustomRuleLoader.compileAndLoad((CustomRule)rule, this.workingPackage, this.rulesDirectory, this.semanticLib, this.tempDirectory);
        }
        catch (TaraException e) {
            throw new DependencyException("impossible.load.rule.class", (Element)variable, rule.getSource(), e.getMessage());
        }
        if (aClass == null) {
            throw new DependencyException("impossible.load.rule.class", (Element)variable, rule.getSource());
        }
        this.loadedRules.put(source, aClass);
        if (variable.type().equals((Object)Primitive.WORD)) {
            this.updateRule(aClass, variable);
        } else {
            rule.setLoadedClass(aClass);
        }
    }

    private void loadCustomRule(Node node, CustomRule rule) throws DependencyException {
        Class<?> aClass;
        String source = rule.getSource();
        try {
            aClass = this.loadedRules.containsKey(source) ? this.loadedRules.get(source) : CustomRuleLoader.compileAndLoad(rule, this.workingPackage, this.rulesDirectory, this.semanticLib, this.tempDirectory);
        }
        catch (TaraException e) {
            throw new DependencyException("impossible.load.rule.class", (Element)node, rule.getSource(), e.getMessage().split("\n")[0]);
        }
        if (aClass == null) {
            throw new DependencyException("impossible.load.rule.class", (Element)node, rule.getSource());
        }
        this.loadedRules.put(source, aClass);
        rule.setLoadedClass(aClass);
    }

    private void updateRule(Class<?> aClass, Variable variable) {
        if (aClass != null) {
            variable.rule((VariableRule)new WordRule(this.collectEnums(Arrays.asList(aClass.getDeclaredFields())), aClass.getSimpleName()));
        }
    }

    private List<String> collectEnums(List<Field> fields) {
        return fields.stream().filter(Field::isEnumConstant).map(Field::getName).collect(Collectors.toList());
    }

    private void resolveFacetTarget(FacetTarget target) throws DependencyException {
        Node destiny = this.manager.resolve(target, target.owner());
        if (destiny == null) {
            throw new DependencyException("reject.facet.target.not.found", (Element)target, new String[0]);
        }
        target.targetNode(destiny);
    }

    private void resolveVariable(VariableReference variable, Node container) throws DependencyException {
        NodeImpl destiny = this.manager.resolve(variable, container);
        if (destiny == null) {
            throw new DependencyException("reject.reference.variable.not.found", (Element)container, variable.destinyName());
        }
        variable.setDestiny(destiny);
        variable.rule((VariableRule)this.createReferenceRule(variable));
    }

    private ReferenceRule createReferenceRule(VariableReference variable) {
        return new ReferenceRule(this.collectTypes(variable.destinyOfReference()));
    }

    private Set<String> collectTypes(Node node) {
        HashSet<String> set = new HashSet<String>();
        if (!node.isAbstract()) {
            set.add(node.qualifiedName());
        }
        for (Node child : node.children()) {
            set.addAll(this.collectTypes(child));
        }
        return set;
    }

    private Node getNodeContainer(NodeContainer reference) {
        NodeContainer container = reference;
        while (!(container instanceof NodeImpl) && container.container() != null) {
            container = container.container();
        }
        return (Node)container;
    }
}

