/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.core.operation.model;

import io.intino.tara.compiler.core.CompilationUnit;
import io.intino.tara.compiler.core.CompilerConfiguration;
import io.intino.tara.compiler.core.errorcollection.DependencyException;
import io.intino.tara.compiler.core.errorcollection.message.DependencyErrorMessage;
import io.intino.tara.compiler.core.operation.model.ModelOperation;
import io.intino.tara.compiler.dependencyresolution.DependencyResolver;
import io.intino.tara.compiler.dependencyresolution.FacetTargetResolver;
import io.intino.tara.compiler.dependencyresolution.InheritanceResolver;
import io.intino.tara.compiler.dependencyresolution.NativeResolver;
import io.intino.tara.compiler.dependencyresolution.TerminalResolver;
import io.intino.tara.compiler.model.Model;
import java.util.logging.Logger;

public class ModelDependencyResolutionOperation
extends ModelOperation {
    private static final Logger LOG = Logger.getGlobal();
    private final CompilationUnit unit;

    public ModelDependencyResolutionOperation(CompilationUnit unit) {
        this.unit = unit;
    }

    @Override
    public void call(Model model) {
        try {
            CompilerConfiguration conf = this.unit.getConfiguration();
            if (conf.isVerbose()) {
                System.out.println("@#$%@# Presentable:[" + conf.getModule() + " - " + conf.outDSL() + "] Resolving dependencies...");
            }
            new DependencyResolver(model, conf.workingPackage(), conf.rulesDirectory(), conf.getSemanticRulesLib(), conf.getTempDirectory()).resolve();
            new InheritanceResolver(model).resolve();
            new FacetTargetResolver(model).resolve();
            new TerminalResolver(model, conf.level()).resolve();
            new NativeResolver(model, conf.functionsDirectory()).resolve();
        }
        catch (DependencyException e) {
            LOG.severe("Error during dependency resolution: " + e.getMessage());
            this.unit.getErrorCollector().addError(DependencyErrorMessage.create(e, this.unit.getSourceUnits().get(e.getElement().file())), true);
        }
    }
}

