/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.core.operation.model;

import io.intino.tara.compiler.core.CompilationUnit;
import io.intino.tara.compiler.core.errorcollection.CompilationFailedException;
import io.intino.tara.compiler.core.errorcollection.DependencyException;
import io.intino.tara.compiler.core.errorcollection.message.Message;
import io.intino.tara.compiler.core.operation.model.ModelOperation;
import io.intino.tara.compiler.model.Model;
import io.intino.tara.compiler.model.NodeImpl;
import io.intino.tara.lang.model.Element;
import io.intino.tara.lang.model.Metric;
import io.intino.tara.lang.model.Node;
import io.intino.tara.lang.model.Parameter;
import io.intino.tara.lang.model.Variable;
import io.intino.tara.lang.model.rules.variable.VariableCustomRule;
import java.lang.reflect.Field;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class MetricResolutionOperation
extends ModelOperation {
    private static final Logger LOG = Logger.getGlobal();
    private final CompilationUnit unit;

    public MetricResolutionOperation(CompilationUnit unit) {
        this.unit = unit;
    }

    @Override
    public void call(Model model) throws CompilationFailedException {
        try {
            this.resolve(model);
        }
        catch (DependencyException e) {
            LOG.severe("Error during dependency resolution: " + e.getMessage());
            this.unit.getErrorCollector().addError(Message.create(e, this.unit.getSourceUnits().get(e.getElement().file())), true);
        }
    }

    public void resolve(Model model) throws DependencyException {
        for (Node node : model.components()) {
            this.resolve(node);
        }
    }

    private void resolve(Node node) throws DependencyException {
        if (!(node instanceof NodeImpl)) {
            return;
        }
        this.resolveMeasures(node.parameters());
        this.resolveVariableMetrics(node.variables());
        for (Node include : node.components()) {
            this.resolve(include);
        }
    }

    private void resolveVariableMetrics(List<Variable> variables) throws DependencyException {
        for (Variable variable : variables) {
            if (!(variable.rule() instanceof VariableCustomRule) || !((VariableCustomRule)variable.rule()).isMetric() || variable.defaultMetric() == null) continue;
            VariableCustomRule rule = (VariableCustomRule)variable.rule();
            Metric metric = this.findMetric(rule.getLoadedClass(), variable.defaultMetric());
            if (metric == null) {
                throw new DependencyException("Metric not found", (Element)variable, new String[0]);
            }
            variable.values(variable.values().stream().map(arg_0 -> ((Metric)metric).value(arg_0)).collect(Collectors.toList()));
        }
    }

    private void resolveMeasures(List<Parameter> parameters) throws DependencyException {
        for (Parameter parameter : parameters) {
            if (!(parameter.rule() instanceof Metric) || parameter.metric() == null) continue;
            Metric metric = this.findMetric(parameter.rule().getClass(), parameter.metric());
            if (metric == null) {
                throw new DependencyException("Metric not found", (Element)parameter, new String[0]);
            }
            parameter.values(parameter.values().stream().map(arg_0 -> ((Metric)metric).value(arg_0)).collect(Collectors.toList()));
        }
    }

    private Metric findMetric(Class<?> aClass, String metric) {
        for (Field field : aClass.getDeclaredFields()) {
            if (!field.isEnumConstant() || !field.getName().equals(metric)) continue;
            try {
                return (Metric)field.get(null);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

