/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.core.operation;

import io.intino.tara.compiler.codegeneration.Format;
import io.intino.tara.compiler.codegeneration.magritte.NameFormatter;
import io.intino.tara.compiler.codegeneration.magritte.TemplateTags;
import io.intino.tara.compiler.codegeneration.magritte.layer.GraphWrapperCreator;
import io.intino.tara.compiler.codegeneration.magritte.layer.LayerFrameCreator;
import io.intino.tara.compiler.codegeneration.magritte.layer.LayerTemplate;
import io.intino.tara.compiler.codegeneration.magritte.layer.templates.LevelTemplate;
import io.intino.tara.compiler.codegeneration.magritte.natives.NativesCreator;
import io.intino.tara.compiler.core.CompilationUnit;
import io.intino.tara.compiler.core.CompilerConfiguration;
import io.intino.tara.compiler.core.errorcollection.CompilationFailedException;
import io.intino.tara.compiler.core.errorcollection.TaraException;
import io.intino.tara.compiler.core.operation.model.ModelOperation;
import io.intino.tara.compiler.model.Model;
import io.intino.tara.compiler.model.NodeImpl;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.lang.model.FacetTarget;
import io.intino.tara.lang.model.Node;
import io.intino.tara.lang.model.Tag;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.siani.itrules.Template;
import org.siani.itrules.model.Frame;

public class LayerGenerationOperation
extends ModelOperation
implements TemplateTags {
    private static final Logger LOG = Logger.getGlobal();
    private static final String DOT = ".";
    private static final String JAVA = ".java";
    private static final String WRAPPER = "GraphWrapper";
    private final CompilationUnit compilationUnit;
    private final CompilerConfiguration conf;
    private Template template;
    private File outFolder;
    private Map<String, List<String>> outMap = new LinkedHashMap<String, List<String>>();

    public LayerGenerationOperation(CompilationUnit compilationUnit) {
        this.compilationUnit = compilationUnit;
        this.conf = compilationUnit.getConfiguration();
        this.outFolder = this.conf.getOutDirectory();
    }

    @Override
    public void call(Model model) {
        this.template = Format.customize(LayerTemplate.create());
        try {
            if (this.conf.isVerbose()) {
                System.out.println("@#$%@# Presentable:[" + this.conf.getModule() + " - " + this.conf.outDSL() + "] Cleaning Old Layers...");
            }
            if (!this.conf.level().equals((Object)Configuration.Level.System)) {
                this.cleanOldLayers(model);
            }
            if (this.conf.isVerbose()) {
                System.out.println("@#$%@# Presentable:[" + this.conf.getModule() + " - " + this.conf.outDSL() + "] Generating Layers...");
            }
            if (!model.level().equals((Object)Configuration.Level.System)) {
                this.createLayers(model);
            }
            this.registerOutputs(this.writeNativeClasses(model));
            this.compilationUnit.addOutputItems(this.outMap);
        }
        catch (TaraException e) {
            LOG.log(Level.SEVERE, "Error during java className generation: " + e.getMessage(), e);
            throw new CompilationFailedException(this.compilationUnit.getPhase(), this.compilationUnit, e);
        }
    }

    private Map<String, String> writeNativeClasses(Model model) {
        return new NativesCreator(model, this.conf).create();
    }

    private void createLayers(Model model) throws TaraException {
        Map<String, Map<String, String>> layers = this.createLayerClasses(model);
        layers.values().forEach(this::writeLayers);
        this.registerOutputs(layers, this.writeGraphWrapper(new GraphWrapperCreator(model.getLanguage(), this.conf.outDSL(), this.conf.level(), this.conf.workingPackage(), this.conf.language(d -> d.name().equals(model.language())).generationPackage()).create(model)));
        this.writeWrapper(this.createWrapper());
    }

    private void registerOutputs(Map<String, Map<String, String>> layers, String modelPath) {
        this.fillLayerInOutMap(layers);
        for (List<String> paths : this.outMap.values()) {
            paths.add(modelPath);
        }
    }

    private void registerOutputs(Map<String, String> nativeOuts) {
        for (Map.Entry<String, String> src : nativeOuts.entrySet()) {
            if (!this.outMap.containsKey(src.getValue())) {
                this.outMap.put(src.getValue(), new ArrayList());
            }
            this.outMap.get(src.getValue()).add(src.getKey());
        }
    }

    private void fillLayerInOutMap(Map<String, Map<String, String>> map) {
        for (Map.Entry<String, Map<String, String>> entry : map.entrySet()) {
            for (String out : entry.getValue().keySet()) {
                this.put(entry.getKey(), out);
            }
        }
    }

    private void put(String key, String value) {
        if (!this.outMap.containsKey(key)) {
            this.outMap.put(key, new ArrayList());
        }
        this.outMap.get(key).add(value);
    }

    private String createWrapper() {
        Frame frame = new Frame().addTypes(new String[]{"wrapper"});
        frame.addFrame("generatedLanguage", new String[]{this.conf.outDSL()});
        frame.addFrame("workingPackage", new String[]{this.conf.workingPackage()});
        return Format.customize(LevelTemplate.create()).format((Object)frame);
    }

    private Map<String, Map<String, String>> createLayerClasses(Model model) throws TaraException {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        model.components().forEach(node -> {
            if (node.is(Tag.Instance) || !((NodeImpl)node).isDirty() || ((NodeImpl)node).isVirtual()) {
                return;
            }
            if (node.facetTarget() != null) {
                this.renderNodeWithFacetTarget((Map<String, Map<String, String>>)map, (Node)node);
            } else {
                this.renderNode((Map<String, Map<String, String>>)map, (Node)node);
            }
        });
        return map;
    }

    private void renderNodeWithFacetTarget(Map<String, Map<String, String>> map, Node node) {
        if (node.facetTarget() != null) {
            Map.Entry<String, Frame> layerFrame = new LayerFrameCreator(this.conf, node.language()).create(node.facetTarget(), node);
            if (!map.containsKey(node.file())) {
                map.put(node.file(), new LinkedHashMap());
            }
            map.get(node.file()).put(this.destiny(layerFrame), this.format(layerFrame));
        }
    }

    private void renderNode(Map<String, Map<String, String>> map, Node node) {
        Map.Entry<String, Frame> layerFrame = new LayerFrameCreator(this.conf, node.language()).create(node);
        if (!map.containsKey(node.file())) {
            map.put(node.file(), new LinkedHashMap());
        }
        map.get(node.file()).put(this.destiny(layerFrame), this.format(layerFrame));
    }

    private String destiny(Map.Entry<String, Frame> layerFrame) {
        return new File(this.outFolder, layerFrame.getKey().replace(DOT, File.separator) + JAVA).getAbsolutePath();
    }

    private List<String> writeLayers(Map<String, String> documentMap) {
        ArrayList<String> outputs = new ArrayList<String>();
        for (Map.Entry<String, String> entry : documentMap.entrySet()) {
            File file = new File(entry.getKey());
            file.getParentFile().mkdirs();
            this.write(file, entry.getValue());
            outputs.add(file.getAbsolutePath());
        }
        return outputs;
    }

    private String writeGraphWrapper(String text) {
        File destiny = new File(new File(this.outFolder, this.conf.workingPackage().replace(DOT, File.separator)), "GraphWrapper.java");
        destiny.getParentFile().mkdirs();
        return this.write(destiny, text) ? destiny.getAbsolutePath() : null;
    }

    private String writeWrapper(String text) {
        File destiny = new File(new File(this.conf.srcDirectory(), this.conf.workingPackage().toLowerCase().replace(DOT, File.separator)), Format.firstUpperCase().format(Format.javaValidName().format((Object)this.conf.outDSL())) + JAVA);
        return destiny.exists() ? destiny.getAbsolutePath() : (this.write(destiny, text) ? destiny.getAbsolutePath() : null);
    }

    private void cleanOldLayers(Model model) {
        String workingPackage = this.conf.workingPackage() == null ? this.conf.getModule() : this.conf.workingPackage();
        File out = new File(this.conf.getOutDirectory(), workingPackage.toLowerCase());
        List<File> layers = this.filterOld(this.collectAllLayers(out), out, model);
        layers.forEach(File::delete);
    }

    private List<File> filterOld(List<File> files, File base, Model model) {
        List<File> current = this.calculateCurrentLayers(base, model);
        return files.stream().filter(layer -> !current.contains(layer)).collect(Collectors.toList());
    }

    private List<File> calculateCurrentLayers(File base, Model model) {
        return model.components().stream().filter(n -> !n.is(Tag.Instance) && !n.isAnonymous()).map(node -> new File(this.calculateLayerPath((Node)node, base) + JAVA)).collect(Collectors.toList());
    }

    private String calculateLayerPath(Node node, File base) {
        String aPackage = this.packageOf(node);
        return base.getPath() + File.separator + aPackage + Format.javaValidName().format((Object)node.name()).toString() + this.facetName(node.facetTarget());
    }

    private String facetName(FacetTarget facetTarget) {
        return facetTarget != null ? facetTarget.targetNode().name() : "";
    }

    private String packageOf(Node node) {
        return node.facetTarget() != null ? NameFormatter.facetLayerPackage(node.facetTarget(), "").substring(1).replace(DOT, File.separator) : File.separator;
    }

    private List<File> collectAllLayers(File out) {
        ArrayList<File> list = new ArrayList<File>();
        if (!out.isDirectory() && !out.getName().equals("GraphWrapper.java")) {
            list.add(out);
        } else if (!out.isDirectory()) {
            for (File file : out.listFiles(f -> !"natives".equals(f.getName()))) {
                list.addAll(this.collectAllLayers(file));
            }
        }
        return list;
    }

    private boolean write(File file, String text) {
        try {
            file.getParentFile().mkdirs();
            BufferedWriter fileWriter = new BufferedWriter(new FileWriter(file));
            fileWriter.write(text);
            fileWriter.close();
            return true;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
    }

    private String format(Map.Entry<String, Frame> layerFrame) {
        return this.template.format((Object)layerFrame.getValue());
    }
}

