/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.core.errorcollection.message;

import io.intino.tara.compiler.core.SourceUnit;
import io.intino.tara.compiler.core.errorcollection.SyntaxException;
import io.intino.tara.compiler.core.errorcollection.message.Message;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SyntaxErrorMessage
extends Message {
    private static final Logger LOG = Logger.getGlobal();
    private SyntaxException cause;
    protected SourceUnit source;

    SyntaxErrorMessage(SyntaxException cause, SourceUnit source) {
        this.cause = cause;
        this.source = source;
        cause.setSourceLocator(source.getName());
    }

    public SyntaxException getCause() {
        return this.cause;
    }

    @Override
    public void write(PrintWriter output) {
        String description = "Syntax error: ";
        String message = this.cause.getMessage();
        if (message != null) {
            output.println(description + message);
        } else {
            output.println(description + this.cause);
        }
        output.println();
        LOG.log(Level.SEVERE, this.cause.getMessage(), this.cause);
    }
}

