/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.core;

import io.intino.tara.Language;
import io.intino.tara.compiler.codegeneration.FileSystemUtils;
import io.intino.tara.compiler.core.errorcollection.TaraException;
import io.intino.tara.compiler.semantic.LanguageLoader;
import io.intino.tara.compiler.shared.Configuration;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

public class CompilerConfiguration
implements Cloneable,
Configuration {
    private static final Logger LOG = Logger.getGlobal();
    public static final String REPOSITORY = "repository";
    private int warningLevel;
    private String sourceEncoding;
    private String project;
    private String module;
    private File outDirectory;
    private boolean debug;
    private Locale languageForCodeGeneration = Locale.ENGLISH;
    private List<File> sourceDirectories = new ArrayList<File>();
    private File resourcesDirectory;
    private File semanticRulesLib;
    private List<Integer> excludedPhases = new ArrayList<Integer>();
    private List<DSL> languages = new ArrayList<DSL>();
    private String outDSL;
    private String groupID;
    private String artifactID;
    private String version;
    private Configuration.Level level;
    private boolean make;
    private boolean verbose;
    private File tempDirectory;
    private File taraProjectDirectory;
    private File taraDirectory;
    private boolean test;
    private String workingPackage;
    private String nativeLanguage = "java";

    public CompilerConfiguration() {
        this.setWarningLevel(1);
        this.setDebug(false);
        String encoding = System.getProperty("file.encoding", "UTF8");
        encoding = System.getProperty("tara.source.encoding", encoding);
        this.sourceEncoding(encoding);
        try {
            this.tempDirectory = Files.createTempDirectory("_tara_", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public int getWarningLevel() {
        return this.warningLevel;
    }

    public void setWarningLevel(int level) {
        this.warningLevel = level < 0 || level > 3 ? 1 : level;
    }

    String sourceEncoding() {
        return this.sourceEncoding;
    }

    public void sourceEncoding(String encoding) {
        if (encoding == null) {
            this.sourceEncoding = "UTF8";
        }
        this.sourceEncoding = encoding;
    }

    public File getOutDirectory() {
        return this.outDirectory;
    }

    public void setOutDirectory(File directory) {
        if (directory != null) {
            this.outDirectory = directory;
            this.outDirectory.mkdirs();
        } else {
            this.outDirectory = null;
        }
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public File getTempDirectory() {
        return this.tempDirectory;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public File getTaraDirectory() {
        return this.taraDirectory;
    }

    public void setTaraDirectory(File taraDirectory) {
        this.taraDirectory = taraDirectory;
    }

    public String groupId() {
        return this.groupID;
    }

    public void groupId(String groupID) {
        this.groupID = groupID;
    }

    public String artifactId() {
        return this.artifactID;
    }

    public void artifactId(String artifactID) {
        this.artifactID = artifactID;
    }

    public String version() {
        return this.version;
    }

    public void version(String version) {
        this.version = version;
    }

    public void workingPackage(String workingPackage) {
        this.workingPackage = workingPackage;
    }

    public String workingPackage() {
        return this.workingPackage == null || this.workingPackage.isEmpty() ? this.outDSL() : this.workingPackage;
    }

    public String dslGroupId() {
        return "tara.dsl";
    }

    public File resourcesDirectory() {
        return this.resourcesDirectory;
    }

    public void setResourcesDirectory(File resourcesDirectory) {
        this.resourcesDirectory = resourcesDirectory;
    }

    public void cleanTemp() {
        FileSystemUtils.removeDir(this.tempDirectory);
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public Locale getLocale() {
        return this.languageForCodeGeneration;
    }

    public File getSemanticRulesLib() {
        return this.semanticRulesLib;
    }

    public void setSemanticRulesLib(File semanticRulesURL) {
        this.semanticRulesLib = semanticRulesURL;
    }

    public Configuration.LanguageLibrary addLanguage(String name, String version) {
        Configuration.LanguageLibrary language = this.languages.stream().filter(d -> d.name().equalsIgnoreCase(name)).findFirst().orElse(null);
        if (language == null) {
            DSL dsl = new DSL(name, version);
            this.languages.add(dsl);
            return dsl;
        }
        return language;
    }

    public void addLanguage(Language taraLanguage) {
        Configuration.LanguageLibrary language = this.languages.stream().filter(d -> d.name().equalsIgnoreCase(taraLanguage.languageName())).findFirst().orElse(null);
        if (language == null) {
            DSL dsl = new DSL(taraLanguage);
            this.languages.add(dsl);
        }
    }

    public String outDSL() {
        return this.outDSL;
    }

    public String outDSL(String outDSL) {
        this.outDSL = outDSL;
        return this.outDSL;
    }

    public String interfaceVersion() {
        return "1.0.0";
    }

    public void systemStashName(String name) {
        this.outDSL = name;
    }

    public List<DSL> languages() {
        return this.languages;
    }

    private File languagesDirectory() {
        return new File(this.taraDirectory, REPOSITORY);
    }

    public String nativeLanguage() {
        return this.nativeLanguage;
    }

    public void nativeLanguage(String language) {
        this.nativeLanguage = language;
    }

    public Configuration.Level level() {
        return this.level;
    }

    public void level(Configuration.Level level) {
        this.level = level;
    }

    List<Integer> getExcludedPhases() {
        return this.excludedPhases;
    }

    public void setExcludedPhases(List<Integer> excludedPhases) {
        this.excludedPhases = excludedPhases;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isMake() {
        return this.make;
    }

    public void setMake(boolean make) {
        this.make = make;
    }

    public void setTaraProjectDirectory(File taraPath) {
        this.taraProjectDirectory = taraPath;
    }

    public File getTaraProjectDirectory() {
        return this.taraProjectDirectory;
    }

    public File getMiscDirectory() {
        return new File(this.getTaraProjectDirectory(), "misc");
    }

    public File getImportsFile() {
        return new File(this.getMiscDirectory(), this.module + ".json");
    }

    public List<File> sourceDirectories() {
        return this.sourceDirectories;
    }

    public File srcDirectory() {
        return this.sourceDirectories.stream().filter(f -> f.getName().equals("src")).findAny().orElse(null);
    }

    public File rulesDirectory() {
        for (File sourceDirectory : this.sourceDirectories) {
            String rulesPackage;
            File file = new File(sourceDirectory, rulesPackage = (this.workingPackage() == null ? this.module.toLowerCase() : this.workingPackage().toLowerCase().replace(".", File.separator)) + File.separator + "rules");
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    public File functionsDirectory() {
        for (File sourceDirectory : this.sourceDirectories) {
            String functionsPackage;
            File file = new File(sourceDirectory, functionsPackage = (this.workingPackage() == null ? this.module.toLowerCase() : this.workingPackage().toLowerCase().replace(".", File.separator)) + File.separator + "functions");
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    public void setTest(boolean test) {
        this.test = test;
    }

    public boolean isTest() {
        return this.test;
    }

    public CompilerConfiguration clone() {
        try {
            return (CompilerConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            LOG.info(e.getMessage());
            return null;
        }
    }

    static {
        Logger.getGlobal().setLevel(Level.INFO);
        LOG.setUseParentHandlers(false);
        for (Handler handler : LOG.getHandlers()) {
            LOG.removeHandler(handler);
        }
        StreamHandler errorHandler = new StreamHandler(System.err, new SimpleFormatter());
        errorHandler.setLevel(Level.WARNING);
        LOG.addHandler(errorHandler);
        StreamHandler infoHandler = new StreamHandler(System.out, new SimpleFormatter());
        infoHandler.setLevel(Level.INFO);
        LOG.addHandler(infoHandler);
    }

    public class DSL
    implements Configuration.LanguageLibrary {
        Language language;
        String name;
        String version;
        String effectiveVersion;
        String generationPackage;

        public DSL(String name, String version) {
            this.name = name;
            this.version = version;
        }

        public DSL(Language language) {
            this.language = language;
            this.name = this.language.languageName();
        }

        public Language get() {
            return this.language == null ? (this.language = this.loadLanguage()) : this.language;
        }

        public String name() {
            return this.language == null ? this.name : this.language.languageName();
        }

        public String version() {
            return this.version;
        }

        public String effectiveVersion() {
            return this.effectiveVersion;
        }

        public void version(String version) {
            this.version = version;
        }

        public String generationPackage() {
            return this.generationPackage;
        }

        void generationPackage(File language) {
            if (language.isDirectory() || !language.exists()) {
                this.generationPackage = this.name;
            } else {
                try {
                    Manifest manifest = new JarFile(language).getManifest();
                    Attributes tara = manifest.getAttributes("tara");
                    this.generationPackage = tara == null ? this.name : tara.getValue("working.package".replace(".", "-"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        private Language loadLanguage() {
            try {
                Language language = LanguageLoader.load(this.name, this.version, CompilerConfiguration.this.languagesDirectory().getAbsolutePath());
                if (language != null) {
                    this.generationPackage(LanguageLoader.getLanguagePath(this.name, this.version, CompilerConfiguration.this.languagesDirectory().getAbsolutePath()));
                }
                return language;
            }
            catch (TaraException e) {
                LOG.info("Language " + this.name() + " cannot be load");
                return null;
            }
        }
    }
}

