/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.codegeneration.magritte.natives;

import io.intino.tara.compiler.codegeneration.Format;
import io.intino.tara.compiler.codegeneration.magritte.natives.ExpressionsTemplate;
import io.intino.tara.compiler.codegeneration.magritte.natives.NativeFormatter;
import io.intino.tara.compiler.codegeneration.magritte.natives.NativeParameterAdapter;
import io.intino.tara.compiler.codegeneration.magritte.natives.NativeVariableAdapter;
import io.intino.tara.compiler.core.CompilerConfiguration;
import io.intino.tara.compiler.model.Model;
import io.intino.tara.compiler.model.NodeImpl;
import io.intino.tara.compiler.model.NodeReference;
import io.intino.tara.lang.model.Node;
import io.intino.tara.lang.model.NodeRoot;
import io.intino.tara.lang.model.Parameter;
import io.intino.tara.lang.model.Primitive;
import io.intino.tara.lang.model.Tag;
import io.intino.tara.lang.model.Variable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.siani.itrules.Adapter;
import org.siani.itrules.Template;
import org.siani.itrules.engine.FrameBuilder;
import org.siani.itrules.model.Frame;

public class NativesCreator {
    private static final Logger LOG = Logger.getLogger(NativesCreator.class.getName());
    private static String nativeExtension;
    private static final String NATIVES = "natives";
    private final String nativesPackage;
    private final Model model;
    private final CompilerConfiguration conf;
    private final File outDirectory;
    private final String outDSL;

    public NativesCreator(Model model, CompilerConfiguration conf) {
        this.model = model;
        this.conf = conf;
        this.outDirectory = conf.getOutDirectory();
        this.outDSL = conf.outDSL() != null ? conf.outDSL().toLowerCase() : conf.getModule();
        this.nativesPackage = conf.workingPackage().toLowerCase().replace(".", File.separator) + File.separator + NATIVES + File.separator;
        nativeExtension = "." + (conf.nativeLanguage().equalsIgnoreCase("kotlin") ? "kt" : conf.nativeLanguage().toLowerCase());
    }

    public Map<String, String> create() {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        ArrayList<Variable> variables = new ArrayList<Variable>();
        this.extractNativeParameters((Node)this.model, parameters);
        this.extractNativeVariables((Node)this.model, variables);
        return this.createNativeClasses(parameters, variables);
    }

    private Map<String, String> createNativeClasses(List<Parameter> parameters, List<Variable> variables) {
        HashMap<String, String> destinyToOrigin = new HashMap<String, String>();
        HashMap<File, String> nativeCodes = new HashMap<File, String>();
        if (parameters.isEmpty() && variables.isEmpty()) {
            return destinyToOrigin;
        }
        if (!parameters.isEmpty()) {
            nativeCodes.putAll(this.createNativeParameterClasses(parameters, destinyToOrigin));
        }
        if (!variables.isEmpty()) {
            nativeCodes.putAll(this.createNativeVariableClasses(variables, destinyToOrigin));
        }
        for (Map.Entry nativeCode : nativeCodes.entrySet()) {
            this.writeJavaCode((File)nativeCode.getKey(), (String)nativeCode.getValue());
        }
        return destinyToOrigin;
    }

    private Map<File, String> createNativeParameterClasses(List<Parameter> parameters, Map<String, String> originToDestiny) {
        Template expressionsTemplate = this.expressionsTemplate();
        LinkedHashMap<File, String> nativeCodes = new LinkedHashMap<File, String>();
        parameters.forEach(p -> {
            FrameBuilder builder = new FrameBuilder();
            builder.register(Parameter.class, (Adapter)new NativeParameterAdapter(this.model.getLanguage(), this.outDSL, this.conf.level(), this.conf.workingPackage(), this.conf.language(l -> l.name().equals(this.model.language())).generationPackage(), NativeFormatter.calculatePackage(p.container()), this.conf.getImportsFile()));
            File destiny = this.calculateDestiny((Parameter)p);
            Frame frame = ((Frame)builder.build(p)).addTypes(new String[]{this.conf.nativeLanguage()});
            if (Primitive.FUNCTION.equals((Object)p.type())) {
                frame.addTypes(new String[]{p.type().name()});
            }
            nativeCodes.put(destiny, expressionsTemplate.format((Object)frame));
            if (!originToDestiny.containsKey(p.file())) {
                originToDestiny.put(destiny.getAbsolutePath(), p.file());
            }
        });
        return nativeCodes;
    }

    private Map<File, String> createNativeVariableClasses(List<Variable> natives, Map<String, String> files) {
        Template expressionsTemplate = this.expressionsTemplate();
        LinkedHashMap<File, String> nativeCodes = new LinkedHashMap<File, String>();
        natives.forEach(variable -> {
            FrameBuilder builder = new FrameBuilder();
            builder.register(Variable.class, (Adapter)new NativeVariableAdapter(this.model.getLanguage(), this.outDSL, this.conf.workingPackage(), this.conf.language(d -> d.name().equals(this.model.language())).generationPackage(), NativeFormatter.calculatePackage(variable.container()), this.conf.getImportsFile()));
            File destiny = this.calculateDestiny((Variable)variable);
            Frame frame = ((Frame)builder.build(variable)).addTypes(new String[]{this.conf.nativeLanguage()});
            if (Primitive.FUNCTION.equals((Object)variable.type())) {
                frame.addTypes(new String[]{variable.type().name()});
            }
            nativeCodes.put(destiny, expressionsTemplate.format((Object)frame));
            if (!files.containsKey(variable.file())) {
                files.put(destiny.getAbsolutePath(), variable.file());
            }
        });
        return nativeCodes;
    }

    private Template expressionsTemplate() {
        return Format.customize(ExpressionsTemplate.create());
    }

    private File calculateDestiny(Parameter parameter) {
        return new File(this.outDirectory, this.nativesPackage + NativeFormatter.calculatePackage(parameter.container()).replace(".", File.separator) + File.separator + this.nativeName(parameter));
    }

    private File calculateDestiny(Variable variable) {
        return new File(this.outDirectory, this.nativesPackage + NativeFormatter.calculatePackage(variable.container()).replace(".", File.separator) + File.separator + this.nativeName(variable));
    }

    private String nativeName(Variable variable) {
        return Format.javaValidName().format((Object)variable.name()).toString() + "_" + variable.getUID() + nativeExtension;
    }

    private String nativeName(Parameter parameter) {
        return Format.javaValidName().format((Object)parameter.name()).toString() + "_" + parameter.getUID() + nativeExtension;
    }

    private File writeJavaCode(File file, String nativeText) {
        try {
            file.getParentFile().mkdirs();
            file.createNewFile();
            Files.write(file.toPath(), nativeText.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            LOG.severe(e.getMessage());
        }
        return file;
    }

    private void extractNativeParameters(Node node, List<Parameter> natives) {
        if (node instanceof NodeReference || node instanceof NodeImpl && node.container() instanceof NodeRoot && !((NodeImpl)node).isDirty()) {
            return;
        }
        natives.addAll(node.parameters().stream().filter(p -> Primitive.FUNCTION.equals((Object)p.type()) || this.isExpression((Parameter)p)).collect(Collectors.toList()));
        for (Node component : node.components()) {
            this.extractNativeParameters(component, natives);
        }
    }

    private void extractNativeVariables(Node node, List<Variable> natives) {
        if (node instanceof NodeReference || node instanceof NodeImpl && node.container() instanceof NodeRoot && !((NodeImpl)node).isDirty()) {
            return;
        }
        natives.addAll(node.variables().stream().filter(v -> (Primitive.FUNCTION.equals((Object)v.type()) || this.isExpression((Variable)v)) && !v.values().isEmpty() && !v.isInherited()).collect(Collectors.toList()));
        for (Node component : node.components()) {
            this.extractNativeVariables(component, natives);
        }
    }

    private boolean isExpression(Variable valued) {
        return !valued.values().isEmpty() && valued.values().get(0) instanceof Primitive.Expression || valued.flags().contains(Tag.Reactive);
    }

    private boolean isExpression(Parameter parameter) {
        return !parameter.values().isEmpty() && parameter.values().get(0) instanceof Primitive.Expression || parameter.flags().contains(Tag.Reactive);
    }
}

