/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.codegeneration.magritte.natives;

import io.intino.tara.Language;
import io.intino.tara.compiler.codegeneration.magritte.Generator;
import io.intino.tara.compiler.codegeneration.magritte.TemplateTags;
import io.intino.tara.compiler.codegeneration.magritte.layer.TypesProvider;
import io.intino.tara.compiler.codegeneration.magritte.natives.NativeFormatter;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.lang.model.Primitive;
import io.intino.tara.lang.model.Variable;
import java.io.File;
import org.siani.itrules.Adapter;
import org.siani.itrules.model.Frame;

class NativeVariableAdapter
extends Generator
implements Adapter<Variable>,
TemplateTags {
    private final String subPackage;
    private final File importsFile;

    NativeVariableAdapter(Language language, String outDSL, String workingPackage, String languageWorkingPackage, String subPackage, File importsFile) {
        super(language, outDSL, workingPackage, languageWorkingPackage);
        this.subPackage = subPackage;
        this.importsFile = importsFile;
    }

    public void execute(Frame frame, Variable source, Adapter.FrameContext<Variable> frameContext) {
        frame.addTypes(TypesProvider.getTypes(source, Configuration.Level.Platform));
        this.createFrame(frame, source);
    }

    private void createFrame(Frame frame, Variable variable) {
        this.createNativeFrame(frame, variable);
    }

    private void createNativeFrame(Frame frame, Variable variable) {
        if (!(variable.values().get(0) instanceof Primitive.Expression)) {
            return;
        }
        Primitive.Expression body = (Primitive.Expression)variable.values().get(0);
        String value = body.get();
        NativeFormatter formatter = new NativeFormatter(this.language, this.outDsl, this.subPackage, this.workingPackage, this.languageWorkingPackage, false, this.importsFile);
        if (Primitive.FUNCTION.equals((Object)variable.type())) {
            formatter.fillFrameForFunctionVariable(frame, variable, value);
        } else {
            formatter.fillFrameNativeVariable(frame, variable, value);
        }
    }
}

