/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.codegeneration.magritte.natives;

public class NativeExtractor {
    private final String returnValue;
    private final String methodName;
    private final String parameters;

    public NativeExtractor(String methodSignature) {
        this.returnValue = NativeExtractor.getReturn(this.clean(methodSignature));
        this.methodName = this.getMethod(this.clean(methodSignature));
        this.parameters = NativeExtractor.getParameters(this.clean(methodSignature));
    }

    private String clean(String methodSignature) {
        return methodSignature.trim().replaceAll("\\s+", " ").replace(" (", "(");
    }

    private static String getReturn(String methodSignature) {
        if (methodSignature == null || methodSignature.isEmpty()) {
            return "";
        }
        String returnValue = methodSignature.split(" (\\S)*\\(")[0];
        return returnValue.startsWith("public ") ? returnValue.replaceFirst("public ", "") : returnValue;
    }

    private String getMethod(String methodSignature) {
        if (methodSignature == null || methodSignature.isEmpty()) {
            return "";
        }
        String[] substring = methodSignature.substring(0, methodSignature.indexOf("(")).split(" ");
        return substring[substring.length - 1];
    }

    private static String getParameters(String methodSignature) {
        if (methodSignature == null || methodSignature.isEmpty()) {
            return "";
        }
        return methodSignature.substring(methodSignature.indexOf("(") + 1, methodSignature.lastIndexOf(")"));
    }

    public String returnValue() {
        return this.returnValue;
    }

    public String methodName() {
        return this.methodName;
    }

    public String parameters() {
        return this.parameters;
    }
}

