/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.codegeneration.magritte.layer;

import io.intino.tara.Language;
import io.intino.tara.compiler.codegeneration.magritte.Generator;
import io.intino.tara.compiler.codegeneration.magritte.NameFormatter;
import io.intino.tara.compiler.codegeneration.magritte.TemplateTags;
import io.intino.tara.compiler.codegeneration.magritte.layer.TypesProvider;
import io.intino.tara.compiler.codegeneration.magritte.natives.NativeFormatter;
import io.intino.tara.compiler.model.NodeReference;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.lang.model.EmptyNode;
import io.intino.tara.lang.model.Node;
import io.intino.tara.lang.model.Primitive;
import io.intino.tara.lang.model.Rule;
import io.intino.tara.lang.model.Tag;
import io.intino.tara.lang.model.Variable;
import io.intino.tara.lang.model.rules.NativeWordRule;
import io.intino.tara.lang.model.rules.variable.NativeRule;
import io.intino.tara.lang.model.rules.variable.VariableCustomRule;
import io.intino.tara.lang.model.rules.variable.WordRule;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.siani.itrules.Adapter;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

class LayerVariableAdapter
extends Generator
implements Adapter<Variable>,
TemplateTags {
    private final Set<String> imports = new HashSet<String>();
    private Configuration.Level modelLevel;

    LayerVariableAdapter(Language language, String generatedLanguage, Configuration.Level modelLevel, String workingPackage, String languageWorkingPackage) {
        super(language, generatedLanguage, workingPackage, languageWorkingPackage);
        this.modelLevel = modelLevel;
    }

    public void execute(Frame frame, Variable source, Adapter.FrameContext<Variable> context) {
        this.createVarFrame(frame, source);
    }

    private Frame createVarFrame(Frame frame, Variable variable) {
        frame.addTypes(TypesProvider.getTypes(variable, this.modelLevel));
        frame.addFrame("name", new String[]{variable.name()});
        frame.addFrame("generatedLanguage", new String[]{this.outDsl.toLowerCase()});
        frame.addFrame("workingPackage", new String[]{this.workingPackage.toLowerCase()});
        frame.addFrame("language", new String[]{this.language.languageName().toLowerCase()});
        frame.addFrame("container", new String[]{variable.container().name()});
        frame.addFrame("containerName", new String[]{variable.container().name()});
        frame.addFrame("qn", new String[]{this.buildQN(variable.container())});
        if (variable.values().stream().filter(Objects::nonNull).count() > 0L && !(variable.values().get(0) instanceof EmptyNode)) {
            this.addValues(frame, variable);
        }
        if (variable.rule() != null) {
            frame.addFrame("rule", new AbstractFrame[]{this.ruleToFrame((Rule)variable.rule())});
        }
        frame.addFrame("type", new String[]{this.getType(variable, this.workingPackage)});
        if (Primitive.WORD.equals((Object)variable.type())) {
            this.fillWordVariable(frame, variable);
        } else if (variable.type().equals((Object)Primitive.FUNCTION) || variable.flags().contains(Tag.Reactive)) {
            this.fillNativeVariable(frame, variable);
        }
        return frame;
    }

    private void fillWordVariable(Frame frame, Variable variable) {
        if (variable.rule() instanceof VariableCustomRule || variable.rule() instanceof WordRule && ((WordRule)variable.rule()).isCustom()) {
            frame.addTypes(new String[]{"outDefined"});
        } else {
            List allowedWords = variable.rule() instanceof NativeRule ? ((NativeWordRule)variable.rule()).words() : ((WordRule)variable.rule()).words();
            frame.addFrame("words", allowedWords.toArray(new String[allowedWords.size()]));
        }
    }

    private String buildQN(Node node) {
        return NameFormatter.getQn(node instanceof NodeReference ? ((NodeReference)node).getDestiny() : node, this.workingPackage.toLowerCase());
    }

    private void addValues(Frame frame, Variable variable) {
        if (Primitive.WORD.equals((Object)variable.type())) {
            frame.addFrame("wordValues", this.getWordValues(variable));
        } else if (Primitive.STRING.equals((Object)variable.type())) {
            frame.addFrame("values", this.asString(variable.values()));
        } else {
            frame.addFrame("values", variable.values().toArray());
        }
    }

    private String[] getWordValues(Variable variable) {
        List<String> wordValues = variable.values().stream().map(Object::toString).collect(Collectors.toList());
        return wordValues.toArray(new String[wordValues.size()]);
    }

    private String[] asString(List<Object> objects) {
        List<String> values = objects.stream().map(object -> '\"' + object.toString() + '\"').collect(Collectors.toList());
        return values.toArray(new String[values.size()]);
    }

    private void fillNativeVariable(Frame frame, Variable variable) {
        Object next = variable.values().isEmpty() || !(variable.values().get(0) instanceof Primitive.Expression) ? null : variable.values().get(0);
        NativeFormatter adapter = new NativeFormatter(this.language, this.outDsl, NativeFormatter.calculatePackage(variable.container()), this.workingPackage, this.languageWorkingPackage, this.modelLevel.equals((Object)Configuration.Level.System), null);
        if (Primitive.FUNCTION.equals((Object)variable.type())) {
            adapter.fillFrameForFunctionVariable(frame, variable, next);
            this.imports.addAll(((NativeRule)variable.rule()).imports().stream().collect(Collectors.toList()));
        } else {
            adapter.fillFrameNativeVariable(frame, variable, next);
        }
    }

    @Override
    public Set<String> getImports() {
        return this.imports;
    }
}

