/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.codegeneration.magritte.layer;

import io.intino.tara.Language;
import io.intino.tara.compiler.codegeneration.Format;
import io.intino.tara.compiler.codegeneration.magritte.NameFormatter;
import io.intino.tara.compiler.codegeneration.magritte.TemplateTags;
import io.intino.tara.compiler.codegeneration.magritte.layer.LayerFacetTargetAdapter;
import io.intino.tara.compiler.codegeneration.magritte.layer.LayerNodeAdapter;
import io.intino.tara.compiler.codegeneration.magritte.layer.LayerVariableAdapter;
import io.intino.tara.compiler.core.CompilerConfiguration;
import io.intino.tara.compiler.model.NodeReference;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.lang.model.FacetTarget;
import io.intino.tara.lang.model.Node;
import io.intino.tara.lang.model.Tag;
import io.intino.tara.lang.model.Variable;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import org.siani.itrules.Adapter;
import org.siani.itrules.engine.FrameBuilder;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class LayerFrameCreator
implements TemplateTags {
    private final FrameBuilder builder = new FrameBuilder();
    private final String outDsl;
    private final String workingPackage;
    private Node initNode = null;
    private LayerNodeAdapter layerNodeAdapter;
    private LayerVariableAdapter variableAdapter;
    private LayerFacetTargetAdapter layerFacetTargetAdapter;

    private LayerFrameCreator(String outDsl, Language language, Configuration.Level modelLevel, String workingPackage, String languageWorkingPackage) {
        this.outDsl = outDsl;
        this.workingPackage = workingPackage;
        this.layerNodeAdapter = new LayerNodeAdapter(outDsl, modelLevel, language, this.initNode, workingPackage, languageWorkingPackage);
        this.builder.register(Node.class, (Adapter)this.layerNodeAdapter);
        this.layerFacetTargetAdapter = new LayerFacetTargetAdapter(language, outDsl, modelLevel, workingPackage, languageWorkingPackage);
        this.builder.register(FacetTarget.class, (Adapter)this.layerFacetTargetAdapter);
        this.variableAdapter = new LayerVariableAdapter(language, outDsl, modelLevel, workingPackage, languageWorkingPackage);
        this.builder.register(Variable.class, (Adapter)this.variableAdapter);
    }

    public LayerFrameCreator(CompilerConfiguration conf, String language) {
        this(conf.outDSL(), ((CompilerConfiguration.DSL)conf.language(d -> d.name().equals(language))).get(), conf.level(), conf.workingPackage(), conf.language(d -> d.name().equals(language)).generationPackage());
    }

    public Map.Entry<String, Frame> create(Node node) {
        this.initNode = node;
        this.layerNodeAdapter.getImports().clear();
        this.variableAdapter.getImports().clear();
        this.layerNodeAdapter.setInitNode(this.initNode);
        Frame frame = new Frame().addTypes(new String[]{"Layer"}).addFrame("generatedLanguage", new String[]{this.outDsl}).addFrame("workingPackage", new String[]{this.workingPackage});
        this.createFrame(frame, node);
        this.addNodeImports(frame);
        String aPackage = node.facetTarget() != null ? this.addPackage(node.facetTarget(), frame) : this.addPackage(frame);
        return new AbstractMap.SimpleEntry<String, Frame>(this.calculateLayerPath(node, aPackage), frame);
    }

    private String calculateLayerPath(Node node, String aPackage) {
        return aPackage + "." + Format.javaValidName().format((Object)node.name()).toString() + this.facetName(node.facetTarget());
    }

    private String facetName(FacetTarget facetTarget) {
        return facetTarget != null ? facetTarget.target() : "";
    }

    public Map.Entry<String, Frame> create(FacetTarget facetTarget, Node owner) {
        Frame frame = new Frame().addTypes(new String[]{"Layer"}).addFrame("generatedLanguage", new String[]{this.outDsl}).addFrame("workingPackage", new String[]{this.workingPackage});
        this.layerFacetTargetAdapter.getImports().clear();
        this.variableAdapter.getImports().clear();
        this.createFrame(frame, facetTarget);
        this.addFacetImports(frame);
        return new AbstractMap.SimpleEntry<String, Frame>(this.addPackage(facetTarget, frame) + "." + Format.javaValidName().format((Object)(owner.name() + facetTarget.targetNode().name())).toString(), frame);
    }

    private void addNodeImports(Frame frame) {
        HashSet<String> set = new HashSet<String>(this.layerNodeAdapter.getImports());
        set.addAll(this.variableAdapter.getImports());
        frame.addFrame("imports", set.toArray(new String[set.size()]));
    }

    private void addFacetImports(Frame frame) {
        HashSet<String> set = new HashSet<String>(this.layerFacetTargetAdapter.getImports());
        set.addAll(this.variableAdapter.getImports());
        frame.addFrame("imports", set.toArray(new String[set.size()]));
    }

    private void createFrame(Frame frame, Node node) {
        if (node instanceof NodeReference || node.is(Tag.Instance)) {
            return;
        }
        frame.addFrame("node", new AbstractFrame[]{this.builder.build((Object)node)});
    }

    private void createFrame(Frame frame, FacetTarget facet) {
        frame.addFrame("node", new AbstractFrame[]{this.builder.build((Object)facet)});
    }

    private String addPackage(Frame frame) {
        String packagePath = this.workingPackage.toLowerCase();
        if (!packagePath.isEmpty()) {
            frame.addFrame("package", new String[]{packagePath});
        }
        return packagePath;
    }

    private String addPackage(FacetTarget target, Frame frame) {
        String packagePath = NameFormatter.facetLayerPackage(target, this.workingPackage);
        if (!packagePath.isEmpty()) {
            frame.addFrame("package", new String[]{packagePath.substring(0, packagePath.length() - 1)});
        }
        return packagePath;
    }
}

