/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.codegeneration.magritte.layer;

import io.intino.tara.Language;
import io.intino.tara.compiler.codegeneration.magritte.Generator;
import io.intino.tara.compiler.codegeneration.magritte.NameFormatter;
import io.intino.tara.compiler.codegeneration.magritte.TemplateTags;
import io.intino.tara.compiler.model.NodeImpl;
import io.intino.tara.compiler.model.NodeReference;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.lang.model.FacetTarget;
import io.intino.tara.lang.model.Node;
import io.intino.tara.lang.model.Tag;
import io.intino.tara.lang.model.Variable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.siani.itrules.Adapter;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

class LayerFacetTargetAdapter
extends Generator
implements Adapter<FacetTarget>,
TemplateTags {
    private final String outDSL;
    private final Configuration.Level level;
    private Adapter.FrameContext<FacetTarget> context;
    private Set<String> imports = new HashSet<String>();

    LayerFacetTargetAdapter(Language language, String outDSL, Configuration.Level level, String workingPackage, String languageWorkingPackage) {
        super(language, outDSL, workingPackage, languageWorkingPackage);
        this.outDSL = outDSL;
        this.level = level;
    }

    public void execute(Frame frame, FacetTarget target, Adapter.FrameContext<FacetTarget> context) {
        this.context = context;
        frame.addTypes(new String[]{"nodeimpl"});
        frame.addFrame("modelType", new String[]{this.level.compareLevelWith(Configuration.Level.Platform) == 0 ? "Platform" : "Application"});
        frame.addFrame("generatedLanguage", new String[]{this.outDSL}).addFrame("workingPackage", new String[]{this.workingPackage});
        this.addFacetTargetInfo(target, frame);
        this.addComponents(frame, target.owner(), context);
        this.addTargetComponents(target, frame, context);
        if (!Arrays.asList(frame.slots()).contains("metaType".toLowerCase()) && target.owner().components().stream().anyMatch(c -> c.is(Tag.Instance))) {
            frame.addFrame("metaType", new String[]{this.languageWorkingPackage + "." + this.metaType(target.owner())});
        }
    }

    private void addFacetTargetInfo(FacetTarget target, Frame frame) {
        this.addName(target, frame);
        this.addConstrains(target, frame);
        this.addTags(target, frame);
        this.addParent(target, frame);
        this.addFacetTarget(target, frame);
        this.addVariables(target, frame);
    }

    private void addTags(FacetTarget target, Frame frame) {
        target.owner().flags().stream().filter(this.isLayerInterface()).forEach(tag -> frame.addFrame("flag", new Object[]{tag}));
    }

    private void addName(FacetTarget facetTarget, Frame frame) {
        frame.addFrame("name", new String[]{facetTarget.owner().name() + facetTarget.targetNode().name()});
        frame.addFrame("qn", new String[]{NameFormatter.cleanQn(this.buildQN(facetTarget.targetNode()))});
    }

    private void addConstrains(FacetTarget target, Frame frame) {
        target.constraints().stream().filter(c -> !c.negated()).forEach(c -> {
            Frame constraint = new Frame().addTypes(new String[]{"constraint"});
            constraint.addFrame("name", new String[]{c.node().name()});
            constraint.addFrame("qn", new String[]{NameFormatter.cleanQn(this.buildQN(c.node()))});
            frame.addFrame("constraint", new AbstractFrame[]{constraint});
        });
    }

    private void addParent(FacetTarget target, Frame newFrame) {
        Node parent;
        Node node = parent = target.owner().parent() != null ? target.owner().parent() : target.parent();
        if (target.owner().isAbstract()) {
            newFrame.addFrame("abstract", new Boolean[]{true});
        }
        if (parent != null) {
            newFrame.addFrame("parent", new String[]{NameFormatter.getQn(parent, this.workingPackage)});
            newFrame.addFrame("parentSuper", new Boolean[]{true});
        } else if (target.owner().isSub() && target.owner().parent() != null) {
            newFrame.addFrame("parent", new String[]{NameFormatter.getQn(target.owner().parent(), this.workingPackage)});
            newFrame.addFrame("parentSuper", new Boolean[]{true});
        } else {
            newFrame.addFrame("parentSuper", new Boolean[]{false});
        }
    }

    private void addFacetTarget(FacetTarget target, Frame frame) {
        Frame facetTargetFrame = new Frame();
        if (target.owner().isSub() && target.owner().parent() != null) {
            facetTargetFrame.addTypes(new String[]{"overriden"});
        }
        facetTargetFrame.addTypes(new String[]{"facetTarget"});
        facetTargetFrame.addFrame("name", new String[]{target.targetNode().name()});
        facetTargetFrame.addFrame("qn", new String[]{this.buildQN(target.targetNode())});
        facetTargetFrame.addFrame("generatedLanguage", new String[]{this.outDSL});
        frame.addFrame("facetTarget", new AbstractFrame[]{facetTargetFrame});
    }

    private String buildQN(Node node) {
        return NameFormatter.getQn(node instanceof NodeReference ? ((NodeReference)node).getDestiny() : node, this.workingPackage.toLowerCase());
    }

    private void addVariables(FacetTarget target, Frame frame) {
        target.owner().variables().stream().filter(variable -> !variable.isInherited()).forEach(variable -> frame.addFrame("variable", new AbstractFrame[]{((Frame)this.context.build(variable)).addTypes(new String[]{"owner"})}));
        target.targetNode().variables().stream().filter(variable -> !variable.isInherited() && !this.isOverriden(target.owner(), (Variable)variable)).forEach(variable -> frame.addFrame("variable", new AbstractFrame[]{((Frame)this.context.build(variable)).addTypes(new String[]{"target"})}));
        target.constraints().stream().filter(c -> !c.negated()).forEach(c -> {
            FacetTarget targetOf = this.findTargetOf(c.node(), target.targetNode());
            if (targetOf != null && !targetOf.equals(target.targetNode())) {
                targetOf.owner().variables().forEach(variable -> frame.addFrame("variable", new AbstractFrame[]{((Frame)this.context.build(variable)).addTypes(new String[]{"target"})}));
            }
        });
        this.addTerminalVariables(target.owner(), frame);
    }

    private FacetTarget findTargetOf(Node node, Node target) {
        FacetTarget facetTarget = node.facetTarget();
        return facetTarget != null && target.equals((Object)facetTarget.targetNode()) ? facetTarget : null;
    }

    private void addTargetComponents(FacetTarget target, Frame frame, Adapter.FrameContext<FacetTarget> context) {
        target.targetNode().components().forEach(component -> {
            if (!this.isOverriden((Node)component, target)) {
                Frame nodeFrame = (Frame)context.build(component);
                nodeFrame.addTypes(new String[]{"target"});
                if ((component instanceof NodeReference && !((NodeReference)component).isHas() || component instanceof NodeImpl) && component.destinyOfReference().parent() != null) {
                    nodeFrame.addTypes(new String[]{"inherited"}).addFrame("parentRef", new String[]{component.destinyOfReference().parent().qualifiedName()});
                }
                nodeFrame.addFrame("targetContainer", new String[]{target.targetNode().name()});
                if (target.targetNode().sizeOf(component).isSingle()) {
                    nodeFrame.addTypes(new String[]{"single"});
                }
                frame.addFrame("node", new AbstractFrame[]{nodeFrame});
            }
        });
    }

    private boolean isOverriden(Node node, FacetTarget facetTarget) {
        for (Node component : facetTarget.owner().components()) {
            if (component.name() == null || !component.name().equals(node.name())) continue;
            return true;
        }
        return false;
    }

    private boolean isOverriden(Node node, Variable variable) {
        for (Variable var : node.variables()) {
            if (!var.name().equals(variable.name())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getImports() {
        return this.imports;
    }
}

