/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.codegeneration.magritte;

import io.intino.tara.compiler.codegeneration.Format;
import io.intino.tara.compiler.model.Model;
import io.intino.tara.lang.model.Facet;
import io.intino.tara.lang.model.FacetTarget;
import io.intino.tara.lang.model.Node;
import io.intino.tara.lang.model.NodeRoot;
import java.util.Arrays;
import java.util.List;

public class NameFormatter {
    public static final char DOT = '.';

    private NameFormatter() {
    }

    public static String getQn(Node node, String workingPackage) {
        if (node.facetTarget() != null) {
            return NameFormatter.getQn(node.facetTarget(), workingPackage).replace(":", "");
        }
        FacetTarget facetTarget = NameFormatter.isInFacetTarget(node);
        return workingPackage.toLowerCase() + '.' + (facetTarget != null ? NameFormatter.composeInFacetTargetQN(node, facetTarget) : Format.qualifiedName().format((Object)node.qualifiedName()));
    }

    private static String qnInsideFacet(String qn) {
        List<String> names = Arrays.asList(qn.split(":"));
        List<String> qnValues = Arrays.asList(names.get(names.size() - 1).split("\\."));
        return String.join((CharSequence)".", qnValues.subList(1, qnValues.size()));
    }

    public static String getQn(FacetTarget target, String workingPackage) {
        return NameFormatter.facetLayerPackage(target, workingPackage) + Format.javaValidName().format((Object)(target.owner().name() + target.targetNode().name())).toString();
    }

    public static String getQn(FacetTarget target, Node owner, String workingPackage) {
        return NameFormatter.facetLayerPackage(target, workingPackage) + Format.javaValidName().format((Object)(owner.name() + target.targetNode().name())).toString();
    }

    public static String getQn(Facet facet, String outDsl) {
        return outDsl.toLowerCase() + '.' + Format.javaValidName().format((Object)facet.type());
    }

    public static String stashQn(Node node, String workingPackage) {
        FacetTarget facet = NameFormatter.isInFacetTarget(node);
        return facet != null ? NameFormatter.facetLayerPackage(facet, workingPackage) + Format.javaClassNames().format((Object)node.cleanQn()).toString() : workingPackage.toLowerCase() + '.' + Format.javaClassNames().format((Object)node.cleanQn()).toString();
    }

    private static FacetTarget isInFacetTarget(Node node) {
        Node container;
        for (container = node.container(); container != null && container.facetTarget() == null; container = container.container()) {
        }
        return container != null ? container.facetTarget() : null;
    }

    public static String cleanQn(String qualifiedName) {
        return qualifiedName.replace("anonymous@", "").replace("[", "").replace("]", "").replace(":", "").replace("#", "");
    }

    public static String composeInFacetTargetQN(Node node, FacetTarget target) {
        return target.owner().name().toLowerCase() + '.' + (!(target.targetNode().container() instanceof NodeRoot) ? target.targetNode().container().qualifiedName().toLowerCase() + '.' : "") + Format.qualifiedName().format((Object)(target.owner().name() + "#" + target.targetNode().name())).toString() + '.' + NameFormatter.qnInsideFacet(node.qualifiedName());
    }

    public static String facetLayerPackage(FacetTarget target, String workingPackage) {
        return (workingPackage.toLowerCase() + '.' + target.owner().name()).toLowerCase() + (!(target.targetNode().container() instanceof Model) ? '.' + target.targetNode().container().qualifiedName().toLowerCase().replace(":", ".") + '.' : Character.valueOf('.'));
    }
}

