/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.codegeneration.magritte;

import io.intino.tara.Language;
import io.intino.tara.compiler.codegeneration.Format;
import io.intino.tara.compiler.codegeneration.magritte.NameFormatter;
import io.intino.tara.compiler.codegeneration.magritte.TemplateTags;
import io.intino.tara.compiler.codegeneration.magritte.layer.TypesProvider;
import io.intino.tara.compiler.codegeneration.magritte.natives.NativeExtractor;
import io.intino.tara.compiler.model.NodeReference;
import io.intino.tara.compiler.model.VariableReference;
import io.intino.tara.lang.model.Facet;
import io.intino.tara.lang.model.FacetTarget;
import io.intino.tara.lang.model.Node;
import io.intino.tara.lang.model.Parameter;
import io.intino.tara.lang.model.Primitive;
import io.intino.tara.lang.model.Rule;
import io.intino.tara.lang.model.Tag;
import io.intino.tara.lang.model.Variable;
import io.intino.tara.lang.model.rules.variable.NativeObjectRule;
import io.intino.tara.lang.model.rules.variable.NativeRule;
import io.intino.tara.lang.model.rules.variable.VariableCustomRule;
import io.intino.tara.lang.model.rules.variable.WordRule;
import io.intino.tara.lang.semantics.Constraint;
import io.intino.tara.lang.semantics.Context;
import io.intino.tara.lang.semantics.constraints.parameter.ReferenceParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.siani.itrules.Adapter;
import org.siani.itrules.engine.FrameBuilder;
import org.siani.itrules.engine.adapters.ExcludeAdapter;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public abstract class Generator
implements TemplateTags {
    protected final Language language;
    protected final String outDsl;
    protected final String workingPackage;
    protected final String languageWorkingPackage;
    protected Set<String> imports = new HashSet<String>();

    public Generator(Language language, String outDsl, String workingPackage, String languageWorkingPackage) {
        this.language = language;
        this.outDsl = outDsl;
        this.workingPackage = workingPackage;
        this.languageWorkingPackage = languageWorkingPackage;
    }

    protected void addComponents(Frame frame, Node node, Adapter.FrameContext<FacetTarget> context) {
        if (node instanceof NodeReference) {
            return;
        }
        node.components().stream().filter(component -> !component.isAnonymous() && (!component.isReference() || ((NodeReference)component).isHas())).forEach(component -> {
            Frame nodeFrame = (Frame)context.build(component);
            nodeFrame.addTypes(new String[]{"owner"});
            frame.addFrame("node", new AbstractFrame[]{nodeFrame});
        });
    }

    protected String getType(Variable variable, String workingPackage) {
        if (variable instanceof VariableReference) {
            return NameFormatter.cleanQn(NameFormatter.getQn(((VariableReference)variable).getDestiny(), workingPackage.toLowerCase()));
        }
        if (Primitive.WORD.equals((Object)variable.type())) {
            return variable.rule() != null && variable.rule() instanceof VariableCustomRule ? workingPackage.toLowerCase() + ".rules." + Format.firstUpperCase().format((Object)((VariableCustomRule)variable.rule()).getSource()) : Format.firstUpperCase().format((Object)variable.name()).toString();
        }
        if (Primitive.OBJECT.equals((Object)variable.type())) {
            return ((NativeObjectRule)variable.rule()).type();
        }
        return variable.type().javaName();
    }

    protected static FacetTarget isInFacet(Node node) {
        Node container;
        for (container = node.container(); container != null && container.facetTarget() == null; container = container.container()) {
        }
        return container != null ? container.facetTarget() : null;
    }

    protected Frame ruleToFrame(Rule rule) {
        if (rule == null) {
            return null;
        }
        FrameBuilder frameBuilder = new FrameBuilder();
        frameBuilder.register(Rule.class, (Adapter)new ExcludeAdapter(new String[]{"loadedClass"}));
        Frame frame = (Frame)frameBuilder.build((Object)rule);
        if (rule instanceof VariableCustomRule) {
            frame.addFrame("qn", new String[]{((VariableCustomRule)rule).getLoadedClass().getName()});
            if (((VariableCustomRule)rule).isMetric()) {
                frame.addTypes(new String[]{"metric"});
                frame.addFrame("default", new String[]{((VariableCustomRule)rule).getDefaultUnit()});
            }
        }
        return frame;
    }

    protected Predicate<Tag> isLayerInterface() {
        return tag -> tag.equals((Object)Tag.Component) || tag.equals((Object)Tag.Feature) || tag.equals((Object)Tag.Terminal) || tag.equals((Object)Tag.Private) || tag.equals((Object)Tag.Volatile) || tag.equals((Object)Tag.Versioned);
    }

    protected void addTerminalVariables(Node node, Frame frame) {
        List<Constraint> terminalCoreVariables = this.collectTerminalCoreVariables(node);
        if (node.parent() == null && !terminalCoreVariables.isEmpty() && !Arrays.asList(frame.slots()).contains("metaType".toLowerCase())) {
            frame.addFrame("metaType", new String[]{this.languageWorkingPackage + "." + this.metaType(node)});
        }
        terminalCoreVariables.forEach(c -> this.addTerminalVariable(this.languageWorkingPackage + "." + node.type(), frame, (Constraint.Parameter)c, node.parent() != null, this.isRequired(node, (Constraint.Parameter)c), "metaType", this.languageWorkingPackage));
        this.addFacetVariables(node, frame);
    }

    private boolean isRequired(Node node, Constraint.Parameter allow) {
        Node n;
        Node node2 = n = node.isReference() ? node.destinyOfReference() : node;
        while (n != null) {
            for (Parameter parameter : n.parameters()) {
                if (!parameter.name().equals(allow.name())) continue;
                return false;
            }
            n = n.parent();
        }
        return true;
    }

    private void addFacetVariables(Node node, Frame frame) {
        for (Facet facet : node.facets()) {
            frame.addFrame("metaFacet", new AbstractFrame[]{new Frame().addTypes(new String[]{"metaFacet"}).addFrame("name", new String[]{facet.type()}).addFrame("type", new String[]{this.metaType(facet)})});
        }
        this.collectTerminalFacetVariables(node).entrySet().forEach(entry -> ((List)entry.getValue()).forEach(c -> this.addTerminalVariable(this.languageWorkingPackage + "." + node.type(), frame, (Constraint.Parameter)c, node.parent() != null, this.isRequired(node, (Constraint.Parameter)c), (String)entry.getKey(), this.languageWorkingPackage)));
    }

    private List<Constraint> collectTerminalCoreVariables(Node node) {
        List allows = this.language.constraints(node.type());
        if (allows == null) {
            return Collections.emptyList();
        }
        return allows.stream().filter(allow -> allow instanceof Constraint.Parameter && ((Constraint.Parameter)allow).flags().contains(Tag.Terminal) && !Generator.isRedefined((Constraint.Parameter)allow, node.variables())).collect(Collectors.toList());
    }

    private Map<String, List<Constraint>> collectTerminalFacetVariables(Node node) {
        return Generator.collectFacetConstrains(this.language.constraints(node.type()), node);
    }

    private static Map<String, List<Constraint>> collectFacetConstrains(List<Constraint> constraints, Node node) {
        if (constraints == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<Constraint>> map = new HashMap<String, List<Constraint>>();
        List<Constraint> facets = constraints.stream().filter(c -> c instanceof Constraint.Facet && Generator.hasFacet(node, ((Constraint.Facet)c).type())).collect(Collectors.toList());
        for (Constraint facet : facets) {
            map.put(((Constraint.Facet)facet).type(), new ArrayList());
        }
        facets.forEach(f -> map.put(((Constraint.Facet)f).type(), ((Constraint.Facet)f).constraints().stream().filter(Generator.byTerminalParameters(node)).collect(Collectors.toList())));
        return map;
    }

    private static boolean hasFacet(Node node, String type) {
        for (Facet facet : node.facets()) {
            if (!facet.type().equals(type)) continue;
            return true;
        }
        return false;
    }

    private static Predicate<Constraint> byTerminalParameters(Node node) {
        return o -> o instanceof Constraint.Parameter && ((Constraint.Parameter)o).flags().contains(Tag.Terminal) && !Generator.isRedefined((Constraint.Parameter)o, node.variables());
    }

    private String metaType(Facet facet) {
        for (String key : this.language.catalog().keySet()) {
            if (!key.startsWith(facet.type() + ":")) continue;
            return ((Context)this.language.catalog().get(key)).doc().layer();
        }
        return "";
    }

    protected String metaType(Node node) {
        String type = node.type();
        return type.contains(":") ? type.split(":")[0].toLowerCase() + "." + node.type().replace(":", "") : node.type();
    }

    private static boolean isRedefined(Constraint.Parameter allow, List<? extends Variable> variables) {
        for (Variable variable : variables) {
            if (!variable.name().equals(allow.name())) continue;
            return true;
        }
        return false;
    }

    private void addTerminalVariable(String type, Frame frame, Constraint.Parameter parameter, boolean inherited, boolean isRequired, String containerName, String languageWorkingPackage) {
        frame.addFrame("variable", new AbstractFrame[]{this.createFrame(parameter, type, inherited, isRequired, containerName, languageWorkingPackage)});
    }

    private Frame createFrame(Constraint.Parameter parameter, String type, boolean inherited, boolean isRequired, String containerName, String workingPackage) {
        WordRule rule;
        Frame frame = new Frame();
        frame.addTypes(TypesProvider.getTypes(parameter, isRequired));
        if (inherited) {
            frame.addTypes(new String[]{"inherited"});
        }
        frame.addTypes(new String[]{"metaType"});
        frame.addTypes(new String[]{"target"});
        frame.addFrame("name", new String[]{parameter.name()});
        frame.addFrame("containerName", new String[]{containerName});
        frame.addFrame("qn", new String[]{type});
        frame.addFrame("language", new String[]{this.language.languageName().toLowerCase()});
        frame.addFrame("workingPackage", new String[]{workingPackage});
        frame.addFrame("type", new String[]{this.type(parameter)});
        if (parameter.type().equals((Object)Primitive.WORD)) {
            rule = (WordRule)parameter.rule();
            List words = rule.words();
            if (rule.isCustom()) {
                frame.addTypes(new String[]{"outDefined"});
                frame.addFrame("externalClass", new String[]{rule.externalWordClass()});
            }
            frame.addFrame("wordValues", words.toArray(new String[words.size()]));
        }
        if (parameter.type().equals((Object)Primitive.FUNCTION)) {
            rule = (NativeRule)parameter.rule();
            String signature = rule.signature();
            NativeExtractor extractor = new NativeExtractor(signature);
            frame.addFrame("methodName", new String[]{extractor.methodName()});
            frame.addFrame("parameters", new String[]{extractor.parameters()});
            frame.addFrame("returnType", new String[]{extractor.returnValue()});
            frame.addFrame("rule", new String[]{rule.interfaceClass()});
            frame.addFrame("generatedLanguage", new String[]{parameter.scope()});
            this.imports.addAll(rule.imports().stream().collect(Collectors.toList()));
        }
        if (!Arrays.asList(frame.slots()).contains("generatedLanguage".toLowerCase())) {
            frame.addFrame("generatedLanguage", new String[]{this.outDsl.toLowerCase()});
        }
        return frame;
    }

    private String type(Constraint.Parameter parameter) {
        if (parameter instanceof ReferenceParameter) {
            return this.languageWorkingPackage + "." + ((ReferenceParameter)parameter).referenceType();
        }
        return parameter.type().getName();
    }

    public Set<String> getImports() {
        return this.imports;
    }

    protected void addParent(Frame frame, Node node) {
        Node parent = node.parent();
        if (parent != null) {
            frame.addFrame("parent", new String[]{NameFormatter.cleanQn(NameFormatter.getQn(parent, this.workingPackage))});
        }
    }
}

