/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.codegeneration.lang;

import io.intino.tara.Language;
import io.intino.tara.compiler.codegeneration.magritte.TemplateTags;
import io.intino.tara.compiler.model.Model;
import io.intino.tara.compiler.model.NodeReference;
import io.intino.tara.lang.model.Metric;
import io.intino.tara.lang.model.Node;
import io.intino.tara.lang.model.NodeContainer;
import io.intino.tara.lang.model.Parameter;
import io.intino.tara.lang.model.Parametrized;
import io.intino.tara.lang.model.Primitive;
import io.intino.tara.lang.model.Rule;
import io.intino.tara.lang.model.Tag;
import io.intino.tara.lang.model.rules.Size;
import io.intino.tara.lang.model.rules.variable.ReferenceRule;
import io.intino.tara.lang.model.rules.variable.VariableCustomRule;
import io.intino.tara.lang.semantics.Assumption;
import io.intino.tara.lang.semantics.Constraint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.siani.itrules.Adapter;
import org.siani.itrules.engine.FrameBuilder;
import org.siani.itrules.engine.adapters.ExcludeAdapter;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

class TerminalConstraintManager
implements TemplateTags {
    private final Language language;
    private final NodeContainer scope;

    TerminalConstraintManager(Language language, Model model) {
        this.language = language;
        this.scope = model;
    }

    TerminalConstraintManager(Language language, NodeContainer scope) {
        this.language = language;
        this.scope = scope;
    }

    void addConstraints(List<Constraint> constraints, Frame constraintsFrame) {
        for (Constraint c : constraints) {
            if (c instanceof Constraint.Name) {
                this.addName(constraintsFrame, "constraint");
                continue;
            }
            if (c instanceof Constraint.Component) {
                this.asComponent(constraintsFrame, (Constraint.Component)c);
                continue;
            }
            if (c instanceof Constraint.Parameter) {
                this.addParameter(constraintsFrame, (Constraint.Parameter)c, "constraint");
                continue;
            }
            if (!(c instanceof Constraint.Facet)) continue;
            this.addFacet(constraintsFrame, (Constraint.Facet)c);
        }
    }

    private void asComponent(Frame constraintsFrame, Constraint.Component component) {
        if (TerminalConstraintManager.isInstance(component.annotations())) {
            this.addComponent(constraintsFrame, component);
        } else {
            ArrayList<Node> nodes = new ArrayList<Node>();
            this.findInstancesOf(component.type(), nodes);
            nodes.forEach(n -> this.addComponent(constraintsFrame, (Node)n));
        }
    }

    private void addName(Frame constraints, String relation) {
        constraints.addFrame(relation, new String[]{"name"});
    }

    private void addFacet(Frame constraints, Constraint.Facet facet) {
        Frame frame = new Frame().addTypes(new String[]{"constraint", "facet"});
        frame.addFrame("value", new String[]{facet.type()});
        if (facet.terminal()) {
            frame.addFrame("terminal", new String[]{"true"});
        }
        frame.addFrame("with", facet.with());
        this.addConstraints(facet.constraints(), frame);
        constraints.addFrame("constraint", new AbstractFrame[]{frame});
    }

    private void addParameter(Frame constraints, Constraint.Parameter constraint, String relation) {
        Object[] parameters = new Object[]{constraint.name(), constraint.type(), this.sizeOfTerminal(constraint), constraint.facet(), constraint.position(), constraint.scope(), this.ruleToFrame((Rule)constraint.rule()), constraint.flags().stream().map(Enum::name).toArray(String[]::new)};
        Frame primitiveFrame = new Frame();
        if (Primitive.REFERENCE.equals((Object)constraint.type())) {
            this.fillAllowedReferences((ReferenceRule)constraint.rule());
            primitiveFrame.addTypes(new String[]{"reference"});
        }
        this.renderPrimitive(primitiveFrame, parameters, relation);
        constraints.addFrame(relation, new AbstractFrame[]{primitiveFrame});
    }

    private void fillAllowedReferences(ReferenceRule rule) {
        if (!this.allowedValuesAreTerminal(rule)) {
            rule.setAllowedReferences(Arrays.asList(this.instancesOfNonTerminalReference(rule)));
        }
    }

    private Frame renderPrimitive(Frame frame, Object[] parameters, String relation) {
        frame.addTypes(new String[]{relation, "parameter"});
        this.fillParameterFrame(parameters, frame);
        return frame;
    }

    private void fillParameterFrame(Object[] parameters, Frame frame) {
        frame.addFrame("name", new Object[]{parameters[0]}).addFrame("type", new Object[]{parameters[1]}).addFrame("size", new AbstractFrame[]{(Frame)parameters[2]}).addFrame("facet", new Object[]{parameters[3]}).addFrame("position", new Object[]{parameters[4]}).addFrame("scope", new Object[]{parameters[5]});
        if (parameters[6] != null) {
            frame.addFrame("rule", new AbstractFrame[]{(Frame)parameters[6]});
        }
        frame.addFrame("tags", (String[])parameters[7]);
    }

    private Frame ruleToFrame(Rule rule) {
        Frame frame;
        if (rule == null) {
            return null;
        }
        FrameBuilder frameBuilder = new FrameBuilder();
        frameBuilder.register(Rule.class, (Adapter)new ExcludeAdapter(new String[]{"loadedClass"}));
        Frame frame2 = frame = rule.getClass().isEnum() ? new Frame().addTypes(new String[]{"customrule", "rule"}) : (Frame)frameBuilder.build((Object)rule);
        if (rule instanceof VariableCustomRule) {
            this.fillCustomRule((VariableCustomRule)rule, frame);
        } else if (rule.getClass().isEnum()) {
            this.fillInheritedCustomRule(rule, frame);
        }
        return frame;
    }

    private String[] instancesOfNonTerminalReference(ReferenceRule rule) {
        ArrayList instances = new ArrayList();
        rule.allowedReferences().forEach(type -> this.findInstancesOf((String)type, instances));
        return instances.stream().map(Node::qualifiedName).collect(Collectors.toList()).toArray(new String[instances.size()]);
    }

    private void findInstancesOf(String type, List<Node> instances) {
        this.findInstancesOf(this.scope, type, instances);
    }

    private void findInstancesOf(NodeContainer node, String type, List<Node> result) {
        for (Node component : node.components()) {
            if (component.type().equals(type)) {
                result.add(component);
            }
            if (component instanceof NodeReference) continue;
            this.findInstancesOf((NodeContainer)component, type, result);
        }
    }

    private boolean allowedValuesAreTerminal(ReferenceRule rule) {
        for (String node : rule.allowedReferences()) {
            if (this.isTerminal(node)) continue;
            return false;
        }
        return true;
    }

    private boolean isTerminal(String node) {
        if (this.language.assumptions(node) == null) {
            return false;
        }
        for (Assumption assumption : this.language.assumptions(node)) {
            if (assumption instanceof Assumption.Terminal) continue;
            return true;
        }
        return false;
    }

    private static boolean isInstance(List<Tag> annotations) {
        return annotations.contains(Tag.Instance);
    }

    private void fillCustomRule(VariableCustomRule rule, Frame frame) {
        frame.addFrame("qn", new String[]{rule.getLoadedClass().getName()});
        if (rule.isMetric()) {
            frame.addTypes(new String[]{"metric"});
            frame.addFrame("default", new String[]{rule.getDefaultUnit()});
        }
    }

    private void fillInheritedCustomRule(Rule rule, Frame frame) {
        frame.addFrame("qn", new String[]{rule.getClass().getName()});
        if (rule instanceof Metric) {
            frame.addTypes(new String[]{"metric"});
            frame.addFrame("default", new String[]{((Enum)rule).name()});
        }
    }

    private void addComponent(Frame frame, Constraint.Component component) {
        Frame constraint = new Frame().addTypes(new String[]{"constraint", component instanceof Constraint.OneOf ? "oneOf" : "component"});
        constraint.addFrame("type", new String[]{component.type()});
        constraint.addFrame("size", new AbstractFrame[]{this.sizeOfTerminal(component)});
        constraint.addFrame("tags", (String[])component.annotations().stream().map(Enum::name).toArray(String[]::new));
        if (component instanceof Constraint.OneOf) {
            ((Constraint.OneOf)component).components().forEach(c -> this.addComponent(constraint, (Constraint.Component)c));
        }
        frame.addFrame("constraint", new AbstractFrame[]{constraint});
    }

    private void addComponent(Frame frame, Node component) {
        if (component.name() == null) {
            return;
        }
        Frame constraint = new Frame().addTypes(new String[]{"constraint", "component"});
        constraint.addFrame("type", new String[]{component.name()});
        constraint.addFrame("size", new AbstractFrame[]{new FrameBuilder().build((Object)component.container().sizeOf(component))});
        constraint.addFrame("tags", (String[])component.flags().stream().map(Enum::name).toArray(String[]::new));
        frame.addFrame("constraint", new AbstractFrame[]{constraint});
    }

    private Frame sizeOfTerminal(Constraint.Component constraint) {
        if (constraint == null) {
            return new Frame().addFrame("value", new String[]{"null"});
        }
        FrameBuilder builder = new FrameBuilder();
        Size rule = (Size)constraint.rules().stream().filter(r -> r instanceof Size).findFirst().orElse((Rule)Size.MULTIPLE());
        return (Frame)builder.build((Object)(rule.into() != null ? this.getIntoRule(constraint, rule) : rule));
    }

    private Size getIntoRule(Constraint.Component constraint, Size rule) {
        if (!rule.into().isRequired()) {
            return rule.into();
        }
        return this.existsComponent(constraint.type()) ? new Size(0, rule.into().max()) : rule.into();
    }

    private Frame sizeOfTerminal(Constraint.Parameter constraint) {
        if (constraint == null) {
            return new Frame().addFrame("value", new String[]{"null"});
        }
        boolean isFilled = this.isParameterFilled(constraint.name());
        FrameBuilder builder = new FrameBuilder();
        Size size = constraint.size();
        if (isFilled) {
            return (Frame)builder.build((Object)size);
        }
        return (Frame)builder.build((Object)(size.into() != null ? size.into() : size));
    }

    private boolean isParameterFilled(String name) {
        if (this.scope instanceof Parametrized) {
            for (Parameter parameter : ((Parametrized)this.scope).parameters()) {
                if (!name.equals(parameter.name())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean existsComponent(String type) {
        if (this.scope instanceof Node) {
            for (Node node : this.scope.components()) {
                if (!type.equals(node.type())) continue;
                return true;
            }
        }
        return false;
    }
}

