/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.codegeneration.lang;

import io.intino.tara.compiler.codegeneration.FileSystemUtils;
import io.intino.tara.compiler.codegeneration.Format;
import io.intino.tara.compiler.codegeneration.JavaCompiler;
import io.intino.tara.compiler.codegeneration.lang.LanguageCreator;
import io.intino.tara.compiler.core.CompilerConfiguration;
import io.intino.tara.compiler.core.errorcollection.TaraException;
import io.intino.tara.compiler.model.Model;
import io.intino.tara.dsl.Proteo;
import io.intino.tara.dsl.Verso;
import io.intino.tara.lang.semantics.Constraint;
import io.intino.tara.lang.semantics.Context;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class LanguageSerializer {
    private static final Logger LOG = Logger.getGlobal();
    private static final String JAVA = ".java";
    private static final String JAR = ".jar";
    private static final String TARA_LANG_PACKAGE = "tara.lang";
    private final CompilerConfiguration conf;
    private final Collection<Model> models;

    public LanguageSerializer(CompilerConfiguration conf, Collection<Model> models) {
        this.conf = conf;
        this.models = models;
    }

    public void write() throws TaraException {
        this.conf.getTaraProjectDirectory().mkdirs();
        this.write(new LanguageCreator(this.conf, this.models).create(), this.getDslDestiny(), this.collectRules(this.models));
    }

    private List<Class<?>> collectRules(Collection<Model> models) {
        HashSet classes = new HashSet();
        for (Model model : models) {
            classes.addAll(model.getRules().values());
            classes.addAll(this.collectLanguageRules(model));
        }
        return new ArrayList(classes);
    }

    private List<Class<?>> collectLanguageRules(Model model) {
        ArrayList classes = new ArrayList();
        for (Context context : model.getLanguage().catalog().values()) {
            classes.addAll(this.getRulesOfNode(context));
        }
        return classes;
    }

    private List<Class<?>> getRulesOfNode(Context context) {
        return context.constraints().stream().filter(constraint -> constraint instanceof Constraint.Parameter && ((Constraint.Parameter)constraint).rule() != null && !((Constraint.Parameter)constraint).rule().getClass().getName().startsWith(TARA_LANG_PACKAGE)).map(constraint -> ((Constraint.Parameter)constraint).rule().getClass()).collect(Collectors.toList());
    }

    private File getDslDestiny() {
        File file = new File(this.conf.getTaraDirectory(), "repository" + File.separator + this.conf.dslGroupId().replace(".", File.separator) + File.separator + Format.reference().format((Object)this.conf.outDSL()).toString().toLowerCase() + File.separator + this.conf.version());
        file.mkdirs();
        return new File(file, Format.reference().format(Format.firstUpperCase().format((Object)this.conf.outDSL())) + JAVA);
    }

    private void write(String content, File javaFile, List<Class<?>> rules) throws TaraException {
        try {
            File dslDestiny = javaFile.getParentFile();
            if (dslDestiny.exists()) {
                FileSystemUtils.removeDir(dslDestiny);
            }
            dslDestiny.mkdirs();
            Files.write(javaFile.toPath(), content.getBytes(), new OpenOption[0]);
            JavaCompiler.compile(javaFile, String.join((CharSequence)File.pathSeparator, this.collectClassPath(rules)), this.getDslDestiny().getParentFile());
            this.jar(dslDestiny, rules.stream().filter(v -> !v.getName().startsWith(TARA_LANG_PACKAGE)).collect(Collectors.toList()));
        }
        catch (IOException e) {
            throw new TaraException("Error creating language: " + e.getMessage(), e);
        }
    }

    private Collection<String> collectClassPath(Collection<Class<?>> values) throws IOException {
        HashSet<String> dependencies = new HashSet<String>();
        dependencies.add(this.conf.getSemanticRulesLib().getAbsolutePath());
        for (Model model : this.models) {
            if (model.getLanguage() instanceof Proteo || model.getLanguage() instanceof Verso) continue;
            try {
                dependencies.add(Paths.get(model.getLanguage().getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).toFile().getCanonicalPath().replaceAll("%20", " "));
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        dependencies.addAll(values.stream().filter(v -> !v.getName().startsWith(TARA_LANG_PACKAGE)).map(value -> value.getProtectionDomain().getCodeSource().getLocation().getPath()).collect(Collectors.toList()));
        return dependencies;
    }

    private void jar(File dslDir, List<Class<?>> rules) throws IOException {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().put(Attributes.Name.IMPLEMENTATION_VERSION, this.conf.version());
        manifest.getEntries().put("tara", this.createTaraProperties());
        JarOutputStream target = new JarOutputStream((OutputStream)new FileOutputStream(new File(dslDir, Format.reference().format((Object)this.conf.outDSL()).toString() + "-" + this.conf.version() + JAR)), manifest);
        File src = new File(dslDir, "tara");
        this.add(dslDir, src, target);
        this.addRules(rules, target);
        this.addInheritedRules(target);
        target.close();
        FileSystemUtils.removeDir(src);
    }

    private Attributes createTaraProperties() {
        Attributes taraAttributes = new Attributes();
        taraAttributes.put(new Attributes.Name("groupId"), this.conf.groupId());
        taraAttributes.put(new Attributes.Name("artifactId"), this.conf.artifactId());
        taraAttributes.put(new Attributes.Name("version"), this.conf.version());
        taraAttributes.put(new Attributes.Name("out.dsl".replace(".", "-")), this.conf.outDSL());
        taraAttributes.put(new Attributes.Name("level"), this.conf.level().name());
        taraAttributes.put(new Attributes.Name("framework"), this.conf.groupId() + ":" + this.conf.artifactId() + ":" + this.conf.version());
        taraAttributes.put(new Attributes.Name("working.package".replace(".", "-")), this.conf.workingPackage());
        return taraAttributes;
    }

    private void addInheritedRules(JarOutputStream target) throws IOException {
        for (Model model : this.models) {
            if (model.getLanguage() instanceof Proteo || model.getLanguage() instanceof Verso) {
                return;
            }
            File tempDirectory = this.conf.getTempDirectory();
            this.conf.cleanTemp();
            FileSystemUtils.extractJar(model.getLanguage().getClass().getProtectionDomain().getCodeSource().getLocation().getPath(), tempDirectory);
            File[] languageDirectories = this.languageDirectory(tempDirectory);
            ArrayList<File> rules = new ArrayList<File>();
            for (File d : languageDirectories) {
                FileSystemUtils.getAllFiles(d, rules);
            }
            rules.stream().filter(f -> f.getName().endsWith(".class")).forEach(r -> {
                try {
                    this.add(this.conf.getTempDirectory(), (File)r, target);
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, e.getMessage(), e);
                }
            });
        }
    }

    private File[] languageDirectory(File tempDirectory) {
        return tempDirectory.listFiles(file -> file.isDirectory() && !file.getName().equals("META-INF") && !file.getName().equals("tara"));
    }

    private void addRules(List<Class<?>> rules, JarOutputStream target) throws IOException {
        HashMap<File, String> ruleFiles = new HashMap<File, String>();
        for (Class<?> clazz : rules) {
            String base = clazz.getProtectionDomain().getCodeSource().getLocation().getPath();
            ArrayList<File> files = new ArrayList<File>();
            FileSystemUtils.getAllFiles(new File(base), files);
            for (File file : files) {
                ruleFiles.put(file, base);
            }
        }
        for (Map.Entry entry : ruleFiles.entrySet()) {
            this.add(new File((String)entry.getValue()), (File)entry.getKey(), target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(File base, File source, JarOutputStream target) throws IOException {
        try (BufferedInputStream in = null;){
            if (source.isDirectory()) {
                this.createDirectory(base, source, target);
                return;
            }
            JarEntry entry = new JarEntry(this.getRelativePath(base, source).replace("\\", "/"));
            entry.setTime(source.lastModified());
            target.putNextEntry(entry);
            in = this.writeEntry(source, target);
            target.closeEntry();
        }
    }

    private BufferedInputStream writeEntry(File source, JarOutputStream target) throws IOException {
        int count;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(source));
        byte[] buffer = new byte[1024];
        while ((count = in.read(buffer)) != -1) {
            target.write(buffer, 0, count);
        }
        return in;
    }

    private void createDirectory(File base, File source, JarOutputStream target) throws IOException {
        String name = this.getRelativePath(base, source).replace("\\", "/");
        if (!name.isEmpty()) {
            this.createEntry(source, target, name);
        }
        for (File nestedFile : source.listFiles()) {
            this.add(base, nestedFile, target);
        }
    }

    private void createEntry(File source, JarOutputStream target, String name) throws IOException {
        if (!name.endsWith("/")) {
            name = name + "/";
        }
        JarEntry entry = new JarEntry(name);
        entry.setTime(source.lastModified());
        target.putNextEntry(entry);
        target.closeEntry();
    }

    private String getRelativePath(File base, File source) {
        return source.getPath().replace(base.getAbsolutePath() + File.separator, "");
    }
}

