/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.codegeneration.lang;

import io.intino.tara.Language;
import io.intino.tara.compiler.codegeneration.lang.TerminalConstraintManager;
import io.intino.tara.compiler.codegeneration.magritte.TemplateTags;
import io.intino.tara.compiler.model.Model;
import io.intino.tara.lang.semantics.Assumption;
import io.intino.tara.lang.semantics.Constraint;
import io.intino.tara.lang.semantics.Context;
import java.util.List;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

class LanguageInheritanceManager
implements TemplateTags {
    private final Frame root;
    private final List<String> instances;
    private final Language language;
    private TerminalConstraintManager manager;

    LanguageInheritanceManager(Frame root, List<String> instances, Language language, Model model) {
        this.root = root;
        this.instances = instances;
        this.language = language;
        this.manager = new TerminalConstraintManager(language, model);
    }

    void fill() {
        if (this.instances == null || this.root == null) {
            return;
        }
        for (String instance : this.instances) {
            Frame nodeFrame = new Frame().addTypes(new String[]{"node"});
            this.fillRuleInfo(nodeFrame, instance);
            this.addConstraints(nodeFrame, this.language.constraints(instance));
            this.addAssumptions(nodeFrame, this.language.assumptions(instance));
            this.root.addFrame("node", new AbstractFrame[]{nodeFrame});
        }
    }

    private void addConstraints(Frame frame, List<Constraint> constraints) {
        Frame constraintsFrame = new Frame().addTypes(new String[]{"constraints"});
        this.manager.addConstraints(constraints, constraintsFrame);
        frame.addFrame("constraints", new AbstractFrame[]{constraintsFrame});
    }

    private void fillRuleInfo(Frame frame, String aCase) {
        Context rules = (Context)this.language.catalog().get(aCase);
        frame.addFrame("name", new String[]{aCase});
        this.addTypes(rules.types(), frame);
    }

    private void addTypes(String[] types, Frame frame) {
        if (types == null) {
            return;
        }
        Frame typesFrame = new Frame().addTypes(new String[]{"nodeType"});
        for (String type : types) {
            typesFrame.addFrame("type", new String[]{type});
        }
        if (typesFrame.slots().length > 0) {
            frame.addFrame("nodeType", new AbstractFrame[]{typesFrame});
        }
    }

    private void addAssumptions(Frame frame, List<Assumption> assumptions) {
        Frame assumptionsFrame = new Frame().addTypes(new String[]{"assumptions"});
        for (Assumption assumption : assumptions) {
            assumptionsFrame.addFrame("assumption", new Object[]{this.getAssumptionValue(assumption)});
        }
        if (assumptionsFrame.slots().length != 0) {
            frame.addFrame("assumptions", new AbstractFrame[]{assumptionsFrame});
        }
    }

    private Object getAssumptionValue(Assumption assumption) {
        return assumption.getClass().getInterfaces()[0].getName().substring(assumption.getClass().getInterfaces()[0].getName().lastIndexOf("$") + 1);
    }
}

