/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.codegeneration;

import io.intino.tara.compiler.core.errorcollection.TaraException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class JavaCompiler {
    public static void compile(File file, String classPath, File destiny) throws TaraException {
        javax.tools.JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, null, null);
        Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromStrings(Collections.singletonList(file.getAbsolutePath()));
        ArrayList<String> options = new ArrayList<String>();
        options.add("-source");
        options.add("1.8");
        options.add("-target");
        options.add("1.8");
        options.add("-d");
        options.add(destiny.getAbsolutePath());
        options.add("-classpath");
        options.add(classPath);
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, options, null, compilationUnits);
        if (!task.call().booleanValue()) {
            String message = "";
            for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                message = message + diagnostic.getMessage(Locale.ENGLISH) + "\n";
            }
            throw new TaraException(message.substring(0, message.indexOf("\n")));
        }
        try {
            fileManager.close();
        }
        catch (IOException e) {
            throw new TaraException("Error compiling language. + " + e.getMessage());
        }
    }
}

