/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara;

import io.intino.tara.Language;
import io.intino.tara.TaraCompilerRunner;
import io.intino.tara.compiler.core.CompilerConfiguration;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.io.Stash;
import io.intino.tara.io.StashDeserializer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;

public class StashBuilder {
    private final String dsl;
    private final String dslVersion;
    private final String module;
    private final File file;
    private final Language language;
    private File workingDirectory;

    public StashBuilder(File source, String dsl, String dslVersion, String module) {
        this.dsl = dsl;
        this.dslVersion = dslVersion;
        this.module = module;
        this.file = source;
        this.language = null;
        try {
            this.workingDirectory = Files.createTempDirectory("_stash_builder", new FileAttribute[0]).toFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public StashBuilder(File source, Language language, String module) {
        this.file = source;
        this.language = language;
        this.dsl = language.languageName();
        this.dslVersion = null;
        this.module = module;
        try {
            this.workingDirectory = Files.createTempDirectory("_stash_builder", new FileAttribute[0]).toFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Stash build() {
        try {
            new TaraCompilerRunner(false).run(this.createConfiguration(), this.file);
            File createdStash = this.findCreatedStash();
            if (createdStash == null || !createdStash.exists()) {
                return null;
            }
            Stash stash = StashDeserializer.stashFrom((File)createdStash);
            createdStash.delete();
            return stash;
        }
        catch (Throwable e) {
            return null;
        }
    }

    private File findCreatedStash() {
        File[] list = this.workingDirectory.listFiles((dir, name) -> name.endsWith(".stash"));
        if (list == null || list.length == 0) {
            return null;
        }
        return Arrays.asList(list).get(0);
    }

    private CompilerConfiguration createConfiguration() {
        CompilerConfiguration configuration = new CompilerConfiguration();
        configuration.level(Configuration.Level.System);
        configuration.setTaraDirectory(new File(new File(System.getProperty("user.home")), ".m2"));
        configuration.setOutDirectory(this.workingDirectory);
        configuration.setResourcesDirectory(this.workingDirectory);
        configuration.setModule(this.module);
        configuration.setExcludedPhases(Arrays.asList(1, 8, 10, 11));
        configuration.setMake(true);
        configuration.systemStashName(this.module);
        if (this.language == null) {
            configuration.addLanguage(this.dsl, this.dslVersion);
        } else {
            configuration.addLanguage(this.language);
        }
        return configuration;
    }
}

