/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.dependencyresolution;

import io.intino.tara.builder.core.CompilerConfiguration;
import io.intino.tara.builder.model.Model;
import io.intino.tara.builder.model.MogramReference;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.Tag;

public class TerminalResolver {
    private final Model model;
    private final CompilerConfiguration.Level level;

    public TerminalResolver(Model model, CompilerConfiguration.Level level) {
        this.model = model;
        this.level = level;
    }

    public void resolve() {
        this.resolveTerminals((Mogram)this.model);
    }

    private void resolveTerminals(Mogram mogram) {
        for (Mogram component : mogram.components()) {
            if (component instanceof MogramReference) continue;
            if (component.isTerminal()) {
                this.propagateTerminalToInside(component);
                continue;
            }
            if (CompilerConfiguration.Level.MetaModel.compareLevelWith(this.level) > 0) {
                this.resolveTerminals(component);
                continue;
            }
            if (!this.level.equals((Object)CompilerConfiguration.Level.MetaModel)) continue;
            component.addFlags(new Tag[]{Tag.Terminal});
            this.propagateTerminalToInside(component);
        }
    }

    private void propagateTerminalToInside(Mogram mogram) {
        for (Mogram component : mogram.components()) {
            if (component instanceof MogramReference) continue;
            if (!component.isTerminal()) {
                component.addFlags(new Tag[]{Tag.Terminal});
            }
            this.propagateTerminalToInside(component);
        }
        this.propagateTerminalToVariables(mogram);
    }

    private void propagateTerminalToVariables(Mogram mogram) {
        mogram.variables().stream().filter(variable -> !variable.isTerminal()).forEach(variable -> variable.addFlags(new Tag[]{Tag.Terminal}));
    }
}

