/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.shared;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public interface Configuration {
    default public Configuration init() {
        return null;
    }

    default public boolean isSuitable() {
        return false;
    }

    default public void reload() {
    }

    public String groupId();

    public String artifactId();

    public String version();

    public void version(String var1);

    public String workingPackage();

    public String nativeLanguage();

    public Level level();

    public List<? extends LanguageLibrary> languages();

    default public LanguageLibrary language(Predicate<LanguageLibrary> predicate) {
        return this.languages().stream().filter(predicate).findFirst().orElse(null);
    }

    public String outDSL();

    public String interfaceVersion();

    default public List<String> repositories() {
        return Collections.emptyList();
    }

    default public Map<String, String> releaseRepositories() {
        return Collections.emptyMap();
    }

    default public String snapshotRepository() {
        return "";
    }

    default public AbstractMap.SimpleEntry<String, String> distributionLanguageRepository() {
        return new AbstractMap.SimpleEntry<String, String>("", "");
    }

    default public AbstractMap.SimpleEntry<String, String> distributionReleaseRepository() {
        return new AbstractMap.SimpleEntry<String, String>("", "");
    }

    default public AbstractMap.SimpleEntry<String, String> distributionSnapshotRepository() {
        return new AbstractMap.SimpleEntry<String, String>("", "");
    }

    default public String languageRepository() {
        return "";
    }

    default public String languageRepositoryId() {
        return "";
    }

    default public List<RunConfiguration> preConfigurations() {
        return Collections.emptyList();
    }

    default public List<RunConfiguration> deployConfigurations() {
        return Collections.emptyList();
    }

    public static interface RunConfiguration {
        public String name();

        public List<Parameter> parameters();

        public List<Service> services();

        public String store();

        public static interface Service {
            public String name();

            public List<Parameter> parameters();
        }

        public static interface Parameter {
            public String name();

            public String type();

            public String value();
        }
    }

    public static interface LanguageLibrary {
        public String name();

        public String version();

        public String effectiveVersion();

        public void version(String var1);

        public String generationPackage();
    }

    public static enum Level {
        System,
        Application,
        Platform;


        public int compareLevelWith(Level type) {
            return type.ordinal() - this.ordinal();
        }

        public boolean is(Level type, int level) {
            return type.ordinal() == level;
        }
    }
}

