/*
 * Decompiled with CFR 0.152.
 */
package io.intino.master.builder.operations.codegeneration;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.magritte.builder.core.CompilerConfiguration;
import io.intino.magritte.builder.utils.Format;
import io.intino.magritte.lang.model.Aspect;
import io.intino.magritte.lang.model.Node;
import io.intino.magritte.lang.model.Parameter;
import io.intino.magritte.lang.model.Tag;
import java.util.HashMap;
import java.util.Map;

public class StructFrameCreator {
    private static final String DOT = ".";
    private static final Map<String, String> types = Map.of("String", "String", "Double", "double", "Integer", "int", "Boolean", "boolean", "Entity", "io.intino.master.model.Entity", "Long", "long");
    private static final Map<String, String> listTypes = Map.of("String", "List<String>", "Double", "List<Double>", "Integer", "List<Integer>", "Boolean", "List<Boolean", "Entity", "List<io.intino.master.model.Entity>", "Long", "List<Long>");
    private final CompilerConfiguration conf;

    public StructFrameCreator(CompilerConfiguration conf) {
        this.conf = conf;
    }

    public Map<String, Frame> create(Node node) {
        HashMap<String, Frame> map = new HashMap<String, Frame>(4);
        map.put(this.calculateStructPath(node, this.conf.workingPackage()), this.frameOf(node).toFrame());
        return map;
    }

    private FrameBuilder frameOf(Node node) {
        FrameBuilder builder = new FrameBuilder(new String[]{"struct", "class"}).add("package", (Object)this.conf.workingPackage()).add("name", (Object)node.name()).add("attribute", (Object)node.components().stream().map(this::attrFrameOf).toArray());
        if (node.is(Tag.Decorable)) {
            builder.add("abstract", (Object)"abstract");
        }
        return builder;
    }

    private Frame attrFrameOf(Node c) {
        Parameter entity;
        Parameter defaultValue;
        FrameBuilder builder = new FrameBuilder().add("attribute");
        c.appliedAspects().forEach(aspect -> builder.add(aspect.type()));
        String type = this.type(c);
        builder.add("name", (Object)c.name()).add("owner", (Object)c.container().name()).add("type", (Object)type);
        Parameter values = this.parameter(c, "values");
        if (values != null) {
            builder.add("value", (Object)values.values().stream().map(Object::toString).toArray());
        }
        if ((defaultValue = this.parameter(c, "defaultValue")) != null) {
            builder.add("defaultValue", (Object)this.defaultValue(c, type, defaultValue));
        }
        if ((entity = this.parameter(c, "entity")) != null) {
            builder.add("entity", (Object)((Node)entity.values().get(0)).name());
        }
        return builder.toFrame();
    }

    private Frame defaultValue(Node c, String type, Parameter defaultValue) {
        FrameBuilder builder = new FrameBuilder((String[])c.appliedAspects().stream().map(Aspect::type).toArray(String[]::new));
        return builder.add("type", (Object)type).add("value", (Object)defaultValue.values().get(0).toString()).toFrame();
    }

    private String type(Node node) {
        String aspect = node.appliedAspects().stream().map(Aspect::type).filter(a -> !a.equals("List")).findFirst().orElse("");
        boolean list = node.appliedAspects().stream().anyMatch(a -> a.type().equals("List"));
        if (!list) {
            return types.getOrDefault(aspect, Format.firstUpperCase().format((Object)node.name()).toString());
        }
        return listTypes.getOrDefault(aspect, "List<" + Format.firstUpperCase().format((Object)node.name()).toString() + ">");
    }

    private Parameter parameter(Node c, String name) {
        return c.parameters().stream().filter(p -> p.name().equals(name)).findFirst().orElse(null);
    }

    private String calculateStructPath(Node node, String aPackage) {
        return aPackage + ".structs." + Format.firstUpperCase().format((Object)Format.javaValidName().format((Object)node.name()).toString());
    }
}

