/*
 * Decompiled with CFR 0.152.
 */
package io.intino.master.builder.operations.codegeneration;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class MasterClientTemplate
extends Template {
    public RuleSet ruleSet() {
        return new RuleSet().add(new Rule[]{this.rule().condition(this.allTypes(new String[]{"master", "interface"}), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(";\n\nimport java.util.List;\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.*;\n\npublic interface Master {\n\t")}).output(new Rule.Output[]{this.mark("entity", new String[]{"getterSignature"}).multiple("\n\n")}).output(new Rule.Output[]{this.literal("\n}")}), this.rule().condition(this.type("master"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(";\n\nimport com.hazelcast.client.HazelcastClient;\nimport com.hazelcast.client.config.ClientConfig;\nimport com.hazelcast.core.EntryEvent;\nimport com.hazelcast.core.HazelcastInstance;\nimport com.hazelcast.map.IMap;\nimport com.hazelcast.map.listener.EntryAddedListener;\nimport com.hazelcast.map.listener.EntryEvictedListener;\nimport com.hazelcast.map.listener.EntryRemovedListener;\nimport com.hazelcast.map.listener.EntryUpdatedListener;\nimport io.intino.master.model.Triple;\n\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.*;\n\nimport java.util.ArrayList;\nimport java.util.HashMap;\nimport java.util.List;\nimport java.util.Map;\nimport java.util.function.BiConsumer;\nimport java.util.function.Consumer;\n\nimport java.util.logging.ConsoleHandler;\nimport java.util.logging.Handler;\nimport java.util.logging.Level;\nimport java.util.logging.LogManager;\n\nimport static io.intino.master.model.Triple.SEPARATOR;\n\npublic class MasterClient implements Master {\n\tprivate static BiConsumer<String, Triple> publisher;\n\tprivate final Map<String, Consumer<Triple>> removers = new HashMap<>() {{\n\t\t")}).output(new Rule.Output[]{this.mark("entity", new String[]{"remover"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\t}};\n\tprivate final Map<String, Consumer<Triple>> adders = new HashMap<>() {{\n\t\t")}).output(new Rule.Output[]{this.mark("entity", new String[]{"adder"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\t}};\n\t")}).output(new Rule.Output[]{this.mark("entity", new String[]{"map"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\tprivate final IMap<String, String> reverseSubjectFactors;\n\tprivate final IMap<String, String> reversePredicateFactors;\n\tprivate HazelcastInstance hz;\n\n\tpublic static MasterClient connect(String url) {\n\t\tClientConfig cfg = new ClientConfig();\n\t\tcfg.getNetworkConfig().addAddress(url);\n\t\treturn new MasterClient(cfg);\n\t}\n\n\tpublic MasterClient() {\n\t\tthis(new ClientConfig());\n\t}\n\n\tpublic MasterClient(ClientConfig config) {\n\t\tconfigureLogger();\n\t\tthis.hz = HazelcastClient.newHazelcastClient(config);\n\t\treverseSubjectFactors = hz.getMap(\"reverseSubjectFactors\");\n\t\treversePredicateFactors = hz.getMap(\"reversePredicateFactors\");\n\t\tIMap<String, String> master = hz.getMap(\"master\");\n\t\tmaster.forEach((key, value) -> {\n\t\t\tfinal String[] subjectVerb = key.split(SEPARATOR);\n\t\t\tadd(new Triple(reverseSubjectFactors.get(subjectVerb[0]).toString(), reversePredicateFactors.get(subjectVerb[1]), value));\n\t\t});\n\t\tmaster.addEntryListener(new TripleEntryDispatcher(), true);\n\t\tpublisher = (publisher, triple) -> hz.getTopic(\"requests\").publish(publisher + \"##\" + triple.toString());\n\t}\n\n\t")}).output(new Rule.Output[]{this.mark("entity", new String[]{"getter"}).multiple("\n\n")}).output(new Rule.Output[]{this.literal("\n\n\tpublic void stop() {\n\t\thz.shutdown();\n\t}\n\n\tpublic void publish(String publisher, Triple triple) {\n\t\tif (this.publisher != null) this.publisher.accept(publisher, triple);\n\t}\n\n\tprivate void add(Triple triple) {\n\t\tadders.getOrDefault(typeOf(triple), t -> {}).accept(triple);\n\t}\n\n\tprivate void remove(Triple triple) {\n\t\tremovers.getOrDefault(typeOf(triple), t -> {}).accept(triple);\n\t}\n\n\t")}).output(new Rule.Output[]{this.mark("entity", new String[]{"add"}).multiple("\n\n")}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.mark("entity", new String[]{"remove"}).multiple("\n\n")}).output(new Rule.Output[]{this.literal("\n\n\tprivate String typeOf(Triple triple) {\n\t\treturn triple.subject().split(\":\")[1].toLowerCase();\n\t}\n\n\tprivate static void configureLogger() {\n\t\tjava.util.logging.Logger rootLogger = LogManager.getLogManager().getLogger(\"\");\n\t\trootLogger.setLevel(Level.WARNING);\n\t\tfor (Handler h : rootLogger.getHandlers()) rootLogger.removeHandler(h);\n\t\tfinal ConsoleHandler handler = new ConsoleHandler();\n\t\thandler.setLevel(Level.WARNING);\n\t\thandler.setFormatter(new io.intino.alexandria.logger.Formatter());\n\t\trootLogger.setUseParentHandlers(false);\n\t\trootLogger.addHandler(handler);\n\t}\n\n\tpublic class TripleEntryDispatcher implements EntryAddedListener<String, String>, EntryUpdatedListener<String, String>, EntryRemovedListener<String, String>, EntryEvictedListener<String, String> {\n\n\t\t@Override\n\t\tpublic void entryAdded(EntryEvent<String, String> event) {\n\t\t\tadd(triple(event));\n\t\t}\n\n\t\t@Override\n\t\tpublic void entryUpdated(EntryEvent<String, String> event) {\n\t\t\tadd(triple(event));\n\t\t}\n\n\t\t@Override\n\t\tpublic void entryRemoved(EntryEvent<String, String> event) {\n\t\t\tremove(triple(event));\n\t\t}\n\n\t\t@Override\n\t\tpublic void entryEvicted(EntryEvent<String, String> event) {\n\t\t\tremove(triple(event));\n\t\t}\n\n\t\tprivate Triple triple(EntryEvent<String, String> event) {\n\t\t\tfinal String[] subjectVerb = event.getKey().split(SEPARATOR);\n\t\t\treturn new Triple(reverseSubjectFactors.get(subjectVerb[0]).toString(), reversePredicateFactors.get(subjectVerb[1]), event.getValue());\n\t\t}\n\t}\n}")}), this.rule().condition(this.not(this.type("abstract")), new Rule.Condition[]{this.trigger("remover")}).output(new Rule.Output[]{this.literal("put(\"")}).output(new Rule.Output[]{this.mark("name", new String[]{"lowerCase"})}).output(new Rule.Output[]{this.literal("\", MasterClient.this::removeFrom")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(");")}), this.rule().condition(this.not(this.type("abstract")), new Rule.Condition[]{this.trigger("adder")}).output(new Rule.Output[]{this.literal("put(\"")}).output(new Rule.Output[]{this.mark("name", new String[]{"lowerCase"})}).output(new Rule.Output[]{this.literal("\", MasterClient.this::addTo")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(");")}), this.rule().condition(this.trigger("map"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("private final Map<String, ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstLowerCase"})}).output(new Rule.Output[]{this.literal("Map = new HashMap<>();")}), this.rule().condition(this.not(this.type("abstract")), new Rule.Condition[]{this.trigger("add")}).output(new Rule.Output[]{this.literal("private void addTo")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("(Triple triple) {\n\tif (!")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Map.containsKey(triple.subject())) ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Map.put(triple.subject(), new ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("(triple.subject(), this));\n\t")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Map.get(triple.subject()).add(triple);\n}")}), this.rule().condition(this.not(this.type("abstract")), new Rule.Condition[]{this.trigger("remove")}).output(new Rule.Output[]{this.literal("private void removeFrom")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("(Triple triple) {\n\t")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Map.computeIfPresent(triple.subject(), (k, v) -> v.remove(triple));\n}")}), this.rule().condition(this.trigger("getter"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("public ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("(String id) {\n\treturn ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Map.get(id);\n}\n\npublic List<")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"Plural", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn new ArrayList<>(")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Map.values());\n}")}), this.rule().condition(this.trigger("gettersignature"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("public ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("(String id);\n\npublic List<")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"Plural", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("();")})});
    }
}

