/*
 * Decompiled with CFR 0.152.
 */
package io.intino.master.builder.operations.codegeneration;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.magritte.builder.core.CompilerConfiguration;
import io.intino.magritte.builder.utils.Format;
import io.intino.magritte.lang.model.Aspect;
import io.intino.magritte.lang.model.Node;
import io.intino.magritte.lang.model.Parameter;
import io.intino.magritte.lang.model.Tag;
import java.util.HashMap;
import java.util.Map;

public class EntityFrameCreator {
    private static final String DOT = ".";
    private static final Map<String, String> types = Map.of("String", "String", "Double", "double", "Integer", "int", "Boolean", "boolean", "Entity", "io.intino.master.model.Entity", "Long", "long");
    private static final Map<String, String> listTypes = Map.of("String", "List<String>", "Double", "List<Double>", "Integer", "List<Integer>", "Boolean", "List<Boolean", "Entity", "List<io.intino.master.model.Entity>", "Long", "List<Long>");
    private final CompilerConfiguration conf;

    public EntityFrameCreator(CompilerConfiguration conf) {
        this.conf = conf;
    }

    public Map<String, Frame> create(Node node) {
        HashMap<String, Frame> map = new HashMap<String, Frame>(4);
        map.put(this.calculateEntityPath(node, this.conf.workingPackage()), this.frameOf(node).toFrame());
        if (node.is(Tag.Decorable)) {
            map.put(this.calculateDecorableEntityPath(node, this.conf.workingPackage()), this.frameOf(node).add("decorable").toFrame());
        }
        return map;
    }

    private FrameBuilder frameOf(Node node) {
        FrameBuilder builder = new FrameBuilder(new String[]{"entity", "class"}).add("package", (Object)this.conf.workingPackage()).add("name", (Object)node.name()).add("attribute", (Object)node.components().stream().map(this::attrFrameOf).toArray());
        Parameter parent = this.parameter(node, "entity");
        builder.add("parent", (Object)(parent != null ? ((Node)parent.values().get(0)).name() : "io.intino.master.model.Entity"));
        if (node.is(Tag.Decorable) || node.isAbstract()) {
            builder.add("isAbstract", (Object)"abstract");
        }
        if (node.is(Tag.Decorable)) {
            builder.add("abstract", (Object)"abstract");
        }
        return builder;
    }

    private Frame attrFrameOf(Node node) {
        Parameter struct;
        Parameter entity;
        Parameter defaultValue;
        FrameBuilder builder = new FrameBuilder().add("attribute");
        node.appliedAspects().forEach(aspect -> builder.add(aspect.type()));
        String type = this.type(node);
        builder.add("name", (Object)node.name()).add("owner", (Object)node.container().name()).add("type", (Object)type).add("package", (Object)this.conf.workingPackage());
        builder.add("index", (Object)node.container().components().indexOf(node));
        Parameter values = this.parameter(node, "values");
        if (values != null) {
            builder.add("value", (Object)values.values().stream().map(Object::toString).toArray());
        }
        if ((defaultValue = this.parameter(node, "defaultValue")) != null) {
            builder.add("defaultValue", (Object)this.defaultValue(node, type, defaultValue));
        }
        if ((entity = this.parameter(node, "entity")) != null) {
            builder.add("entity", (Object)((Node)entity.values().get(0)).name());
        }
        if ((struct = this.parameter(node, "struct")) != null) {
            builder.add("struct", (Object)this.structFrame((Node)struct.values().get(0)));
        }
        return builder.toFrame();
    }

    private Frame structFrame(Node node) {
        return new FrameBuilder(new String[]{"struct"}).add("name", (Object)node.name()).add("package", (Object)this.conf.workingPackage()).add("attribute", (Object)node.components().stream().map(this::attrFrameOf).toArray()).toFrame();
    }

    private Frame defaultValue(Node c, String type, Parameter defaultValue) {
        FrameBuilder builder = new FrameBuilder((String[])c.appliedAspects().stream().map(Aspect::type).toArray(String[]::new));
        return builder.add("type", (Object)type).add("value", (Object)defaultValue.values().get(0).toString()).toFrame();
    }

    private String type(Node node) {
        String aspect = node.appliedAspects().stream().map(Aspect::type).filter(a -> !a.equals("List")).findFirst().orElse("");
        boolean list = node.appliedAspects().stream().anyMatch(a -> a.type().equals("List"));
        if (!list) {
            return types.getOrDefault(aspect, Format.firstUpperCase().format((Object)node.name()).toString());
        }
        return listTypes.getOrDefault(aspect, "List<" + Format.firstUpperCase().format((Object)node.name()).toString() + ">");
    }

    private Parameter parameter(Node c, String name) {
        return c.parameters().stream().filter(p -> p.name().equals(name)).findFirst().orElse(null);
    }

    private String calculateEntityPath(Node node, String aPackage) {
        return aPackage + ".entities." + (node.is(Tag.Decorable) ? "Abstract" : "") + Format.firstUpperCase().format((Object)Format.javaValidName().format((Object)node.name()).toString());
    }

    private String calculateDecorableEntityPath(Node node, String aPackage) {
        return aPackage + ".entities." + Format.firstUpperCase().format((Object)Format.javaValidName().format((Object)node.name()).toString());
    }
}

