/*
 * Decompiled with CFR 0.152.
 */
package io.intino.master.builder.operations;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.magritte.builder.core.CompilationUnit;
import io.intino.magritte.builder.core.CompilerConfiguration;
import io.intino.magritte.builder.core.errorcollection.CompilationFailedException;
import io.intino.magritte.builder.core.operation.model.ModelOperation;
import io.intino.magritte.builder.model.Model;
import io.intino.magritte.builder.model.NodeImpl;
import io.intino.magritte.builder.utils.Format;
import io.intino.magritte.lang.model.Node;
import io.intino.master.builder.operations.codegeneration.EntityFrameCreator;
import io.intino.master.builder.operations.codegeneration.EntityTemplate;
import io.intino.master.builder.operations.codegeneration.MasterClientTemplate;
import io.intino.master.builder.operations.codegeneration.StructFrameCreator;
import io.intino.master.builder.operations.codegeneration.StructTemplate;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class MasterNodeCodeGenerationOperation
extends ModelOperation {
    private static final String DOT = ".";
    private static final String JAVA = ".java";
    private static final Logger LOG = Logger.getGlobal();
    private final CompilerConfiguration conf;
    private final Map<String, List<String>> outMap = new LinkedHashMap<String, List<String>>();
    private final File srcFolder;
    private final File genFolder;
    private final Template entityTemplate;
    private final Template structTemplate;

    public MasterNodeCodeGenerationOperation(CompilationUnit unit) {
        super(unit);
        this.conf = unit.configuration();
        this.srcFolder = this.conf.sourceDirectories().isEmpty() ? null : (File)this.conf.sourceDirectories().get(0);
        this.genFolder = this.conf.getOutDirectory();
        this.entityTemplate = Format.customize((Template)new EntityTemplate());
        this.structTemplate = Format.customize((Template)new StructTemplate());
    }

    public void call(Model model) throws CompilationFailedException {
        try {
            if (this.conf.isVerbose()) {
                this.conf.out().println(this.prefix() + " Generating Entities...");
            }
            this.createEntities(model);
            this.createStructs(model);
            this.createMaster(model);
            this.compilationUnit.addOutputItems(this.outMap);
            this.compilationUnit.compilationDifferentialCache().saveCache(model.components().stream().map(c -> ((NodeImpl)c).getHashCode()).collect(Collectors.toList()));
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, "Error during java className generation: " + e.getMessage(), e);
            throw new CompilationFailedException(this.compilationUnit.getPhase(), this.compilationUnit, e);
        }
    }

    private void createEntities(Model model) {
        Map<String, Map<String, String>> outputs = this.createEntityClasses(model);
        this.fillOutMap(outputs);
        outputs.values().forEach(this::write);
    }

    private void createStructs(Model model) {
        Map<String, Map<String, String>> outputs = this.createStructClasses(model);
        this.fillOutMap(outputs);
        outputs.values().forEach(this::write);
    }

    private void createMaster(Model model) {
        Map<String, Map<String, String>> outputs = this.createMasterClass(model);
        this.fillOutMap(outputs);
        outputs.values().forEach(this::write);
    }

    private Map<String, Map<String, String>> createEntityClasses(Model model) {
        HashMap<String, Map<String, String>> outputs = new HashMap<String, Map<String, String>>();
        model.components().stream().filter(node -> node.type().equals("Entity") && ((NodeImpl)node).isDirty() && !((NodeImpl)node).isVirtual()).forEach(node -> this.renderEntityNode((Map<String, Map<String, String>>)outputs, (Node)node));
        return outputs;
    }

    private Map<String, Map<String, String>> createStructClasses(Model model) {
        HashMap<String, Map<String, String>> outputs = new HashMap<String, Map<String, String>>();
        model.components().stream().filter(node -> node.type().equals("Struct") && ((NodeImpl)node).isDirty() && !((NodeImpl)node).isVirtual()).forEach(node -> this.renderStructNode((Map<String, Map<String, String>>)outputs, (Node)node));
        return outputs;
    }

    private Map<String, Map<String, String>> createMasterClass(Model model) {
        FrameBuilder builder = new FrameBuilder(new String[]{"master"}).add("package", (Object)this.conf.workingPackage());
        builder.add("entity", (Object)model.components().stream().filter(c -> c.type().equals("Entity")).map(c -> {
            FrameBuilder b = new FrameBuilder(new String[]{"entity"}).add("name", (Object)c.name());
            if (c.isAbstract()) {
                b.add("abstract");
            }
            return b.toFrame();
        }).toArray());
        String qn = this.conf.workingPackage() + DOT + Format.firstUpperCase().format((Object)Format.javaValidName().format((Object)"MasterClient").toString());
        String iQn = this.conf.workingPackage() + DOT + Format.firstUpperCase().format((Object)Format.javaValidName().format((Object)"Master").toString());
        return Map.of(((Node)model.components().get(0)).file(), Map.of(this.destination(qn), Format.customize((Template)new MasterClientTemplate()).render((Object)builder.toFrame()), this.destination(iQn), Format.customize((Template)new MasterClientTemplate()).render((Object)builder.add("interface").toFrame())));
    }

    private void renderEntityNode(Map<String, Map<String, String>> map, Node node) {
        Map<String, Frame> frames = new EntityFrameCreator(this.conf).create(node);
        if (!map.containsKey(node.file())) {
            map.put(node.file(), new LinkedHashMap());
        }
        frames.forEach((path, frame) -> {
            String destination = this.entityDestination((String)path, (Frame)frame);
            ((Map)map.get(node.file())).put(destination, !this.isModified(node) && new File(destination).exists() ? "" : this.entityTemplate.render(frame));
        });
    }

    private void renderStructNode(Map<String, Map<String, String>> map, Node node) {
        Map<String, Frame> frames = new StructFrameCreator(this.conf).create(node);
        if (!map.containsKey(node.file())) {
            map.put(node.file(), new LinkedHashMap());
        }
        frames.forEach((path, frame) -> {
            String destination = this.destination((String)path);
            ((Map)map.get(node.file())).put(destination, !this.isModified(node) && new File(destination).exists() ? "" : this.structTemplate.render(frame));
        });
    }

    private void write(Map<String, String> outputsMap) {
        outputsMap.forEach((key, value) -> {
            File file = new File((String)key);
            if (value.isEmpty() || this.isUnderSource(file) && file.exists()) {
                return;
            }
            file.getParentFile().mkdirs();
            this.write(file, (String)value);
        });
    }

    private boolean isUnderSource(File file) {
        return file.getAbsolutePath().startsWith(this.srcFolder.getAbsolutePath());
    }

    private void write(File file, String text) {
        try {
            file.getParentFile().mkdirs();
            BufferedWriter fileWriter = new BufferedWriter(new FileWriter(file));
            fileWriter.write(text);
            fileWriter.close();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private boolean isModified(Node node) {
        return this.compilationUnit.compilationDifferentialCache().isModified((NodeImpl)node);
    }

    private String destination(String path) {
        return new File(this.genFolder, path.replace(DOT, File.separator) + JAVA).getAbsolutePath();
    }

    private String entityDestination(String path, Frame frame) {
        return new File(frame.is("decorable") && !frame.is("abstract") ? this.srcFolder : this.genFolder, path.replace(DOT, File.separator) + JAVA).getAbsolutePath();
    }

    private void fillOutMap(Map<String, Map<String, String>> map) {
        for (Map.Entry<String, Map<String, String>> entry : map.entrySet()) {
            for (String out : entry.getValue().keySet()) {
                if (this.isUnderSource(new File(out))) continue;
                this.put(entry.getKey(), out);
            }
        }
    }

    private void put(String key, String value) {
        if (!this.outMap.containsKey(key)) {
            this.outMap.put(key, new ArrayList());
        }
        this.outMap.get(key).add(value);
    }

    private String prefix() {
        return "@#$%@# Presentable:[" + this.conf.getModule() + " - " + this.conf.model().outDsl() + "]";
    }
}

