/*
 * Decompiled with CFR 0.152.
 */
package io.intino.master.builder;

import io.intino.magritte.builder.TaraCompilerRunner;
import io.intino.magritte.builder.core.errorcollection.TaraException;
import io.intino.master.builder.operations.MasterNodeCodeGenerationOperation;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MastercRunner {
    private static final Logger LOG = Logger.getGlobal();

    private MastercRunner() {
    }

    public static void main(String[] args) {
        boolean verbose;
        boolean bl = verbose = args.length != 2 || Boolean.parseBoolean(args[1]);
        if (verbose) {
            System.out.println("@#$%@# Presentable:Starting compiling");
        }
        try {
            File argsFile;
            if (MastercRunner.checkArgumentsNumber(args) || (argsFile = MastercRunner.checkConfigurationFile(args[0])) == null) {
                throw new TaraException("Error finding args file");
            }
            new TaraCompilerRunner(verbose, List.of(MasterNodeCodeGenerationOperation.class)).run(argsFile);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, e.getMessage() == null ? e.getStackTrace()[0].toString() : e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static File checkConfigurationFile(String arg) {
        File argsFile = new File(arg);
        if (!argsFile.exists()) {
            LOG.severe("%%mArguments file for Tara compiler not found/%m");
            return null;
        }
        return argsFile;
    }

    private static boolean checkArgumentsNumber(String[] args) {
        if (args.length < 1) {
            LOG.severe("%%mThere is no arguments for tara compiler/%m");
            return true;
        }
        return false;
    }
}

