/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.compiler.codegeneration.magritte.stash;

import io.intino.magritte.builder.compiler.codegeneration.magritte.NameFormatter;
import io.intino.tara.builder.utils.Format;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.Primitive;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class StashHelper {
    private static final String BLOB_KEY = "%";

    static List<String> collectTypes(Mogram mogram) {
        ArrayList<String> types = new ArrayList<String>();
        types.addAll(mogram.metaMograms().stream().map(NameFormatter::layerQualifiedName).toList());
        types.addAll(mogram.appliedFacets().stream().map(facet -> NameFormatter.layerQualifiedName((Mogram)facet.definition().get())).collect(Collectors.toCollection(LinkedHashSet::new)));
        return types.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public static String name(Mogram owner, String workingPackage) {
        return Format.withDollar().format(Format.noPackage().format((Object)NameFormatter.getQn(owner, workingPackage))).toString();
    }

    static boolean hasToBeConverted(List<Object> values, Primitive type) {
        if (values.getFirst() instanceof String && !type.equals((Object)Primitive.STRING) || type.equals((Object)Primitive.WORD)) {
            return true;
        }
        if (type.equals((Object)Primitive.INSTANT) || type.equals((Object)Primitive.RESOURCE)) {
            return true;
        }
        return type.equals((Object)Primitive.LONG) && values.getFirst() instanceof Integer;
    }

    static List<Object> buildResourceValue(List<Object> values, String filePath) {
        return values.stream().map(v -> BLOB_KEY + StashHelper.getPresentableName(new File(filePath).getName()) + v.toString()).collect(Collectors.toList());
    }

    private static String getPresentableName(String name) {
        return name.substring(0, name.lastIndexOf("."));
    }

    static String buildInstanceReference(Object o) {
        Object object;
        if (o instanceof Primitive.Reference) {
            Primitive.Reference reference = (Primitive.Reference)o;
            object = StashHelper.getPath(reference) + "#" + NameFormatter.layerQualifiedName((Mogram)reference.get().get());
        } else {
            object = "";
        }
        return object;
    }

    private static String getPath(Primitive.Reference reference) {
        String source = new File(((Mogram)reference.get().get()).source()).getName();
        return source.substring(0, source.lastIndexOf("."));
    }
}

