/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.compiler.codegeneration.magritte.natives;

import java.util.Arrays;

public class NativeExtractor {
    private final String returnType;
    private final String methodName;
    private final String parameters;
    private final String[] exceptions;

    public NativeExtractor(String methodSignature) {
        this.returnType = NativeExtractor.returnType(this.clean(methodSignature));
        this.methodName = this.methodName(this.clean(methodSignature));
        this.parameters = NativeExtractor.getParameters(this.clean(methodSignature));
        this.exceptions = this.exceptions(this.clean(methodSignature));
    }

    private String clean(String methodSignature) {
        return methodSignature.trim().replaceAll("\\s+", " ").replace(" (", "(");
    }

    private static String returnType(String methodSignature) {
        if (methodSignature == null || methodSignature.isEmpty()) {
            return "";
        }
        String returnValue = methodSignature.split(" (\\S)*\\(")[0];
        return returnValue.startsWith("public ") ? returnValue.replaceFirst("public ", "") : returnValue;
    }

    private String methodName(String methodSignature) {
        if (methodSignature == null || methodSignature.isEmpty()) {
            return "";
        }
        String[] substring = methodSignature.substring(0, methodSignature.indexOf("(")).split(" ");
        return substring[substring.length - 1];
    }

    private String[] exceptions(String signature) {
        String token = " throws ";
        if (signature == null || signature.isEmpty() || !signature.contains(" throws ")) {
            return new String[0];
        }
        String[] exceptions = signature.substring(signature.indexOf(" throws ") + " throws ".length()).split(",");
        return (String[])Arrays.stream(exceptions).map(String::trim).toArray(String[]::new);
    }

    private static String getParameters(String methodSignature) {
        if (methodSignature == null || methodSignature.isEmpty()) {
            return "";
        }
        return methodSignature.substring(methodSignature.indexOf("(") + 1, methodSignature.lastIndexOf(")"));
    }

    public String returnType() {
        return this.returnType;
    }

    public String methodName() {
        return this.methodName;
    }

    public String parameters() {
        return this.parameters;
    }

    public String[] exceptions() {
        return this.exceptions;
    }
}

