/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.compiler.codegeneration.magritte.layer;

import io.intino.builder.CompilerConfiguration;
import io.intino.itrules.Adapter;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.magritte.builder.compiler.codegeneration.magritte.TemplateTags;
import io.intino.magritte.builder.compiler.codegeneration.magritte.layer.MogramAdapter;
import io.intino.magritte.builder.compiler.codegeneration.magritte.layer.PropertyAdapter;
import io.intino.tara.Language;
import io.intino.tara.builder.utils.Format;
import io.intino.tara.model.Annotation;
import io.intino.tara.model.Level;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.MogramReference;
import io.intino.tara.model.MogramRoot;
import io.intino.tara.model.Property;
import io.intino.tara.processors.model.Model;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class LayerFrameCreator
implements TemplateTags {
    private final Map<Class<?>, Adapter> adapters;
    private final String outDsl;
    private final String workingPackage;
    private final MogramAdapter mogramAdapter;
    private final PropertyAdapter propertyAdapter;
    private Mogram initNode = null;

    private LayerFrameCreator(String outDsl, Language language, String workingPackage, String languageWorkingPackage) {
        this.outDsl = outDsl;
        this.workingPackage = workingPackage;
        this.adapters = new HashMap();
        this.propertyAdapter = new PropertyAdapter(language, outDsl, workingPackage, languageWorkingPackage);
        this.adapters.put(Property.class, this.propertyAdapter);
        this.mogramAdapter = new MogramAdapter(outDsl, language, null, workingPackage, languageWorkingPackage);
        this.adapters.put(Mogram.class, this.mogramAdapter);
    }

    public LayerFrameCreator(CompilerConfiguration conf, Language language) {
        this(conf.dsl().outDsl(), language, conf.generationPackage(), conf.dsl().generationPackage());
    }

    public Map.Entry<String, Frame> create(Mogram mogram) {
        this.initNode = mogram;
        this.mogramAdapter.getImports().clear();
        this.propertyAdapter.getImports().clear();
        this.mogramAdapter.setInitNode(this.initNode);
        FrameBuilder builder = new FrameBuilder(new String[]{"Layer"}).add("generatedLanguage", (Object)this.outDsl).add("workingPackage", (Object)this.workingPackage);
        this.addSlot(builder, mogram);
        this.addNodeImports(builder);
        return new AbstractMap.SimpleEntry<String, Frame>(this.calculateLayerPath(mogram, this.addWorkingPackage(builder)), builder.toFrame());
    }

    private void addSlot(FrameBuilder builder, Mogram mogram) {
        if (mogram instanceof MogramReference || mogram.level().equals((Object)Level.M1)) {
            return;
        }
        builder.add("node", (Object)new FrameBuilder().put(this.adapters).append((Object)mogram).toFrame());
    }

    public Map.Entry<String, Frame> createDecorable(Mogram mogram) {
        FrameBuilder builder = new FrameBuilder(new String[]{"Layer", "decorable"});
        String aPackage = this.addWorkingPackage(builder);
        builder.add("name", (Object)mogram.name());
        if (!(mogram.container() instanceof MogramRoot)) {
            builder.add("container", (Object)((Mogram)mogram.container()).qualifiedName());
        }
        if (mogram.is(Annotation.Generalization)) {
            builder.add("abstract", (Object)true);
        }
        builder.add("decorableNode", mogram.components().stream().filter(c -> !(c instanceof MogramReference)).map(this::createDecorableFrame).toArray(Frame[]::new));
        return new AbstractMap.SimpleEntry<String, Frame>(this.calculateDecorablePath(mogram, aPackage), builder.toFrame());
    }

    private Frame createDecorableFrame(Mogram mogram) {
        FrameBuilder builder = new FrameBuilder(new String[]{"decorableNode"}).add("name", (Object)mogram.name());
        if (mogram.is(Annotation.Generalization)) {
            builder.add("abstract", (Object)"abstract");
        }
        builder.add("decorableNode", mogram.components().stream().filter(c -> !(c instanceof MogramReference)).map(this::createDecorableFrame).toArray(Frame[]::new));
        return builder.toFrame();
    }

    private String calculateLayerPath(Mogram mogram, String aPackage) {
        return aPackage + "." + (mogram.is(Annotation.Decorable) ? "Abstract" : "") + String.valueOf(Format.firstUpperCase().format((Object)Format.javaValidName().format((Object)mogram.name()).toString()));
    }

    private String calculateDecorablePath(Mogram node, String aPackage) {
        return aPackage + (String)(node.container() instanceof Model ? "" : "." + ((Mogram)node.container()).qualifiedName().toLowerCase()) + "." + String.valueOf(Format.firstUpperCase().format((Object)Format.javaValidName().format((Object)node.name()).toString()));
    }

    private void addNodeImports(FrameBuilder builder) {
        HashSet<String> set = new HashSet<String>(this.mogramAdapter.getImports());
        set.addAll(this.propertyAdapter.getImports());
        if (!set.isEmpty()) {
            builder.add("imports", (Object)set.toArray(new Object[0]));
        }
    }

    private String addWorkingPackage(FrameBuilder builder) {
        String packagePath = this.workingPackage.toLowerCase();
        if (!packagePath.isEmpty()) {
            builder.add("package", (Object)packagePath);
        }
        return packagePath.endsWith(".") ? packagePath.substring(0, packagePath.length() - 1) : packagePath;
    }
}

