package io.intino.magritte.builder.compiler.codegeneration.magritte.layer.templates;

import io.intino.itrules.template.Rule;
import io.intino.itrules.template.Template;

import java.util.ArrayList;
import java.util.List;

import static io.intino.itrules.template.condition.predicates.Predicates.*;
import static io.intino.itrules.template.outputs.Outputs.*;

public class AbstractGraphTemplate extends Template {

	public List<Rule> ruleSet() {
		List<Rule> rules = new ArrayList<>();
		rules.add(rule().condition(allTypes("graph")).output(literal("package ")).output(placeholder("workingPackage", "LowerCase")).output(literal(";\n\nimport io.intino.magritte.framework.Graph;\n\npublic class AbstractGraph extends io.intino.magritte.framework.GraphWrapper {\n\tprotected io.intino.magritte.framework.Graph graph;\n\t")).output(placeholder("node", "declaration").multiple("\n")).output(literal("\n\n\tprivate java.util.Map<String, Indexer> _index = _fillIndex();\n\n\tpublic AbstractGraph(io.intino.magritte.framework.Graph graph) {\n\t\tthis.graph = graph;\n\t\tthis.graph.i18n().register(\"")).output(placeholder("name")).output(literal("\");\n\t}\n\n\tpublic AbstractGraph(io.intino.magritte.framework.Graph graph, AbstractGraph wrapper) {\n\t\tthis.graph = graph;\n\t\tthis.graph.i18n().register(\"")).output(placeholder("name")).output(literal("\");\n\t\t")).output(placeholder("node", "clone").multiple("\n")).output(literal("\n\t}\n\n\tpublic <T extends io.intino.magritte.framework.GraphWrapper> T a$(Class<T> t) {\n\t\treturn this.core$().as(t);\n\t}\n\n    @Override\n\tpublic void update() {\n\t\tthis._index.values().forEach(v -> v.clear());\n\t\tgraph.rootList().forEach(r -> addNode$(r));\n\t}\n\n\t@Override\n\tprotected void addNode$(io.intino.magritte.framework.Node node) {\n\t\tfor (io.intino.magritte.framework.Concept c : node.conceptList()) if (this._index.containsKey(c.id())) this._index.get(c.id()).add(node);\n\t\tif (this._index.containsKey(node.id())) this._index.get(node.id()).add(node);\n\t}\n\n\t@Override\n\tprotected void removeNode$(io.intino.magritte.framework.Node node) {\n\t\tfor (io.intino.magritte.framework.Concept c : node.conceptList()) if (this._index.containsKey(c.id())) this._index.get(c.id()).remove(node);\n\t\tif (this._index.containsKey(node.id())) this._index.get(node.id()).remove(node);\n\t}\n\n\tpublic java.net.URL resourceAsMessage$(String language, String key) {\n\t\treturn graph.loadResource(graph.i18n().message(language, key));\n\t}\n\n\t")).output(placeholder("node", "getter").multiple("\n\n")).output(literal("\n\n\t")).output(placeholder("node", "filter").multiple("\n\n")).output(literal("\n\n\tpublic io.intino.magritte.framework.Graph core$() {\n\t\treturn graph;\n\t}\n\n\tpublic io.intino.magritte.framework.utils.I18n i18n$() {\n\t\treturn graph.i18n();\n\t}\n\n\tpublic Create create() {\n\t\treturn new Create(\"Misc\", null);\n\t}\n\n\tpublic Create create(String stash) {\n\t\treturn new Create(stash, null);\n\t}\n\n\tpublic Create create(String stash, String name) {\n\t\treturn new Create(stash, name);\n\t}\n\n\tpublic Clear clear() {\n\t\treturn new Clear();\n\t}\n\n\tpublic class Create {\n\t\tprivate final String stash;\n\t\tprivate final String name;\n\n\t\tpublic Create(String stash, String name) {\n\t\t\tthis.stash = stash;\n\t\t\tthis.name = name;\n\t\t}\n\n\t\t")).output(expression().output(placeholder("node", "new").multiple("\n\n"))).output(literal("\n\t}\n\n\tpublic class Clear {\n\t    ")).output(expression().output(placeholder("node", "clear").multiple("\n\n"))).output(literal("\n\t}\n\n\n\tprivate java.util.HashMap<String, Indexer> _fillIndex() {\n\t\tjava.util.HashMap<String, Indexer> map = new java.util.HashMap<>();\n\t\t")).output(expression().output(placeholder("node", "put").multiple("\n"))).output(literal("\n\t\treturn map;\n\t}\n\n\tpublic static io.intino.magritte.io.model.Stash[] _language() {\n\t\treturn new io.intino.magritte.io.model.Stash[]{")).output(expression().output(placeholder("parentPackage")).output(literal(".AbstractGraph._language()[0], "))).output(literal("stash()};\n\t}\n\n\tprivate static io.intino.magritte.io.model.Stash stash() {\n\t\tString content = ")).output(placeholder("stash", "call")).output(literal(";\n\t\treturn io.intino.magritte.io.StashDeserializer.stashFrom(java.util.Base64.getDecoder().decode(content));\n\t}\n\n\t")).output(placeholder("stash", "stashMethod")).output(literal("\n\n\tpublic static class Indexer {\n\t\tAdd add;\n\t\tRemove remove;\n\t\tIndexClear clear;\n\n\t\tpublic Indexer(Add add, Remove remove, IndexClear clear) {\n\t\t\tthis.add = add;\n\t\t\tthis.remove = remove;\n\t\t\tthis.clear = clear;\n\t\t}\n\n\t\tvoid add(io.intino.magritte.framework.Node node) {\n\t\t\tthis.add.add(node);\n\t\t}\n\n\t\tvoid remove(io.intino.magritte.framework.Node node) {\n\t\t\tthis.remove.remove(node);\n\t\t}\n\n\t\tvoid clear() {\n\t\t\tthis.clear.clear();\n\t\t}\n\t}\n\n\tinterface Add {\n\t\tvoid add(io.intino.magritte.framework.Node node);\n\t}\n\n\tinterface Remove {\n\t\tvoid remove(io.intino.magritte.framework.Node node);\n\t}\n\n\tinterface IndexClear {\n\t\tvoid clear();\n\t}\n}")));
		rules.add(rule().condition(all(allTypes("stash"), trigger("call"))).output(placeholder("part", "methodCall").multiple(" + ")));
		rules.add(rule().condition(trigger("methodcall")).output(literal("stash")).output(placeholder("index")).output(literal("()")));
		rules.add(rule().condition(all(allTypes("stash"), trigger("stashmethod"))).output(placeholder("part", "method").multiple("\n\n")));
		rules.add(rule().condition(trigger("method")).output(literal("private static String stash")).output(placeholder("index")).output(literal("() {\n\treturn \"")).output(placeholder("code")).output(literal("\";\n}")));
		rules.add(rule().condition(all(allTypes("instance"), trigger("put"))).output(literal("map.put(\"")).output(placeholder("generatedLanguage", "FirstUpperCase")).output(literal("#")).output(placeholder("name")).output(literal("\", new Indexer(node -> ")).output(placeholder("name", "FirstLowerCase", "javaValidWord")).output(literal(" = node.as(")).output(placeholder("conceptLayer", "reference")).output(literal(".class), node -> ")).output(placeholder("name", "FirstLowerCase", "javaValidWord")).output(literal(" = null, () -> ")).output(placeholder("name", "FirstLowerCase", "javaValidWord")).output(literal(" = null));")));
		rules.add(rule().condition(all(all(not(allTypes("instance")), allTypes("single")), trigger("put"))).output(literal("map.put(\"")).output(placeholder("stashQn", "noPackage", "withDollar")).output(literal("\", new Indexer(node -> ")).output(placeholder("name", "FirstLowerCase", "javaValidWord")).output(literal(" = node.as(")).output(placeholder("qn", "reference")).output(literal(".class), node -> ")).output(placeholder("name", "FirstLowerCase", "javaValidWord")).output(literal(" = null, () -> ")).output(placeholder("name", "FirstLowerCase", "javaValidWord")).output(literal(" = null));")));
		rules.add(rule().condition(all(not(allTypes("instance")), trigger("put"))).output(literal("map.put(\"")).output(placeholder("stashQn", "noPackage", "withDollar")).output(literal("\", new Indexer(node -> ")).output(placeholder("name", "FirstLowerCase")).output(literal("List.add(node.as(")).output(placeholder("qn", "reference")).output(literal(".class)), node -> ")).output(placeholder("name", "FirstLowerCase")).output(literal("List.remove(node.as(")).output(placeholder("qn", "reference")).output(literal(".class)), () -> ")).output(placeholder("name", "FirstLowerCase")).output(literal("List.clear()));")));
		rules.add(rule().condition(trigger("add")));
		rules.add(rule().condition(all(allTypes("node", "instance"), trigger("declaration"))).output(literal("private ")).output(placeholder("conceptLayer")).output(literal(" ")).output(placeholder("name", "FirstLowerCase", "javaValidWord")).output(literal(";")));
		rules.add(rule().condition(all(allTypes("node", "single"), trigger("declaration"))).output(literal("private ")).output(placeholder("qn", "reference")).output(literal(" ")).output(placeholder("name", "FirstLowerCase", "javaValidWord")).output(literal(";")));
		rules.add(rule().condition(all(allTypes("node"), trigger("declaration"))).output(literal("private java.util.List<")).output(placeholder("qn", "reference")).output(literal("> ")).output(placeholder("name", "FirstLowerCase")).output(literal("List = new java.util.ArrayList<>();")));
		rules.add(rule().condition(all(allTypes("node", "instance"), trigger("update"))).output(literal("io.intino.magritte.framework.Node ")).output(placeholder("name", "FirstLowerCase", "javaValidWord")).output(literal("Node = this.graph.load(\"")).output(placeholder("generatedLanguage", "FirstUpperCase")).output(literal("#")).output(placeholder("name")).output(literal("\");\nif (")).output(placeholder("name", "FirstLowerCase", "javaValidWord")).output(literal("Node != null) this.")).output(placeholder("name", "FirstLowerCase", "javaValidWord")).output(literal(" = ")).output(placeholder("name", "FirstLowerCase", "javaValidWord")).output(literal("Node.as(")).output(placeholder("conceptLayer")).output(literal(".class);")));
		rules.add(rule().condition(all(allTypes("node", "single"), trigger("update"))).output(placeholder("name", "FirstLowerCase")).output(literal(" = this.graph.rootList(")).output(placeholder("qn", "reference")).output(literal(".class).stream().findFirst().orElse(null);")));
		rules.add(rule().condition(all(allTypes("node"), trigger("update"))).output(placeholder("name", "FirstLowerCase")).output(literal("List = this.graph.rootList(")).output(placeholder("qn", "reference")).output(literal(".class);")));
		rules.add(rule().condition(all(all(allTypes("node"), any(allTypes("instance"), allTypes("single"))), trigger("clone"))).output(literal("this.")).output(placeholder("name", "FirstLowerCase", "javaValidWord")).output(literal(" = wrapper.")).output(placeholder("name", "FirstLowerCase", "javaValidWord")).output(literal(";")));
		rules.add(rule().condition(all(allTypes("node"), trigger("clone"))).output(literal("this.")).output(placeholder("name", "FirstLowerCase")).output(literal("List = new java.util.ArrayList<>(wrapper.")).output(placeholder("name", "FirstLowerCase")).output(literal("List);")));
		rules.add(rule().condition(all(allTypes("node", "instance"), trigger("getter"))).output(literal("public ")).output(placeholder("conceptLayer")).output(literal(" ")).output(placeholder("name", "FirstLowerCase", "javaValidWord")).output(literal("() {\n\treturn ")).output(placeholder("name", "FirstLowerCase", "javaValidWord")).output(literal(";\n}")));
		rules.add(rule().condition(all(allTypes("node", "single"), trigger("getter"))).output(literal("public ")).output(placeholder("qn", "reference")).output(literal(" ")).output(placeholder("name", "FirstLowerCase", "javaValidWord")).output(literal("() {\n\treturn ")).output(placeholder("name", "FirstLowerCase", "javaValidWord")).output(literal(";\n}")));
		rules.add(rule().condition(all(allTypes("node"), trigger("getter"))).output(literal("public java.util.List<")).output(placeholder("qn", "reference")).output(literal("> ")).output(placeholder("name", "FirstLowerCase")).output(literal("List() {\n\treturn ")).output(placeholder("name", "FirstLowerCase")).output(literal("List;\n}")));
		rules.add(rule().condition(all(all(allTypes("node"), not(any(allTypes("single"), allTypes("instance")))), trigger("filter"))).output(literal("public java.util.stream.Stream<")).output(placeholder("qn", "reference")).output(literal("> ")).output(placeholder("name", "FirstLowerCase")).output(literal("List(java.util.function.Predicate<")).output(placeholder("qn", "reference")).output(literal("> filter) {\n\treturn ")).output(placeholder("name", "FirstLowerCase")).output(literal("List.stream().filter(filter);\n}\n\npublic ")).output(placeholder("qn", "reference")).output(literal(" ")).output(placeholder("name", "FirstLowerCase", "javaValidWord")).output(literal("(int index) {\n\treturn ")).output(placeholder("name", "FirstLowerCase")).output(literal("List.get(index);\n}")));
		rules.add(rule().condition(all(all(allTypes("node", "concept"), not(any(any(any(allTypes("final"), allTypes("abstract")), allTypes("component")), allTypes("instance")))), trigger("new"))).output(literal("public ")).output(placeholder("qn", "reference")).output(literal(" ")).output(placeholder("name", "FirstLowerCase", "javaValidWord")).output(literal("(")).output(expression().output(placeholder("variable", "parameters").multiple(", "))).output(literal(") {\n\t")).output(placeholder("qn", "reference")).output(literal(" newElement = AbstractGraph.this.graph.createRoot(")).output(placeholder("qn", "reference")).output(literal(".class, stash, this.name).a$(")).output(placeholder("qn", "reference")).output(literal(".class);\n\t")).output(expression().output(placeholder("variable", "assign").multiple("\n"))).output(literal("\n\treturn newElement;\n}")));
		rules.add(rule().condition(all(all(allTypes("node", "concept"), not(any(any(any(any(allTypes("single"), allTypes("final")), allTypes("abstract")), allTypes("component")), allTypes("instance")))), trigger("clear"))).output(literal("public void ")).output(placeholder("name", "FirstLowerCase", "javaValidWord")).output(literal("(java.util.function.Predicate<")).output(placeholder("qn", "reference")).output(literal("> filter) {\n\tnew java.util.ArrayList<>(AbstractGraph.this.")).output(placeholder("name", "FirstLowerCase", "javaValidWord")).output(literal("List()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);\n}")));
		rules.add(rule().condition(trigger("quoted")).output(literal("\"")).output(placeholder("")).output(literal("\"")));
		return rules;
	}

	public String render(Object object) {
		return new io.intino.itrules.Engine(this).render(object);
	}

	public String render(Object object, java.util.Map<String, io.intino.itrules.Formatter> formatters) {
		return new io.intino.itrules.Engine(this).addAll(formatters).render(object);
	}
}