/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.compiler.codegeneration.magritte;

import io.intino.tara.builder.utils.Format;
import io.intino.tara.model.ElementContainer;
import io.intino.tara.model.Facet;
import io.intino.tara.model.Level;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.MogramReference;
import io.intino.tara.processors.model.Model;
import io.intino.tara.processors.model.MogramImpl;
import java.util.UUID;

public class NameFormatter {
    public static final char DOT = '.';

    private NameFormatter() {
    }

    public static String getQn(Mogram mogram, String workingPackage) {
        return workingPackage.toLowerCase() + "." + Format.qualifiedName().format((Object)NameFormatter.layerQn(mogram)).toString();
    }

    public static String layerQn(Mogram mogram) {
        String string;
        if (mogram instanceof MogramReference) {
            MogramReference r = (MogramReference)mogram;
            string = NameFormatter.layerQualifiedName(r);
        } else {
            string = NameFormatter.layerQualifiedName(mogram);
        }
        return string;
    }

    private static String layerQualifiedName(MogramReference r) {
        return null;
    }

    public static String layerQualifiedName(Mogram mogram) {
        ElementContainer container = mogram.container();
        String containerQn = container instanceof Model ? "" : NameFormatter.layerQualifiedName((Mogram)((MogramImpl)container));
        String name = mogram.level().equals((Object)Level.M1) || mogram.isAnonymous() ? mogram.name() : Format.firstUpperCase().format((Object)mogram.name()).toString();
        return (String)(containerQn.isEmpty() ? "" : containerQn + "$") + (name == null ? NameFormatter.newUUID(mogram) : name);
    }

    public static String newUUID(Mogram mogram) {
        String uid = UUID.randomUUID().toString();
        return mogram.level().equals((Object)Level.M1) ? uid : Format.firstUpperCase().format((Object)uid).toString();
    }

    public static String getQn(Facet facet, String workingPackage) {
        return workingPackage.toLowerCase() + "." + String.valueOf(Format.javaValidName().format((Object)facet.type()));
    }

    public static String cleanQn(String qualifiedName) {
        return qualifiedName.replace("anonymous@", "").replace("[", "").replace("]", "").replace(":", "").replace("$", ".");
    }
}

