/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.compiler.codegeneration.magritte.layer;

import io.intino.itrules.Adapter;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.magritte.builder.compiler.codegeneration.magritte.TemplateTags;
import io.intino.magritte.builder.compiler.codegeneration.magritte.layer.LayerVariableAdapter;
import io.intino.magritte.builder.compiler.codegeneration.magritte.layer.MogramAdapter;
import io.intino.tara.Language;
import io.intino.tara.builder.core.CompilerConfiguration;
import io.intino.tara.builder.model.Model;
import io.intino.tara.builder.model.MogramReference;
import io.intino.tara.builder.utils.Format;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.MogramRoot;
import io.intino.tara.language.model.Tag;
import io.intino.tara.language.model.Variable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;

public class LayerFrameCreator
implements TemplateTags {
    private final Map<Class, Adapter> adapters;
    private final String outDsl;
    private final String workingPackage;
    private final MogramAdapter mogramAdapter;
    private final LayerVariableAdapter variableAdapter;
    private Mogram initNode = null;

    private LayerFrameCreator(String outDsl, Language language, CompilerConfiguration.Level modelLevel, String workingPackage, String languageWorkingPackage) {
        this.outDsl = outDsl;
        this.workingPackage = workingPackage;
        this.adapters = new HashMap<Class, Adapter>();
        this.variableAdapter = new LayerVariableAdapter(language, outDsl, modelLevel, workingPackage, languageWorkingPackage);
        this.adapters.put(Variable.class, this.variableAdapter);
        this.mogramAdapter = new MogramAdapter(outDsl, modelLevel, language, null, workingPackage, languageWorkingPackage);
        this.adapters.put(Mogram.class, this.mogramAdapter);
    }

    public LayerFrameCreator(CompilerConfiguration conf, String language) {
        this(conf.model().outDsl(), conf.model().language().get(), conf.model().level(), conf.workingPackage(), conf.model().language().generationPackage());
    }

    public Map.Entry<String, Frame> create(Mogram node) {
        this.initNode = node;
        this.mogramAdapter.getImports().clear();
        this.variableAdapter.getImports().clear();
        this.mogramAdapter.setInitNode(this.initNode);
        FrameBuilder builder = new FrameBuilder(new String[]{"Layer"}).add("generatedLanguage", (Object)this.outDsl).add("workingPackage", (Object)this.workingPackage);
        this.addSlot(builder, node);
        this.addNodeImports(builder);
        return new AbstractMap.SimpleEntry<String, Frame>(this.calculateLayerPath(node, this.addWorkingPackage(builder)), builder.toFrame());
    }

    private void addSlot(FrameBuilder builder, Mogram mogram) {
        if (mogram instanceof MogramReference || mogram.is(Tag.Instance)) {
            return;
        }
        builder.add("node", (Object)new FrameBuilder().put(this.adapters).append((Object)mogram).toFrame());
    }

    public Map.Entry<String, Frame> createDecorable(Mogram node) {
        FrameBuilder builder = new FrameBuilder(new String[]{"Layer", "decorable"});
        String aPackage = this.addWorkingPackage(builder);
        builder.add("name", (Object)node.name());
        if (!(node.container() instanceof MogramRoot)) {
            builder.add("container", (Object)node.container().qualifiedName());
        }
        if (node.isAbstract()) {
            builder.add("abstract", (Object)true);
        }
        builder.add("decorableNode", node.components().stream().filter(c -> !c.isReference()).map(this::createDecorableFrame).toArray(Frame[]::new));
        return new AbstractMap.SimpleEntry<String, Frame>(this.calculateDecorablePath(node, aPackage), builder.toFrame());
    }

    private Frame createDecorableFrame(Mogram node) {
        FrameBuilder builder = new FrameBuilder(new String[]{"decorableNode"}).add("name", (Object)node.name());
        if (node.isAbstract()) {
            builder.add("abstract", (Object)"abstract");
        }
        builder.add("decorableNode", node.components().stream().filter(c -> !c.isReference()).map(this::createDecorableFrame).toArray(Frame[]::new));
        return builder.toFrame();
    }

    private String calculateLayerPath(Mogram node, String aPackage) {
        return aPackage + "." + (node.is(Tag.Decorable) ? "Abstract" : "") + String.valueOf(Format.firstUpperCase().format((Object)Format.javaValidName().format((Object)node.name()).toString()));
    }

    private String calculateDecorablePath(Mogram node, String aPackage) {
        return aPackage + (String)(node.container() instanceof Model ? "" : "." + node.container().qualifiedName().toLowerCase()) + "." + String.valueOf(Format.firstUpperCase().format((Object)Format.javaValidName().format((Object)node.name()).toString()));
    }

    private void addNodeImports(FrameBuilder builder) {
        LinkedHashSet<String> set = new LinkedHashSet<String>(this.mogramAdapter.getImports());
        set.addAll(this.variableAdapter.getImports());
        if (!set.isEmpty()) {
            builder.add("imports", (Object)set.toArray(new Object[0]));
        }
    }

    private String addWorkingPackage(FrameBuilder builder) {
        String packagePath = this.workingPackage.toLowerCase();
        if (!packagePath.isEmpty()) {
            builder.add("package", (Object)packagePath);
        }
        return packagePath.endsWith(".") ? packagePath.substring(0, packagePath.length() - 1) : packagePath;
    }
}

