/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.compiler.codegeneration.magritte.natives;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.FrameBuilderContext;
import io.intino.magritte.builder.compiler.codegeneration.magritte.NameFormatter;
import io.intino.magritte.builder.compiler.codegeneration.magritte.TemplateTags;
import io.intino.tara.Language;
import io.intino.tara.Resolver;
import io.intino.tara.builder.model.Model;
import io.intino.tara.builder.model.MogramImpl;
import io.intino.tara.builder.model.VariableReference;
import io.intino.tara.builder.parser.NativeExtractor;
import io.intino.tara.builder.utils.Format;
import io.intino.tara.language.model.Facet;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.MogramContainer;
import io.intino.tara.language.model.MogramRoot;
import io.intino.tara.language.model.Parameter;
import io.intino.tara.language.model.Primitive;
import io.intino.tara.language.model.Tag;
import io.intino.tara.language.model.Valued;
import io.intino.tara.language.model.Variable;
import io.intino.tara.language.model.rules.variable.NativeObjectRule;
import io.intino.tara.language.model.rules.variable.NativeRule;
import io.intino.tara.language.semantics.Constraint;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class NativeFormatter
implements TemplateTags {
    private final String outDsl;
    private final Language language;
    private final String aPackage;
    private final String workingPackage;
    private final boolean system;
    private final Map<String, Set<String>> imports;
    private String languageWorkingPackage;

    public NativeFormatter(Language language, String outDsl, String aPackage, String workingPackage, String languageWorkingPackage, boolean system, File importsFile) {
        this.outDsl = outDsl;
        this.language = language;
        this.aPackage = aPackage;
        this.workingPackage = workingPackage;
        this.languageWorkingPackage = languageWorkingPackage;
        this.system = system;
        this.imports = this.load(importsFile);
    }

    public static String workingPackageScope(Valued valued, String workingPackage) {
        return valued.scope() != null && !valued.scope().isEmpty() ? valued.scope() : workingPackage;
    }

    private static String getQn(Mogram owner, String language, boolean m0) {
        return !m0 ? NameFormatter.getQn(owner, language) : language.toLowerCase() + "." + owner.type();
    }

    private static String getQn(Facet facet, String language, boolean m0) {
        return NativeFormatter.asFacet(facet, language);
    }

    private static String asFacet(Facet facet, String language) {
        return null;
    }

    private static String getQn(Mogram owner, Mogram node, String workingPackage, boolean m0) {
        return !m0 ? NameFormatter.getQn(owner, workingPackage) : workingPackage.toLowerCase() + "." + owner.type();
    }

    public static String getSignature(Parameter parameter) {
        return ((NativeRule)parameter.rule()).signature();
    }

    public static String getInterface(Parameter parameter) {
        NativeRule rule = (NativeRule)parameter.rule();
        if (rule.interfaceClass() == null) {
            return "";
        }
        return rule.interfaceClass();
    }

    public static String getInterface(Variable variable) {
        NativeRule rule = (NativeRule)variable.rule();
        if (rule.interfaceClass() == null) {
            return "";
        }
        return rule.interfaceClass();
    }

    public static String formatBody(String body, String signature) {
        String formattedBody;
        String returnText = "return ";
        String string = formattedBody = body.endsWith(";") || body.endsWith("}") ? body : body + ";";
        if (!(signature.contains(" void ") || formattedBody.contains("\n") || formattedBody.startsWith("return "))) {
            return "return " + formattedBody;
        }
        return formattedBody;
    }

    public static String getReturn(String body) {
        String returnText = "return ";
        String string = body = body.endsWith(";") || body.endsWith("}") ? body : body + ";";
        if (!body.contains("\n") && !body.startsWith("return ")) {
            return "return ";
        }
        return "";
    }

    public static String getSignature(Variable variable) {
        return ((NativeRule)variable.rule()).signature();
    }

    public static String buildContainerPath(String languageWorkingPackage, Mogram node, String workingPackage) {
        if (node instanceof Mogram) {
            Mogram scope;
            Mogram mogram = scope = node.is(Tag.Instance) ? NativeFormatter.firstNoFeature((MogramContainer)node) : NativeFormatter.firstNoFeatureAndNamed((MogramContainer)node);
            if (scope == null) {
                return "";
            }
            if (scope.is(Tag.Instance)) {
                return NativeFormatter.getTypeAsScope(scope, languageWorkingPackage);
            }
            return NativeFormatter.getQn(scope, node, workingPackage, false);
        }
        if (node instanceof Facet) {
            Mogram scope = NativeFormatter.firstNoFeatureAndNamed((MogramContainer)node);
            if (scope == null) {
                return "";
            }
            return scope.is(Tag.Instance) ? NativeFormatter.getTypeAsScope(scope, languageWorkingPackage) : NativeFormatter.getQn(scope, workingPackage, false);
        }
        return "";
    }

    public static String buildExpressionContainerPath(String typeWorkingPackage, Mogram owner, String outDSL, String workingPackage) {
        String trueWorkingPackage = NativeFormatter.extractWorkingPackage(typeWorkingPackage, workingPackage);
        if (owner instanceof Mogram) {
            Mogram scope;
            Mogram mogram = scope = owner.is(Tag.Instance) ? NativeFormatter.firstNoFeature((MogramContainer)owner) : NativeFormatter.firstNoFeatureAndNamed((MogramContainer)owner);
            if (scope == null) {
                return "";
            }
            if (scope.is(Tag.Instance)) {
                return NativeFormatter.getTypeAsScope(scope, trueWorkingPackage);
            }
            return NativeFormatter.getQn(scope, owner, workingPackage, false);
        }
        if (owner instanceof Facet) {
            return owner.container().is(Tag.Instance) ? NativeFormatter.getTypeAsScope(owner, trueWorkingPackage) : NativeFormatter.getQn((Facet)owner, workingPackage, false);
        }
        return "";
    }

    private static String extractWorkingPackage(String scope, String language) {
        return scope != null && !scope.isEmpty() ? scope : language;
    }

    private static String getTypeAsScope(Mogram scope, String languageWorkingPackage) {
        return languageWorkingPackage + "." + (scope instanceof Mogram ? NameFormatter.cleanQn(scope.type()) : NameFormatter.cleanQn(NativeFormatter.facetType((Facet)scope)));
    }

    private static List<Facet> containerFacets(Mogram scope) {
        Mogram container;
        for (container = scope.container(); container != null && container.appliedFacets().isEmpty(); container = container.container()) {
        }
        return container != null ? container.appliedFacets() : Collections.emptyList();
    }

    private static String facetType(Facet scope) {
        return scope.type().toLowerCase() + "." + scope.type() + Resolver.shortType((String)scope.container().type());
    }

    private static Mogram firstNoFeature(MogramContainer owner) {
        for (MogramContainer container = owner; container != null; container = container.container()) {
            if (!(container instanceof Mogram) || container instanceof MogramRoot || ((Mogram)container).is(Tag.Feature)) continue;
            return (Mogram)container;
        }
        return owner instanceof Mogram ? (Mogram)owner : owner.container();
    }

    private static Mogram firstNoFeatureAndNamed(MogramContainer owner) {
        for (MogramContainer container = owner; container != null; container = container.container()) {
            if (!(container instanceof Mogram) || container instanceof MogramRoot || ((Mogram)container).isAnonymous() || ((Mogram)container).is(Tag.Feature)) continue;
            return (Mogram)container;
        }
        return owner instanceof Mogram ? (Mogram)owner : owner.container();
    }

    private static MogramContainer searchFeatureReference(Mogram owner) {
        Model model = NativeFormatter.model((MogramContainer)owner);
        if (model == null) {
            return owner;
        }
        MogramContainer nodeContainer = NativeFormatter.searchFeatureReference((MogramContainer)model, owner);
        return nodeContainer != null ? nodeContainer : owner;
    }

    private static MogramContainer searchFeatureReference(MogramContainer node, Mogram target) {
        if (node instanceof Mogram && ((Mogram)node).isReference() && target.equals((Object)((Mogram)node).targetOfReference())) {
            return node.container();
        }
        if (node instanceof Mogram && ((Mogram)node).isReference()) {
            return null;
        }
        for (Mogram component : node.components()) {
            MogramContainer nodeContainer = NativeFormatter.searchFeatureReference((MogramContainer)component, target);
            if (nodeContainer == null) continue;
            return nodeContainer;
        }
        return null;
    }

    private static Model model(MogramContainer owner) {
        for (MogramContainer container = owner; container != null; container = container.container()) {
            if (!(container instanceof Mogram) || !(container instanceof Model)) continue;
            return (Model)container;
        }
        return null;
    }

    public static String calculatePackage(Mogram container) {
        Mogram node = NativeFormatter.firstNamedContainer(container);
        return node == null ? "" : ((MogramImpl)node).layerQn().replace("$", ".").replace("#", ".").toLowerCase();
    }

    private static Mogram firstNamedContainer(Mogram container) {
        List<Mogram> containers = NativeFormatter.collectStructure(container);
        Mogram candidate = null;
        for (Mogram nodeContainer : containers) {
            if (nodeContainer instanceof Mogram && !nodeContainer.isAnonymous()) {
                candidate = nodeContainer;
                continue;
            }
            if (nodeContainer instanceof Mogram) break;
            candidate = nodeContainer;
        }
        return candidate;
    }

    private static List<Mogram> collectStructure(Mogram container) {
        ArrayList<Mogram> containers = new ArrayList<Mogram>();
        for (Mogram current = container; current != null && !(current instanceof MogramRoot); current = current.container()) {
            containers.add(0, current);
        }
        return containers;
    }

    private static Constraint.Parameter findParameter(List<Constraint.Parameter> parameters, String name) {
        for (Constraint.Parameter variable : parameters) {
            if (!variable.name().equals(name)) continue;
            return variable;
        }
        return null;
    }

    private Map<String, Set<String>> load(File importsFile) {
        if (importsFile == null) {
            return new HashMap<String, Set<String>>();
        }
        try {
            return (Map)new Gson().fromJson((Reader)new FileReader(importsFile), new TypeToken<Map<String, Set<String>>>(this){}.getType());
        }
        catch (FileNotFoundException e) {
            return new HashMap<String, Set<String>>();
        }
    }

    public void fillFrameForFunctionVariable(Variable variable, Object body, FrameBuilderContext context) {
        String signature = NativeFormatter.getSignature(variable);
        context.add("package", (Object)this.aPackage);
        HashSet<String> imports = new HashSet<String>(((NativeRule)variable.rule()).imports());
        imports.addAll(this.collectImports((Valued)variable));
        if (!imports.isEmpty()) {
            context.add("imports", (Object)imports.toArray(new String[imports.size()]));
        }
        if (!context.contains("scope")) {
            context.add("scope", (Object)this.workingPackage);
        }
        if (!context.contains("generatedLanguage")) {
            context.add("generatedLanguage", (Object)this.outDsl.toLowerCase());
        }
        if (!context.contains("workingPackage")) {
            context.add("workingPackage", (Object)this.workingPackage.toLowerCase());
        }
        if (!context.contains("rule")) {
            context.add("rule", (Object)NameFormatter.cleanQn(NativeFormatter.getInterface(variable)));
        }
        if (!context.contains("name")) {
            context.add("name", (Object)variable.name());
        }
        if (!context.contains("qn")) {
            context.add("qn", (Object)variable.container().qualifiedName());
        }
        context.add("file", (Object)variable.file());
        context.add("line", (Object)variable.line());
        context.add("column", (Object)variable.column());
        if (body != null) {
            context.add("body", (Object)NativeFormatter.formatBody(body.toString(), signature));
        }
        context.add("nativeContainer", (Object)NameFormatter.cleanQn(NativeFormatter.buildContainerPath(variable.scope(), variable.container(), this.workingPackage)));
        context.add("signature", (Object)signature);
        context.add("uid", (Object)variable.getUID());
        NativeExtractor extractor = new NativeExtractor(signature);
        context.add("methodName", (Object)extractor.methodName());
        context.add("parameters", (Object)extractor.parameters());
        context.add("returnType", (Object)extractor.returnType());
        context.add("exception", (Object)extractor.exceptions());
    }

    public void fillFrameForFunctionParameter(Parameter parameter, Object body, FrameBuilderContext context) {
        String signature = NativeFormatter.getSignature(parameter);
        if (!context.contains("generatedLanguage")) {
            context.add("generatedLanguage", (Object)this.outDsl);
        }
        if (!context.contains("name")) {
            context.add("name", (Object)parameter.name());
        }
        if (!this.aPackage.isEmpty()) {
            context.add("package", (Object)this.aPackage.toLowerCase());
        }
        if (!context.contains("qn")) {
            context.add("qn", (Object)NameFormatter.cleanQn(parameter.container().qualifiedName()));
        }
        if (!context.contains("scope")) {
            context.add("scope", (Object)NativeFormatter.workingPackageScope((Valued)parameter, this.workingPackage));
        }
        if (!context.contains("workingPackage")) {
            context.add("workingPackage", (Object)this.workingPackage.toLowerCase());
        }
        if (!context.contains("rule".toLowerCase())) {
            context.add("rule", (Object)NameFormatter.cleanQn(NativeFormatter.getInterface(parameter)));
        }
        HashSet<String> imports = new HashSet<String>(((NativeRule)parameter.rule()).imports());
        imports.addAll(this.collectImports((Valued)parameter));
        context.add("imports", (Object)imports.toArray(new String[imports.size()]));
        context.add("signature", (Object)signature);
        context.add("file", (Object)parameter.file());
        context.add("line", (Object)parameter.line());
        context.add("column", (Object)parameter.column());
        context.add("nativeContainer", (Object)NameFormatter.cleanQn(NativeFormatter.buildContainerPath(parameter.scope(), parameter.container(), this.workingPackage)));
        context.add("uid", (Object)parameter.getUID());
        NativeExtractor extractor = new NativeExtractor(signature);
        context.add("methodName", (Object)extractor.methodName());
        context.add("parameters", (Object)extractor.parameters());
        if (body != null) {
            context.add("body", (Object)NativeFormatter.formatBody(body.toString(), signature));
        }
        context.add("returnType", (Object)extractor.returnType());
        context.add("exception", (Object)extractor.exceptions());
    }

    public void fillFrameNativeVariable(FrameBuilderContext context, Variable variable, Object body) {
        context.add("native");
        context.add("file", (Object)variable.file());
        context.add("line", (Object)variable.line());
        context.add("column", (Object)variable.column());
        HashSet<String> imports = new HashSet<String>(variable.rule() != null ? ((NativeRule)variable.rule()).imports() : new HashSet());
        imports.addAll(this.collectImports((Valued)variable));
        if (!context.contains("rule".toLowerCase())) {
            context.add("rule", (Object)NameFormatter.cleanQn(NativeFormatter.getInterface(variable)));
        }
        context.add("imports", (Object)imports.toArray(new String[imports.size()]));
        if (!this.aPackage.isEmpty()) {
            context.add("package", (Object)this.aPackage.toLowerCase());
        }
        if (!context.contains("name")) {
            context.add("name", (Object)variable.name());
        }
        if (!context.contains("generatedLanguage")) {
            context.add("generatedLanguage", (Object)this.outDsl);
        }
        if (!context.contains("workingPackage")) {
            context.add("workingPackage", (Object)this.workingPackage.toLowerCase());
        }
        context.add("nativeContainer".toLowerCase(), (Object)this.buildContainerPathOfExpression((Valued)variable));
        if (!context.contains("type")) {
            context.add("type", (Object)this.typeFrame(this.type(variable), variable.isMultiple()));
        }
        context.add("uid", (Object)variable.getUID());
        if (body != null) {
            context.add("body", (Object)NativeFormatter.formatBody(body.toString(), variable.type().getName()));
        }
    }

    public void fillFrameNativeParameter(FrameBuilderContext context, Parameter parameter, String body) {
        context.add("native");
        context.add("file", (Object)parameter.file());
        context.add("line", (Object)parameter.line());
        context.add("column", (Object)parameter.column());
        HashSet<String> imports = new HashSet<String>(parameter.rule() != null ? ((NativeRule)parameter.rule()).imports() : new HashSet());
        imports.addAll(this.collectImports((Valued)parameter));
        context.add("imports", (Object)imports.toArray(new String[imports.size()]));
        context.add("nativeContainer", (Object)this.buildContainerPathOfExpression((Valued)parameter));
        context.add("uid", (Object)parameter.getUID());
        if (!this.aPackage.isEmpty()) {
            context.add("package", (Object)this.aPackage.toLowerCase());
        }
        if (!context.contains("name".toLowerCase())) {
            context.add("name", (Object)parameter.name());
        }
        if (!context.contains("generatedLanguage".toLowerCase())) {
            context.add("generatedLanguage", (Object)this.outDsl.toLowerCase());
        }
        if (!context.contains("workingPackage".toLowerCase())) {
            context.add("workingPackage", (Object)this.workingPackage.toLowerCase());
        }
        if (!context.contains("type".toLowerCase())) {
            context.add("type", (Object)this.typeFrame(this.type(parameter), this.isMultiple(parameter)));
        }
        if (body != null) {
            context.add("body", (Object)NativeFormatter.formatBody(body, parameter.type().getName()));
        }
    }

    public String type(Variable variable) {
        boolean multiple = variable.isMultiple();
        if (variable.flags().contains(Tag.Concept)) {
            return "io.intino.magritte.framework.Concept";
        }
        if (variable.isReference()) {
            return NameFormatter.getQn(((VariableReference)variable).targetOfReference(), ((VariableReference)variable).isTypeReference() ? this.languageWorkingPackage : this.workingPackage);
        }
        if (Primitive.OBJECT.equals((Object)variable.type())) {
            return ((NativeObjectRule)variable.rule()).type();
        }
        if (Primitive.WORD.equals((Object)variable.type())) {
            return NameFormatter.getQn(variable.container(), this.workingPackage) + "." + String.valueOf(Format.firstUpperCase().format((Object)variable.name()));
        }
        return variable.type().javaName();
    }

    private boolean isMultiple(Parameter parameter) {
        Constraint.Parameter constraint = this.parameterConstraintOf(parameter);
        return constraint != null && !constraint.size().isSingle();
    }

    public String type(Parameter parameter) {
        boolean multiple = parameter.isMultiple();
        return parameter.type().equals((Object)Primitive.OBJECT) ? ((NativeObjectRule)parameter.rule()).type() : parameter.type().javaName();
    }

    private Frame typeFrame(String type, boolean multiple) {
        return (multiple ? new FrameBuilder(new String[]{"list"}).add("value", (Object)type) : new FrameBuilder().add("value", (Object)type)).toFrame();
    }

    private List<String> collectImports(Valued parameter) {
        String qn = (parameter.container().qualifiedName() + "." + parameter.name()).replace(":", "");
        return this.imports.containsKey(qn) ? new ArrayList(this.imports.get(qn)) : Collections.emptyList();
    }

    public String buildContainerPathOfExpression(Valued valued) {
        return NameFormatter.cleanQn(NativeFormatter.buildExpressionContainerPath(valued.scope(), valued.container(), this.outDsl, this.system ? this.languageWorkingPackage : this.workingPackage));
    }

    public Constraint.Parameter parameterConstraintOf(Parameter parameter) {
        List<Constraint.Parameter> parameters = this.parameterConstraintsOf(parameter.container());
        if (parameters.isEmpty() || parameters.size() <= parameter.position()) {
            return null;
        }
        return NativeFormatter.findParameter(parameters, parameter.name());
    }

    private List<Constraint.Parameter> parameterConstraintsOf(Mogram node) {
        if (this.language == null) {
            return Collections.emptyList();
        }
        List nodeConstraints = this.language.constraints(node.resolve().type());
        if (nodeConstraints == null) {
            return Collections.emptyList();
        }
        ArrayList constraints = new ArrayList(nodeConstraints);
        ArrayList<Constraint.Parameter> parameters = new ArrayList<Constraint.Parameter>();
        for (Constraint constraint : constraints) {
            if (constraint instanceof Constraint.Parameter) {
                parameters.add((Constraint.Parameter)constraint);
                continue;
            }
            if (!(constraint instanceof Constraint.Facet)) continue;
            parameters.addAll(((Constraint.Facet)constraint).constraints().stream().filter(c -> c instanceof Constraint.Parameter).map(c -> (Constraint.Parameter)c).collect(Collectors.toList()));
        }
        return parameters;
    }
}

