/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder;

import io.intino.builder.BuildConstants;
import io.intino.magritte.builder.compiler.operations.LayerGenerationOperation;
import io.intino.tara.builder.CompilationInfoExtractor;
import io.intino.tara.builder.TaraCompilerRunner;
import io.intino.tara.builder.core.CompilerConfiguration;
import io.intino.tara.builder.core.errorcollection.TaraException;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MagrittecRunner {
    private static final Logger LOG = Logger.getGlobal();

    private MagrittecRunner() {
    }

    public static void main(String[] args) {
        boolean verbose;
        boolean bl = verbose = args.length != 2 || Boolean.parseBoolean(args[1]);
        if (verbose) {
            System.out.println("@#$%@# Presentable:Starting compiling");
        }
        try {
            File argsFile;
            if (MagrittecRunner.checkArgumentsNumber(args) || (argsFile = MagrittecRunner.checkConfigurationFile(args[0])) == null) {
                throw new TaraException("Error finding args file");
            }
            CompilerConfiguration config = new CompilerConfiguration();
            LinkedHashMap sources = new LinkedHashMap();
            CompilationInfoExtractor.getInfoFromArgsFile((File)argsFile, (CompilerConfiguration)config, sources);
            TaraCompilerRunner runner = new TaraCompilerRunner(verbose, List.of(LayerGenerationOperation.class));
            if (sources.isEmpty() || !config.mode().equals((Object)BuildConstants.Mode.Build)) {
                return;
            }
            runner.run(config, sources);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, e.getMessage() == null ? e.getStackTrace()[0].toString() : e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static File checkConfigurationFile(String arg) {
        File argsFile = new File(arg);
        if (!argsFile.exists()) {
            LOG.severe("%%mArguments file for Tara compiler not found/%m");
            return null;
        }
        return argsFile;
    }

    private static boolean checkArgumentsNumber(String[] args) {
        if (args.length < 1) {
            LOG.severe("%%mThere is no arguments for tara compiler/%m");
            return true;
        }
        return false;
    }
}

