/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.compiler.codegeneration.magritte;

import io.intino.itrules.Adapter;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.FrameBuilderContext;
import io.intino.itrules.adapters.ExcludeAdapter;
import io.intino.magritte.builder.compiler.codegeneration.magritte.NameFormatter;
import io.intino.magritte.builder.compiler.codegeneration.magritte.TemplateTags;
import io.intino.magritte.builder.compiler.codegeneration.magritte.layer.TypesProvider;
import io.intino.tara.Language;
import io.intino.tara.builder.model.Model;
import io.intino.tara.builder.model.MogramReference;
import io.intino.tara.builder.model.VariableReference;
import io.intino.tara.builder.parser.NativeExtractor;
import io.intino.tara.builder.utils.Format;
import io.intino.tara.language.model.Facet;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.MogramRoot;
import io.intino.tara.language.model.Parameter;
import io.intino.tara.language.model.Primitive;
import io.intino.tara.language.model.Rule;
import io.intino.tara.language.model.Tag;
import io.intino.tara.language.model.Variable;
import io.intino.tara.language.model.rules.variable.NativeObjectRule;
import io.intino.tara.language.model.rules.variable.NativeRule;
import io.intino.tara.language.model.rules.variable.VariableCustomRule;
import io.intino.tara.language.model.rules.variable.WordRule;
import io.intino.tara.language.semantics.Constraint;
import io.intino.tara.language.semantics.constraints.parameter.ReferenceParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class Generator
implements TemplateTags {
    protected final Language language;
    protected final String outDsl;
    protected final String workingPackage;
    protected final String languageWorkingPackage;
    protected Set<String> imports = new HashSet<String>();

    public Generator(Language language, String outDsl, String workingPackage, String languageWorkingPackage) {
        this.language = language;
        this.outDsl = outDsl;
        this.workingPackage = workingPackage;
        this.languageWorkingPackage = languageWorkingPackage;
    }

    public static boolean isInDecorable(Mogram node) {
        Mogram container = node.container();
        if (container instanceof MogramRoot) {
            return false;
        }
        while (!(container.container() instanceof MogramRoot)) {
            container = container.container();
        }
        return container.is(Tag.Decorable);
    }

    public Set<String> getImports() {
        return this.imports;
    }

    protected void addParent(Mogram mogram, FrameBuilderContext context) {
        Mogram parent = mogram.parent();
        if (parent == null) {
            if (!mogram.children().isEmpty() || context.contains("create") || context.contains("node")) {
                context.add("parentSuper", (Object)false);
            }
            return;
        }
        String parentQN = NameFormatter.cleanQn(NameFormatter.getQn(parent, this.workingPackage));
        context.add("parent", (Object)parentQN);
        if (context.contains("create") || context.contains("node")) {
            context.add("parentSuper", (Object)true).add("parentName", (Object)parentQN);
        }
        Mogram parentTarget = parent.container();
        if (context.contains("node") && this.hasLists(mogram.parent()) || parent.isFacet() && !(parentTarget instanceof Model) && parentTarget.components().stream().anyMatch(c -> !c.isFacet() && !c.isMetaFacet()) && this.hasLists(parentTarget)) {
            context.add("parentClearName", (Object)parentQN);
        }
    }

    protected void addComponents(Mogram mogram, FrameBuilderContext context) {
        if (mogram instanceof MogramReference) {
            return;
        }
        mogram.components().stream().filter(c -> !c.is(Tag.Instance) && !c.isFacet() && !c.isAnonymous() && (!c.isReference() || ((MogramReference)c).isHas())).forEach(c -> context.add("node", (Object)FrameBuilder.from((FrameBuilderContext)context).append(c).add("owner").toFrame()));
    }

    protected String getType(Variable variable) {
        if (variable instanceof VariableReference) {
            return NameFormatter.cleanQn(NameFormatter.getQn(((VariableReference)variable).getTarget(), (((VariableReference)variable).isTypeReference() ? this.languageWorkingPackage : this.workingPackage).toLowerCase()));
        }
        if (Primitive.WORD.equals((Object)variable.type())) {
            return variable.rule() != null && variable.rule() instanceof VariableCustomRule ? this.workingPackage.toLowerCase() + ".rules." + String.valueOf(Format.firstUpperCase().format((Object)((VariableCustomRule)variable.rule()).externalClass())) : Format.firstUpperCase().format((Object)variable.name()).toString();
        }
        if (Primitive.OBJECT.equals((Object)variable.type())) {
            return ((NativeObjectRule)variable.rule()).type();
        }
        return variable.type().javaName();
    }

    protected FrameBuilder ruleToFrame(Rule rule) {
        if (rule == null) {
            return null;
        }
        FrameBuilder builder = new FrameBuilder();
        builder.put(Rule.class, (Adapter)new ExcludeAdapter(new String[]{"loadedClass"}));
        builder.append((Object)rule);
        if (rule instanceof VariableCustomRule) {
            FrameBuilder frameBuilder = new FrameBuilder(new String[]{"customRule"});
            frameBuilder.add("qn", (Object)NameFormatter.cleanQn(((VariableCustomRule)rule).qualifiedName()));
            frameBuilder.add("aClass", (Object)NameFormatter.cleanQn(((VariableCustomRule)rule).externalClass()));
            if (((VariableCustomRule)rule).isMetric()) {
                frameBuilder.add("metric");
                frameBuilder.add("default", (Object)((VariableCustomRule)rule).getDefaultUnit());
            }
            return frameBuilder;
        }
        return builder;
    }

    protected Predicate<Tag> isLayerInterface() {
        return tag -> tag.equals((Object)Tag.Component) || tag.equals((Object)Tag.Feature) || tag.equals((Object)Tag.Terminal) || tag.equals((Object)Tag.Private) || tag.equals((Object)Tag.Volatile);
    }

    protected void addTerminalVariables(Mogram node, FrameBuilderContext context) {
        List<Constraint> terminalCoreVariables = this.collectTerminalCoreVariables(node);
        if (node.parent() == null && !terminalCoreVariables.isEmpty() && !context.contains("metaType")) {
            context.add("metaType", (Object)(this.languageWorkingPackage + "." + this.metaType(node)));
        }
        terminalCoreVariables.forEach(c -> this.addTerminalVariable(node, this.languageWorkingPackage + "." + node.type(), context, (Constraint.Parameter)c, node.parent() != null, this.isRequired(node, (Constraint.Parameter)c), "metaType", this.languageWorkingPackage));
        this.addAspectVariables(node, context);
        if (!context.contains("container")) {
            context.add("container", (Object)(Generator.isInDecorable(node) ? node.qualifiedName() : node.name()));
        }
    }

    private boolean isRequired(Mogram node, Constraint.Parameter allow) {
        Mogram n;
        Mogram mogram = n = node.isReference() ? node.targetOfReference() : node;
        while (n != null) {
            for (Parameter parameter : n.parameters()) {
                if (!parameter.name().equals(allow.name())) continue;
                return false;
            }
            n = n.parent();
        }
        return true;
    }

    private void addAspectVariables(Mogram node, FrameBuilderContext context) {
        for (Facet aspect : node.appliedFacets()) {
            context.add("metaAspect", (Object)new FrameBuilder(new String[]{"metaAspect"}).add("name", (Object)aspect.type()).add("type", (Object)(this.languageWorkingPackage + "." + aspect.fullType())).toFrame());
        }
        this.collectTerminalFacetVariables(node).forEach((key, value) -> value.forEach(c -> this.addTerminalVariable(node, this.languageWorkingPackage + "." + node.type(), context, (Constraint.Parameter)c, node.parent() != null, this.isRequired(node, (Constraint.Parameter)c), (String)key, this.languageWorkingPackage)));
    }

    private List<Constraint> collectTerminalCoreVariables(Mogram node) {
        List allows = this.language.constraints(node.type());
        if (allows == null) {
            return Collections.emptyList();
        }
        return allows.stream().filter(allow -> allow instanceof Constraint.Parameter && ((Constraint.Parameter)allow).flags().contains(Tag.Terminal) && !this.isRedefined((Constraint.Parameter)allow, node.variables())).collect(Collectors.toList());
    }

    private Map<String, List<Constraint>> collectTerminalFacetVariables(Mogram node) {
        List constraints = this.language.constraints(node.type());
        if (constraints == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<Constraint>> map = new HashMap<String, List<Constraint>>();
        List<Constraint> aspects = constraints.stream().filter(c -> c instanceof Constraint.Facet && this.hasFacet(node, ((Constraint.Facet)c).type())).toList();
        for (Constraint aspect : aspects) {
            map.put(((Constraint.Facet)aspect).type(), new ArrayList());
        }
        aspects.forEach(f -> map.put(((Constraint.Facet)f).type(), ((Constraint.Facet)f).constraints().stream().filter(this.byTerminalParameters(node)).collect(Collectors.toList())));
        return map;
    }

    protected String metaType(Mogram node) {
        String type = node.type();
        return type.contains(":") ? type.split(":")[1] + "." + node.type().replace(":", "") : node.type();
    }

    private void addTerminalVariable(Mogram node, String type, FrameBuilderContext context, Constraint.Parameter parameter, boolean inherited, boolean isRequired, String containerName, String languageWorkingPackage) {
        FrameBuilder varBuilder = this.createFrame(parameter, type, inherited, isRequired, containerName, languageWorkingPackage);
        if (!varBuilder.contains("container")) {
            varBuilder.add("container", (Object)(Generator.isInDecorable(node) ? node.qualifiedName() : node.name()));
        }
        context.add("variable", (Object)varBuilder.toFrame());
    }

    private boolean hasFacet(Mogram node, String type) {
        return node.appliedFacets().stream().anyMatch(aspect -> aspect.type().equals(type));
    }

    private Predicate<Constraint> byTerminalParameters(Mogram node) {
        return o -> o instanceof Constraint.Parameter && ((Constraint.Parameter)o).flags().contains(Tag.Terminal) && !this.isRedefined((Constraint.Parameter)o, node.variables());
    }

    private boolean isRedefined(Constraint.Parameter allow, List<? extends Variable> variables) {
        return variables.stream().anyMatch(variable -> variable.name().equals(allow.name()));
    }

    private FrameBuilder createFrame(Constraint.Parameter parameter, String type, boolean inherited, boolean isRequired, String containerName, String workingPackage) {
        WordRule rule;
        FrameBuilder builder = new FrameBuilder(TypesProvider.getTypes(parameter, isRequired)).add("metaType").add("target");
        if (inherited) {
            builder.add("inherited");
        }
        builder.add("name", (Object)parameter.name());
        builder.add("containerName", (Object)containerName);
        builder.add("qn", (Object)type);
        builder.add("language", (Object)this.language.languageName().toLowerCase());
        builder.add("workingPackage", (Object)workingPackage);
        builder.add("type", (Object)this.type(parameter));
        if (parameter.type().equals((Object)Primitive.WORD)) {
            rule = (WordRule)parameter.rule();
            List words = rule.words();
            if (rule.isCustom()) {
                builder.add("outDefined");
                builder.add("externalClass", (Object)NameFormatter.cleanQn(rule.externalClass()));
            }
            builder.add("wordValues", (Object)words.toArray(new Object[0]));
        }
        if (parameter.type().equals((Object)Primitive.FUNCTION)) {
            rule = (NativeRule)parameter.rule();
            String signature = rule.signature();
            NativeExtractor extractor = new NativeExtractor(signature);
            builder.add("methodName", (Object)extractor.methodName());
            builder.add("parameters", (Object)extractor.parameters());
            builder.add("returnType", (Object)extractor.returnType());
            builder.add("rule", (Object)rule.interfaceClass());
            builder.add("generatedLanguage", (Object)parameter.scope());
            this.imports.addAll(new ArrayList(rule.imports()));
        }
        if (!builder.contains("generatedLanguage")) {
            builder.add("generatedLanguage", (Object)this.outDsl.toLowerCase());
        }
        return builder;
    }

    private String type(Constraint.Parameter parameter) {
        return parameter instanceof ReferenceParameter ? this.languageWorkingPackage + "." + ((ReferenceParameter)parameter).referenceType() : parameter.type().getName();
    }

    private boolean hasLists(Mogram node) {
        return node.components().stream().filter(c -> !c.isFacet() && !c.isMetaFacet()).anyMatch(c -> !node.sizeOf(c).isSingle() && !c.is(Tag.Final));
    }
}

