/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.compiler.operations;

import io.intino.magritte.builder.compiler.codegeneration.magritte.stash.StashCreator;
import io.intino.magritte.io.Stash;
import io.intino.magritte.io.StashSerializer;
import io.intino.tara.Language;
import io.intino.tara.builder.core.CompilationUnit;
import io.intino.tara.builder.core.CompilerConfiguration;
import io.intino.tara.builder.core.errorcollection.CompilationFailedException;
import io.intino.tara.builder.core.errorcollection.TaraException;
import io.intino.tara.builder.core.operation.model.ModelOperation;
import io.intino.tara.builder.model.Model;
import io.intino.tara.builder.utils.Format;
import io.intino.tara.language.model.Mogram;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StashGenerationOperation
extends ModelOperation {
    public static final String STASH = ".stash";
    private static final Logger LOG = Logger.getLogger(StashGenerationOperation.class.getName());
    private final CompilerConfiguration conf;
    private String outDSL;

    public StashGenerationOperation(CompilationUnit compilationUnit) {
        super(compilationUnit);
        this.conf = compilationUnit.configuration();
    }

    public void call(Model model) {
        this.outDSL = this.conf.model().level() == CompilerConfiguration.Level.Model ? this.conf.getModule() : this.conf.model().outDsl();
        try {
            if (this.conf.isVerbose()) {
                this.conf.out().println("@#$%@# Presentable:[" + this.conf.getModule() + " - " + this.conf.model().outDsl() + "] Generating Stashes...");
            }
            if (this.conf.isTest() || this.conf.model().level().equals((Object)CompilerConfiguration.Level.Model)) {
                this.createSeparatedStashes(model);
            } else {
                this.createFullStash(model);
            }
        }
        catch (TaraException e) {
            LOG.log(Level.SEVERE, "Error during stash generation: " + e.getMessage(), e);
            throw new CompilationFailedException(this.unit.getPhase(), this.unit, (Throwable)e);
        }
    }

    private void createSeparatedStashes(Model model) {
        this.unpack(model).forEach(nodes -> {
            try {
                this.writeStashTo(this.stashDestination(new File(((Mogram)nodes.get(0)).file())), this.stashOf((List<Mogram>)nodes, model.language()));
            }
            catch (TaraException e) {
                LOG.log(Level.SEVERE, "Error during stash generation: " + e.getMessage(), e);
            }
        });
    }

    private void createFullStash(Model model) throws TaraException {
        if (model.components().isEmpty()) {
            return;
        }
        this.writeStashTo(this.stashDestination(new File(((Mogram)model.components().get(0)).file())), this.stashOf(model.components(), model.language()));
    }

    private Stash stashOf(List<Mogram> nodes, Language language) throws TaraException {
        try {
            return new StashCreator(nodes, language, this.outDSL, this.conf).create();
        }
        catch (Throwable e) {
            throw new TaraException("Error creating stashes: " + e.getMessage());
        }
    }

    private void writeStashTo(File taraFile, Stash stash) {
        try {
            byte[] content = StashSerializer.serialize((Stash)stash);
            File file = this.stashDestination(taraFile);
            stash.path = file.getName();
            file.getParentFile().mkdirs();
            try (FileOutputStream stream = new FileOutputStream(file);){
                stream.write(content);
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Error writing stashes: " + e.getMessage(), e);
                throw new CompilationFailedException(this.unit.getPhase(), this.unit, (Throwable)e);
            }
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, "Error writing stashes: " + e.getMessage(), e);
            throw new CompilationFailedException(this.unit.getPhase(), this.unit, e);
        }
    }

    private File stashDestination(File taraFile) {
        File destiny = this.conf.resourcesDirectory();
        destiny.mkdirs();
        return this.conf.isTest() || this.conf.model().level() == CompilerConfiguration.Level.Model ? new File(destiny, taraFile.getName().split("\\.")[0] + STASH) : new File(destiny, Format.firstUpperCase().format((Object)this.conf.model().outDsl()).toString() + STASH);
    }

    private List<List<Mogram>> unpack(Model model) {
        HashMap<String, List<Mogram>> nodes = new HashMap<String, List<Mogram>>();
        model.components().forEach(node -> {
            if (!nodes.containsKey(node.file())) {
                nodes.put(node.file(), new ArrayList());
            }
            ((List)nodes.get(node.file())).add(node);
        });
        return this.unpack(nodes);
    }

    private List<List<Mogram>> unpack(Map<String, List<Mogram>> nodes) {
        return new ArrayList<List<Mogram>>(nodes.values());
    }
}

