/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.compiler.codegeneration.magritte.natives;

import io.intino.itrules.Adapter;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.magritte.builder.compiler.codegeneration.magritte.natives.ExpressionsTemplate;
import io.intino.magritte.builder.compiler.codegeneration.magritte.natives.NativeFormatter;
import io.intino.magritte.builder.compiler.codegeneration.magritte.natives.NativeParameterAdapter;
import io.intino.magritte.builder.compiler.codegeneration.magritte.natives.NativeVariableAdapter;
import io.intino.magritte.builder.core.CompilerConfiguration;
import io.intino.magritte.builder.model.Model;
import io.intino.magritte.builder.model.NodeImpl;
import io.intino.magritte.builder.model.NodeReference;
import io.intino.magritte.builder.utils.Format;
import io.intino.magritte.lang.model.Node;
import io.intino.magritte.lang.model.NodeRoot;
import io.intino.magritte.lang.model.Parameter;
import io.intino.magritte.lang.model.Primitive;
import io.intino.magritte.lang.model.Tag;
import io.intino.magritte.lang.model.Variable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class NativesCreator {
    private static final Logger LOG = Logger.getLogger(NativesCreator.class.getName());
    private static final String NATIVES = "natives";
    private static String nativeExtension;
    private final String nativesPackage;
    private final Model model;
    private final CompilerConfiguration conf;
    private final File outDirectory;
    private final String outDSL;

    public NativesCreator(Model model, CompilerConfiguration conf) {
        this.model = model;
        this.conf = conf;
        this.outDirectory = conf.getOutDirectory();
        this.outDSL = conf.model().outDsl() != null ? conf.model().outDsl().toLowerCase() : conf.getModule();
        this.nativesPackage = conf.workingPackage().toLowerCase().replace(".", File.separator) + File.separator + NATIVES + File.separator;
        nativeExtension = "." + (conf.nativeLanguage().equalsIgnoreCase("kotlin") ? "kt" : conf.nativeLanguage().toLowerCase());
    }

    public Map<String, String> create() {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        ArrayList<Variable> variables = new ArrayList<Variable>();
        this.extractNativeParameters((Node)this.model, parameters);
        this.extractNativeVariables((Node)this.model, variables);
        return this.createNativeClasses(parameters, variables);
    }

    private Map<String, String> createNativeClasses(List<Parameter> parameters, List<Variable> variables) {
        HashMap<String, String> destinyToOrigin = new HashMap<String, String>();
        HashMap<File, String> nativeCodes = new HashMap<File, String>();
        if (parameters.isEmpty() && variables.isEmpty()) {
            return destinyToOrigin;
        }
        if (!parameters.isEmpty()) {
            nativeCodes.putAll(this.createNativeParameterClasses(parameters, destinyToOrigin));
        }
        if (!variables.isEmpty()) {
            nativeCodes.putAll(this.createNativeVariableClasses(variables, destinyToOrigin));
        }
        for (Map.Entry nativeCode : nativeCodes.entrySet()) {
            this.writeJavaCode((File)nativeCode.getKey(), (String)nativeCode.getValue());
        }
        return destinyToOrigin;
    }

    private Map<File, String> createNativeParameterClasses(List<Parameter> parameters, Map<String, String> originToDestiny) {
        Template expressionsTemplate = this.expressionsTemplate();
        LinkedHashMap<File, String> nativeCodes = new LinkedHashMap<File, String>();
        parameters.forEach(p -> {
            FrameBuilder builder = new FrameBuilder();
            builder.put(Parameter.class, (Adapter)new NativeParameterAdapter(this.model.language(), this.outDSL, this.conf.model().level(), this.conf.workingPackage(), this.conf.model().language().generationPackage(), NativeFormatter.calculatePackage(p.container()), this.conf.getImportsFile()));
            this.createNativeFrame(originToDestiny, expressionsTemplate, nativeCodes, this.calculateDestination((Parameter)p), builder.append(p), p.type(), p.file());
        });
        return nativeCodes;
    }

    private Map<File, String> createNativeVariableClasses(List<Variable> natives, Map<String, String> files) {
        Template expressionsTemplate = this.expressionsTemplate();
        LinkedHashMap<File, String> nativeCodes = new LinkedHashMap<File, String>();
        natives.forEach(variable -> {
            FrameBuilder builder = new FrameBuilder();
            builder.put(Variable.class, (Adapter)new NativeVariableAdapter(this.model.language(), this.outDSL, this.conf.workingPackage(), this.conf.model().language().generationPackage(), NativeFormatter.calculatePackage(variable.container()), this.conf.getImportsFile()));
            this.createNativeFrame(files, expressionsTemplate, nativeCodes, this.calculateDestination((Variable)variable), builder.append(variable), variable.type(), variable.file());
        });
        return nativeCodes;
    }

    private void createNativeFrame(Map<String, String> originToDestiny, Template expressionsTemplate, Map<File, String> nativeCodes, File destination, FrameBuilder append, Primitive type, String file2) {
        FrameBuilder frameBuilder = append.add(this.conf.nativeLanguage());
        if (Primitive.FUNCTION.equals((Object)type)) {
            frameBuilder.add(type.name());
        }
        nativeCodes.put(destination, expressionsTemplate.render((Object)frameBuilder.toFrame()));
        if (!originToDestiny.containsKey(file2)) {
            originToDestiny.put(destination.getAbsolutePath(), file2);
        }
    }

    private Template expressionsTemplate() {
        return Format.customize((Template)new ExpressionsTemplate());
    }

    private File calculateDestination(Parameter parameter) {
        return new File(this.outDirectory, this.nativesPackage + NativeFormatter.calculatePackage(parameter.container()).replace(".", File.separator) + File.separator + this.nativeName(parameter));
    }

    private File calculateDestination(Variable variable) {
        return new File(this.outDirectory, this.nativesPackage + NativeFormatter.calculatePackage(variable.container()).replace(".", File.separator) + File.separator + this.nativeName(variable));
    }

    private String nativeName(Variable variable) {
        return Format.javaValidName().format(Format.firstUpperCase().format((Object)variable.name())).toString() + "_" + variable.getUID() + nativeExtension;
    }

    private String nativeName(Parameter parameter) {
        return Format.javaValidName().format(Format.firstUpperCase().format((Object)parameter.name())).toString() + "_" + parameter.getUID() + nativeExtension;
    }

    private void writeJavaCode(File file, String nativeText) {
        try {
            file.getParentFile().mkdirs();
            file.createNewFile();
            Files.write(file.toPath(), nativeText.getBytes(this.conf.sourceEncoding()), new OpenOption[0]);
        }
        catch (IOException e) {
            LOG.severe(e.getMessage());
        }
    }

    private void extractNativeParameters(Node node, List<Parameter> natives) {
        if (node instanceof NodeReference || node instanceof NodeImpl && node.container() instanceof NodeRoot && !((NodeImpl)node).isDirty()) {
            return;
        }
        natives.addAll(node.parameters().stream().filter(p -> Primitive.FUNCTION.equals((Object)p.type()) || this.isExpression((Parameter)p)).collect(Collectors.toList()));
        for (Node component : node.components()) {
            this.extractNativeParameters(component, natives);
        }
    }

    private void extractNativeVariables(Node node, List<Variable> natives) {
        if (node instanceof NodeReference || node instanceof NodeImpl && node.container() instanceof NodeRoot && !((NodeImpl)node).isDirty()) {
            return;
        }
        natives.addAll(node.variables().stream().filter(v -> (Primitive.FUNCTION.equals((Object)v.type()) || this.isExpression((Variable)v)) && !v.values().isEmpty() && !v.isInherited()).collect(Collectors.toList()));
        for (Node component : node.components()) {
            this.extractNativeVariables(component, natives);
        }
    }

    private boolean isExpression(Variable valued) {
        return !valued.values().isEmpty() && valued.values().get(0) instanceof Primitive.Expression || valued.flags().contains(Tag.Reactive);
    }

    private boolean isExpression(Parameter parameter) {
        return !parameter.values().isEmpty() && parameter.values().get(0) instanceof Primitive.Expression || parameter.flags().contains(Tag.Reactive);
    }
}

