/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.compiler.codegeneration.magritte.natives;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.FrameBuilderContext;
import io.intino.magritte.Language;
import io.intino.magritte.Resolver;
import io.intino.magritte.builder.compiler.codegeneration.magritte.NameFormatter;
import io.intino.magritte.builder.compiler.codegeneration.magritte.TemplateTags;
import io.intino.magritte.builder.model.Model;
import io.intino.magritte.builder.model.NodeImpl;
import io.intino.magritte.builder.model.VariableReference;
import io.intino.magritte.builder.parser.NativeExtractor;
import io.intino.magritte.builder.utils.Format;
import io.intino.magritte.lang.model.Aspect;
import io.intino.magritte.lang.model.Node;
import io.intino.magritte.lang.model.NodeContainer;
import io.intino.magritte.lang.model.NodeRoot;
import io.intino.magritte.lang.model.Parameter;
import io.intino.magritte.lang.model.Primitive;
import io.intino.magritte.lang.model.Tag;
import io.intino.magritte.lang.model.Valued;
import io.intino.magritte.lang.model.Variable;
import io.intino.magritte.lang.model.rules.variable.NativeObjectRule;
import io.intino.magritte.lang.model.rules.variable.NativeRule;
import io.intino.magritte.lang.semantics.Constraint;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class NativeFormatter
implements TemplateTags {
    private final String outDsl;
    private final Language language;
    private final String aPackage;
    private final String workingPackage;
    private final boolean system;
    private final Map<String, Set<String>> imports;
    private String languageWorkingPackage;

    public NativeFormatter(Language language, String outDsl, String aPackage, String workingPackage, String languageWorkingPackage, boolean system, File importsFile) {
        this.outDsl = outDsl;
        this.language = language;
        this.aPackage = aPackage;
        this.workingPackage = workingPackage;
        this.languageWorkingPackage = languageWorkingPackage;
        this.system = system;
        this.imports = this.load(importsFile);
    }

    public static String workingPackageScope(Valued valued, String workingPackage) {
        return valued.scope() != null && !valued.scope().isEmpty() ? valued.scope() : workingPackage;
    }

    private static String getQn(Node owner, String language, boolean m0) {
        return !m0 ? NameFormatter.getQn(owner, language) : language.toLowerCase() + "." + owner.type();
    }

    private static String getQn(Aspect aspect, String language, boolean m0) {
        return NativeFormatter.asFacet(aspect, language);
    }

    private static String asFacet(Aspect aspect, String language) {
        return null;
    }

    private static String getQn(Node owner, Node node, String workingPackage, boolean m0) {
        return !m0 ? NameFormatter.getQn(owner, workingPackage) : workingPackage.toLowerCase() + "." + owner.type();
    }

    public static String getSignature(Parameter parameter) {
        return ((NativeRule)parameter.rule()).signature();
    }

    public static String getInterface(Parameter parameter) {
        NativeRule rule = (NativeRule)parameter.rule();
        if (rule.interfaceClass() == null) {
            return "";
        }
        return rule.interfaceClass();
    }

    public static String getInterface(Variable variable) {
        NativeRule rule = (NativeRule)variable.rule();
        if (rule.interfaceClass() == null) {
            return "";
        }
        return rule.interfaceClass();
    }

    public static String formatBody(String body, String signature) {
        String formattedBody;
        String returnText = "return ";
        String string = formattedBody = body.endsWith(";") || body.endsWith("}") ? body : body + ";";
        if (!(signature.contains(" void ") || formattedBody.contains("\n") || formattedBody.startsWith("return "))) {
            return "return " + formattedBody;
        }
        return formattedBody;
    }

    public static String getReturn(String body) {
        String returnText = "return ";
        String string = body = body.endsWith(";") || body.endsWith("}") ? body : body + ";";
        if (!body.contains("\n") && !body.startsWith("return ")) {
            return "return ";
        }
        return "";
    }

    public static String getSignature(Variable variable) {
        return ((NativeRule)variable.rule()).signature();
    }

    public static String buildContainerPath(String languageWorkingPackage, Node node, String workingPackage) {
        if (node instanceof Node) {
            Node scope;
            Node node2 = scope = node.is(Tag.Instance) ? NativeFormatter.firstNoFeature((NodeContainer)node) : NativeFormatter.firstNoFeatureAndNamed((NodeContainer)node);
            if (scope == null) {
                return "";
            }
            if (scope.is(Tag.Instance)) {
                return NativeFormatter.getTypeAsScope(scope, languageWorkingPackage);
            }
            return NativeFormatter.getQn(scope, node, workingPackage, false);
        }
        if (node instanceof Aspect) {
            Node scope = NativeFormatter.firstNoFeatureAndNamed((NodeContainer)node);
            if (scope == null) {
                return "";
            }
            return scope.is(Tag.Instance) ? NativeFormatter.getTypeAsScope(scope, languageWorkingPackage) : NativeFormatter.getQn(scope, workingPackage, false);
        }
        return "";
    }

    public static String buildExpressionContainerPath(String typeWorkingPackage, Node owner, String outDSL, String workingPackage) {
        String trueWorkingPackage = NativeFormatter.extractWorkingPackage(typeWorkingPackage, workingPackage);
        if (owner instanceof Node) {
            Node scope;
            Node node = scope = owner.is(Tag.Instance) ? NativeFormatter.firstNoFeature((NodeContainer)owner) : NativeFormatter.firstNoFeatureAndNamed((NodeContainer)owner);
            if (scope == null) {
                return "";
            }
            if (scope.is(Tag.Instance)) {
                return NativeFormatter.getTypeAsScope(scope, trueWorkingPackage);
            }
            return NativeFormatter.getQn(scope, owner, workingPackage, false);
        }
        if (owner instanceof Aspect) {
            return owner.container().is(Tag.Instance) ? NativeFormatter.getTypeAsScope(owner, trueWorkingPackage) : NativeFormatter.getQn((Aspect)owner, workingPackage, false);
        }
        return "";
    }

    private static String extractWorkingPackage(String scope, String language) {
        return scope != null && !scope.isEmpty() ? scope : language;
    }

    private static String getTypeAsScope(Node scope, String languageWorkingPackage) {
        return languageWorkingPackage + "." + (scope instanceof Node ? NameFormatter.cleanQn(scope.type()) : NameFormatter.cleanQn(NativeFormatter.facetType((Aspect)scope)));
    }

    private static List<Aspect> containerFacets(Node scope) {
        Node container;
        for (container = scope.container(); container != null && container.appliedAspects().isEmpty(); container = container.container()) {
        }
        return container != null ? container.appliedAspects() : Collections.emptyList();
    }

    private static String facetType(Aspect scope) {
        return scope.type().toLowerCase() + "." + scope.type() + Resolver.shortType((String)scope.container().type());
    }

    private static Node firstNoFeature(NodeContainer owner) {
        for (NodeContainer container = owner; container != null; container = container.container()) {
            if (!(container instanceof Node) || container instanceof NodeRoot || ((Node)container).is(Tag.Feature)) continue;
            return (Node)container;
        }
        return owner instanceof Node ? (Node)owner : owner.container();
    }

    private static Node firstNoFeatureAndNamed(NodeContainer owner) {
        for (NodeContainer container = owner; container != null; container = container.container()) {
            if (!(container instanceof Node) || container instanceof NodeRoot || ((Node)container).isAnonymous() || ((Node)container).is(Tag.Feature)) continue;
            return (Node)container;
        }
        return owner instanceof Node ? (Node)owner : owner.container();
    }

    private static NodeContainer searchFeatureReference(Node owner) {
        Model model = NativeFormatter.model((NodeContainer)owner);
        if (model == null) {
            return owner;
        }
        NodeContainer nodeContainer = NativeFormatter.searchFeatureReference((NodeContainer)model, owner);
        return nodeContainer != null ? nodeContainer : owner;
    }

    private static NodeContainer searchFeatureReference(NodeContainer node, Node target) {
        if (node instanceof Node && ((Node)node).isReference() && target.equals((Object)((Node)node).destinyOfReference())) {
            return node.container();
        }
        if (node instanceof Node && ((Node)node).isReference()) {
            return null;
        }
        for (Node component : node.components()) {
            NodeContainer nodeContainer = NativeFormatter.searchFeatureReference((NodeContainer)component, target);
            if (nodeContainer == null) continue;
            return nodeContainer;
        }
        return null;
    }

    private static Model model(NodeContainer owner) {
        for (NodeContainer container = owner; container != null; container = container.container()) {
            if (!(container instanceof Node) || !(container instanceof Model)) continue;
            return (Model)container;
        }
        return null;
    }

    public static String calculatePackage(Node container) {
        Node node = NativeFormatter.firstNamedContainer(container);
        return node == null ? "" : ((NodeImpl)node).layerQn().replace("$", ".").replace("#", ".").toLowerCase();
    }

    private static Node firstNamedContainer(Node container) {
        List<Node> containers = NativeFormatter.collectStructure(container);
        Node candidate = null;
        for (Node nodeContainer : containers) {
            if (nodeContainer instanceof Node && !nodeContainer.isAnonymous()) {
                candidate = nodeContainer;
                continue;
            }
            if (nodeContainer instanceof Node) break;
            candidate = nodeContainer;
        }
        return candidate;
    }

    private static List<Node> collectStructure(Node container) {
        ArrayList<Node> containers = new ArrayList<Node>();
        for (Node current = container; current != null && !(current instanceof NodeRoot); current = current.container()) {
            containers.add(0, current);
        }
        return containers;
    }

    private static Constraint.Parameter findParameter(List<Constraint.Parameter> parameters, String name) {
        for (Constraint.Parameter variable : parameters) {
            if (!variable.name().equals(name)) continue;
            return variable;
        }
        return null;
    }

    private Map<String, Set<String>> load(File importsFile) {
        if (importsFile == null) {
            return new HashMap<String, Set<String>>();
        }
        try {
            return (Map)new Gson().fromJson((Reader)new FileReader(importsFile), new TypeToken<Map<String, Set<String>>>(){}.getType());
        }
        catch (FileNotFoundException e) {
            return new HashMap<String, Set<String>>();
        }
    }

    public void fillFrameForFunctionVariable(Variable variable, Object body, FrameBuilderContext context) {
        String signature = NativeFormatter.getSignature(variable);
        context.add("package", (Object)this.aPackage);
        HashSet<String> imports = new HashSet<String>(((NativeRule)variable.rule()).imports());
        imports.addAll(this.collectImports((Valued)variable));
        if (!imports.isEmpty()) {
            context.add("imports", (Object)imports.toArray(new String[imports.size()]));
        }
        if (!context.contains("scope")) {
            context.add("scope", (Object)this.workingPackage);
        }
        if (!context.contains("generatedLanguage")) {
            context.add("generatedLanguage", (Object)this.outDsl.toLowerCase());
        }
        if (!context.contains("workingPackage")) {
            context.add("workingPackage", (Object)this.workingPackage.toLowerCase());
        }
        if (!context.contains("rule")) {
            context.add("rule", (Object)NameFormatter.cleanQn(NativeFormatter.getInterface(variable)));
        }
        if (!context.contains("name")) {
            context.add("name", (Object)variable.name());
        }
        if (!context.contains("qn")) {
            context.add("qn", (Object)variable.container().qualifiedName());
        }
        context.add("file", (Object)variable.file());
        context.add("line", (Object)variable.line());
        context.add("column", (Object)variable.column());
        if (body != null) {
            context.add("body", (Object)NativeFormatter.formatBody(body.toString(), signature));
        }
        context.add("nativeContainer", (Object)NameFormatter.cleanQn(NativeFormatter.buildContainerPath(variable.scope(), variable.container(), this.workingPackage)));
        context.add("signature", (Object)signature);
        context.add("uid", (Object)variable.getUID());
        NativeExtractor extractor = new NativeExtractor(signature);
        context.add("methodName", (Object)extractor.methodName());
        context.add("parameters", (Object)extractor.parameters());
        context.add("returnType", (Object)extractor.returnType());
        context.add("exception", (Object)extractor.exceptions());
    }

    public void fillFrameForFunctionParameter(Parameter parameter, Object body, FrameBuilderContext context) {
        String signature = NativeFormatter.getSignature(parameter);
        if (!context.contains("generatedLanguage")) {
            context.add("generatedLanguage", (Object)this.outDsl);
        }
        if (!context.contains("name")) {
            context.add("name", (Object)parameter.name());
        }
        if (!this.aPackage.isEmpty()) {
            context.add("package", (Object)this.aPackage.toLowerCase());
        }
        if (!context.contains("qn")) {
            context.add("qn", (Object)NameFormatter.cleanQn(parameter.container().qualifiedName()));
        }
        if (!context.contains("scope")) {
            context.add("scope", (Object)NativeFormatter.workingPackageScope((Valued)parameter, this.workingPackage));
        }
        if (!context.contains("workingPackage")) {
            context.add("workingPackage", (Object)this.workingPackage.toLowerCase());
        }
        if (!context.contains("rule".toLowerCase())) {
            context.add("rule", (Object)NameFormatter.cleanQn(NativeFormatter.getInterface(parameter)));
        }
        HashSet<String> imports = new HashSet<String>(((NativeRule)parameter.rule()).imports());
        imports.addAll(this.collectImports((Valued)parameter));
        context.add("imports", (Object)imports.toArray(new String[imports.size()]));
        context.add("signature", (Object)signature);
        context.add("file", (Object)parameter.file());
        context.add("line", (Object)parameter.line());
        context.add("column", (Object)parameter.column());
        context.add("nativeContainer", (Object)NameFormatter.cleanQn(NativeFormatter.buildContainerPath(parameter.scope(), parameter.container(), this.workingPackage)));
        context.add("uid", (Object)parameter.getUID());
        NativeExtractor extractor = new NativeExtractor(signature);
        context.add("methodName", (Object)extractor.methodName());
        context.add("parameters", (Object)extractor.parameters());
        if (body != null) {
            context.add("body", (Object)NativeFormatter.formatBody(body.toString(), signature));
        }
        context.add("returnType", (Object)extractor.returnType());
        context.add("exception", (Object)extractor.exceptions());
    }

    public void fillFrameNativeVariable(FrameBuilderContext context, Variable variable, Object body) {
        context.add("native");
        context.add("file", (Object)variable.file());
        context.add("line", (Object)variable.line());
        context.add("column", (Object)variable.column());
        HashSet<String> imports = new HashSet<String>(variable.rule() != null ? ((NativeRule)variable.rule()).imports() : new HashSet());
        imports.addAll(this.collectImports((Valued)variable));
        if (!context.contains("rule".toLowerCase())) {
            context.add("rule", (Object)NameFormatter.cleanQn(NativeFormatter.getInterface(variable)));
        }
        context.add("imports", (Object)imports.toArray(new String[imports.size()]));
        if (!this.aPackage.isEmpty()) {
            context.add("package", (Object)this.aPackage.toLowerCase());
        }
        if (!context.contains("name")) {
            context.add("name", (Object)variable.name());
        }
        if (!context.contains("generatedLanguage")) {
            context.add("generatedLanguage", (Object)this.outDsl);
        }
        if (!context.contains("workingPackage")) {
            context.add("workingPackage", (Object)this.workingPackage.toLowerCase());
        }
        context.add("nativeContainer".toLowerCase(), (Object)this.buildContainerPathOfExpression((Valued)variable));
        if (!context.contains("type")) {
            context.add("type", (Object)this.typeFrame(this.type(variable), variable.isMultiple()));
        }
        context.add("uid", (Object)variable.getUID());
        if (body != null) {
            context.add("body", (Object)NativeFormatter.formatBody(body.toString(), variable.type().getName()));
        }
    }

    public void fillFrameNativeParameter(FrameBuilderContext context, Parameter parameter, String body) {
        context.add("native");
        context.add("file", (Object)parameter.file());
        context.add("line", (Object)parameter.line());
        context.add("column", (Object)parameter.column());
        HashSet<String> imports = new HashSet<String>(parameter.rule() != null ? ((NativeRule)parameter.rule()).imports() : new HashSet());
        imports.addAll(this.collectImports((Valued)parameter));
        context.add("imports", (Object)imports.toArray(new String[imports.size()]));
        context.add("nativeContainer", (Object)this.buildContainerPathOfExpression((Valued)parameter));
        context.add("uid", (Object)parameter.getUID());
        if (!this.aPackage.isEmpty()) {
            context.add("package", (Object)this.aPackage.toLowerCase());
        }
        if (!context.contains("name".toLowerCase())) {
            context.add("name", (Object)parameter.name());
        }
        if (!context.contains("generatedLanguage".toLowerCase())) {
            context.add("generatedLanguage", (Object)this.outDsl.toLowerCase());
        }
        if (!context.contains("workingPackage".toLowerCase())) {
            context.add("workingPackage", (Object)this.workingPackage.toLowerCase());
        }
        if (!context.contains("type".toLowerCase())) {
            context.add("type", (Object)this.typeFrame(this.type(parameter), this.isMultiple(parameter)));
        }
        if (body != null) {
            context.add("body", (Object)NativeFormatter.formatBody(body, parameter.type().getName()));
        }
    }

    public String type(Variable variable) {
        boolean multiple = variable.isMultiple();
        if (variable.flags().contains(Tag.Concept)) {
            return "io.intino.magritte.framework.Concept";
        }
        if (variable.isReference()) {
            return NameFormatter.getQn(((VariableReference)variable).destinyOfReference(), ((VariableReference)variable).isTypeReference() ? this.languageWorkingPackage : this.workingPackage);
        }
        if (Primitive.OBJECT.equals((Object)variable.type())) {
            return ((NativeObjectRule)variable.rule()).type();
        }
        if (Primitive.WORD.equals((Object)variable.type())) {
            return NameFormatter.getQn(variable.container(), this.workingPackage) + "." + Format.firstUpperCase().format((Object)variable.name());
        }
        return variable.type().javaName();
    }

    private boolean isMultiple(Parameter parameter) {
        Constraint.Parameter constraint = this.parameterConstraintOf(parameter);
        return constraint != null && !constraint.size().isSingle();
    }

    public String type(Parameter parameter) {
        boolean multiple = parameter.isMultiple();
        return parameter.type().equals((Object)Primitive.OBJECT) ? ((NativeObjectRule)parameter.rule()).type() : parameter.type().javaName();
    }

    private Frame typeFrame(String type, boolean multiple) {
        return (multiple ? new FrameBuilder(new String[]{"list"}).add("value", (Object)type) : new FrameBuilder().add("value", (Object)type)).toFrame();
    }

    private List<String> collectImports(Valued parameter) {
        String qn = (parameter.container().qualifiedName() + "." + parameter.name()).replace(":", "");
        return this.imports.containsKey(qn) ? new ArrayList(this.imports.get(qn)) : Collections.emptyList();
    }

    public String buildContainerPathOfExpression(Valued valued) {
        return NameFormatter.cleanQn(NativeFormatter.buildExpressionContainerPath(valued.scope(), valued.container(), this.outDsl, this.system ? this.languageWorkingPackage : this.workingPackage));
    }

    public Constraint.Parameter parameterConstraintOf(Parameter parameter) {
        List<Constraint.Parameter> parameters = this.parameterConstraintsOf(parameter.container());
        if (parameters.isEmpty() || parameters.size() <= parameter.position()) {
            return null;
        }
        return NativeFormatter.findParameter(parameters, parameter.name());
    }

    private List<Constraint.Parameter> parameterConstraintsOf(Node node) {
        if (this.language == null) {
            return Collections.emptyList();
        }
        List nodeConstraints = this.language.constraints(node.resolve().type());
        if (nodeConstraints == null) {
            return Collections.emptyList();
        }
        ArrayList constraints = new ArrayList(nodeConstraints);
        ArrayList<Constraint.Parameter> parameters = new ArrayList<Constraint.Parameter>();
        for (Constraint constraint : constraints) {
            if (constraint instanceof Constraint.Parameter) {
                parameters.add((Constraint.Parameter)constraint);
                continue;
            }
            if (!(constraint instanceof Constraint.Aspect)) continue;
            parameters.addAll(((Constraint.Aspect)constraint).constraints().stream().filter(c -> c instanceof Constraint.Parameter).map(c -> (Constraint.Parameter)c).collect(Collectors.toList()));
        }
        return parameters;
    }
}

