/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.compiler.model;

import io.intino.Configuration;
import io.intino.magritte.Language;
import io.intino.magritte.lang.model.Node;
import io.intino.magritte.lang.model.NodeRoot;
import io.intino.magritte.lang.model.Rule;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Model
implements NodeRoot {
    private String file;
    private Language language;
    private Configuration.Artifact.Model.Level level;
    private Map<Node, List<Rule>> components = new LinkedHashMap<Node, List<Rule>>();
    private List<String> uses;
    private Map<String, File> rules = new HashMap<String, File>();
    private File resourcesRoot;
    private List<Node> facets;

    public Model(String file) {
        this.file = file;
    }

    public String file() {
        return this.file;
    }

    public void file(String file) {
        this.file = file;
    }

    public List<String> uses() {
        return this.uses;
    }

    public Configuration.Artifact.Model.Level level() {
        return this.level;
    }

    public void level(Configuration.Artifact.Model.Level level) {
        this.level = level;
    }

    public boolean contains(Node nodeContainer) {
        return this.components.containsKey(nodeContainer);
    }

    public void remove(Node node) {
        if (node != null) {
            this.components.remove(node);
        }
    }

    public String doc() {
        return "";
    }

    public List<Node> components() {
        return Collections.unmodifiableList(new ArrayList<Node>(this.components.keySet()));
    }

    public String type() {
        return "";
    }

    public void add(Node node, List<Rule> rule) {
        this.components.put(node, new ArrayList<Rule>(rule));
    }

    public List<Rule> rulesOf(Node component) {
        return this.components.get(component);
    }

    public Language language() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public String languageName() {
        return this.language != null ? this.language.languageName() : "";
    }

    public List<Node> allFacets() {
        if (this.facets == null) {
            this.collectFacet();
        }
        return this.facets;
    }

    private void collectFacet() {
        this.facets = new ArrayList<Node>();
        for (Node node : this.components.keySet()) {
            if (node.isAspect()) {
                this.facets.add(node);
            }
            this.facets(node);
        }
    }

    private List<Node> facets(Node node) {
        ArrayList<Node> list = new ArrayList<Node>();
        node.components().forEach(n -> {
            if (n.isReference()) {
                return;
            }
            if (n.isAspect()) {
                list.add((Node)n);
            }
            list.addAll(this.facets((Node)n));
        });
        return list;
    }

    public void setUses(List<String> uses) {
        this.uses = uses;
    }

    public void addRule(String name, File rule) {
        this.rules.put(name, rule);
    }

    public Map<String, File> rules() {
        return this.rules;
    }

    public void setResourcesRoot(File resourceRoot) {
        this.resourcesRoot = resourceRoot;
    }

    public File resourcesRoot() {
        return this.resourcesRoot;
    }

    public boolean isMetaAspect() {
        return false;
    }

    public void stashNodeName(String name) {
    }
}

