/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.compiler.dependencyresolution;

import io.intino.magritte.compiler.core.errorcollection.DependencyException;
import io.intino.magritte.compiler.model.Model;
import io.intino.magritte.compiler.model.NodeImpl;
import io.intino.magritte.compiler.model.NodeReference;
import io.intino.magritte.lang.model.Aspect;
import io.intino.magritte.lang.model.Element;
import io.intino.magritte.lang.model.Flags;
import io.intino.magritte.lang.model.Node;
import io.intino.magritte.lang.model.NodeContainer;
import io.intino.magritte.lang.model.Rule;
import io.intino.magritte.lang.model.Tag;
import io.intino.magritte.lang.model.Variable;
import io.intino.magritte.lang.model.rules.Size;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class InheritanceResolver {
    private Model model;

    public InheritanceResolver(Model model) {
        this.model = model;
    }

    public void resolve() throws DependencyException {
        this.mergeFragmentNodes();
        this.resolveFacetNodes();
        ArrayList<Node> nodes = new ArrayList<Node>(this.collectNodes(this.model, node -> !node.children().isEmpty()));
        this.sort(nodes);
        for (Node node2 : nodes) {
            this.resolve(node2);
        }
    }

    private void resolveFacetNodes() {
        this.model.components().stream().filter(n -> "Facet".equals(n.type())).forEach(n -> {
            if (!n.flags().contains(Tag.Abstract)) {
                n.addFlags(new Tag[]{Tag.Abstract});
            }
            Collection<Node> nodes = this.collectNodes(this.model, node -> (node.isAspect() || node.isMetaAspect()) && node.name().equals(n.name()));
            for (Node node2 : nodes) {
                n.addChild(node2);
                ((NodeImpl)node2).setParent((Node)n);
            }
        });
    }

    private void resolve(Node node) throws DependencyException {
        List<Node> children = this.getChildrenSorted(node);
        if (!(node.isAbstract() || node.subs().isEmpty() || node.flags().contains(Tag.Abstract))) {
            node.addFlags(new Tag[]{Tag.Abstract});
        }
        for (Node child : children) {
            this.resolve(node, child);
        }
    }

    private void resolve(Node node, Node child) throws DependencyException {
        this.resolveComponents(node, child);
        this.resolveVariables(node, child);
        this.resolveFlags(node, child);
        this.resolveAnnotations(node, child);
        this.resolveAllowedAspects(node, child);
        this.resolveAppliedAspects(node, child);
        this.resolveNodeRules(node, child);
        this.resolve(child);
    }

    private void mergeFragmentNodes() throws DependencyException {
        if (this.model.level().isSolution()) {
            return;
        }
        for (List<Node> nodes : this.fragmentNodes().values()) {
            this.merge(nodes);
        }
    }

    private void merge(List<Node> nodes) throws DependencyException {
        if (nodes.size() <= 1) {
            return;
        }
        if (!this.correctParent(nodes)) {
            throw new DependencyException("Error merging extension elements. Parents are not homogeneous.", (Element)nodes.get(0), new String[0]);
        }
        Node destination = nodes.get(0);
        if (destination == null) {
            return;
        }
        nodes.remove(destination);
        for (Node node : nodes) {
            ((NodeImpl)destination).absorb((NodeImpl)node);
            this.model.remove(node);
        }
    }

    private boolean correctParent(List<Node> nodes) {
        String parent = nodes.get(0).parentName() == null ? "" : nodes.get(0).parentName();
        for (Node node : nodes) {
            if (parent.equals(node.parentName() == null ? "" : node.parentName())) continue;
            return false;
        }
        return true;
    }

    private Map<String, List<Node>> fragmentNodes() {
        LinkedHashMap<String, List<Node>> toMerge = new LinkedHashMap<String, List<Node>>();
        for (Node node : this.model.components()) {
            if (node.isAnonymous()) continue;
            if (!toMerge.containsKey(this.name(node))) {
                toMerge.put(this.name(node), new ArrayList());
            }
            ((List)toMerge.get(this.name(node))).add(node);
        }
        return toMerge;
    }

    private String name(Node node) {
        return node.name() + (node.isAspect() ? "Aspect" : "");
    }

    private void resolveNodeRules(Node parent, Node child) {
        List parentRules = parent.container().rulesOf(parent);
        List childRules = child.container().rulesOf(child);
        Size size = child.container().sizeOf(child);
        for (Rule rule : parentRules) {
            if (!(rule instanceof Size)) {
                childRules.add(rule);
                continue;
            }
            if (!this.isMoreRestrictiveThan((Size)rule, size)) continue;
            childRules.remove(size);
            childRules.add(rule);
        }
    }

    private boolean isMoreRestrictiveThan(Size parent, Size child) {
        return parent.min() > child.min() || parent.max() < child.max();
    }

    private void resolveAllowedAspects(Node parent, Node child) {
    }

    private void resolveAppliedAspects(Node parent, Node child) {
        parent.appliedAspects().stream().filter(facet -> !this.isOverridden(child, (Aspect)facet)).forEach(xva$0 -> child.applyAspects(new Aspect[]{xva$0}));
    }

    private boolean isOverridden(Node child, Aspect aspect) {
        for (Aspect childAspect : child.appliedAspects()) {
            if (!childAspect.type().equals(aspect.type())) continue;
            return true;
        }
        return false;
    }

    private Collection<Node> collectNodes(Model model, Predicate<Node> condition) {
        HashSet<Node> collection = new HashSet<Node>();
        for (Node node : model.components()) {
            if (condition.test(node)) {
                collection.add(node);
            }
            this.collect(node, collection, condition);
        }
        return collection;
    }

    private void collect(Node node, Set<Node> collection, Predicate<Node> condition) {
        if (!(node instanceof NodeImpl)) {
            return;
        }
        if (condition.test(node)) {
            collection.add(node);
        }
        for (Node component : node.components()) {
            this.collect(component, collection, condition);
        }
    }

    private void resolveComponents(Node parent, Node child) {
        LinkedHashMap<NodeReference, List> nodes = new LinkedHashMap<NodeReference, List>();
        for (Node node : parent.components()) {
            if (this.isOverridden((NodeContainer)child, node)) continue;
            NodeReference reference = node.isReference() ? new NodeReference(((NodeReference)node).destination()) : new NodeReference((NodeImpl)node);
            this.addTags(node, reference);
            reference.setHas(false);
            reference.file(child.file());
            reference.line(child.line());
            reference.container(child);
            nodes.put(reference, node.container().rulesOf(node));
        }
        for (Map.Entry entry : nodes.entrySet()) {
            child.add((Node)entry.getKey(), (List)entry.getValue());
        }
    }

    private void addTags(Node component, NodeReference reference) {
        component.flags().stream().filter(tag -> !reference.flags().contains(tag) && Flags.forReference().contains(tag)).forEach(xva$0 -> reference.addFlags((Tag)xva$0));
        component.annotations().stream().filter(tag -> !reference.annotations().contains(tag)).forEach(xva$0 -> reference.addAnnotations((Tag)xva$0));
    }

    private void resolveFlags(Node parent, Node child) {
        parent.flags().stream().filter(tag -> !tag.equals((Object)Tag.Abstract) && !child.flags().contains(tag)).forEach(xva$0 -> child.addFlags(new Tag[]{xva$0}));
    }

    private void resolveAnnotations(Node parent, Node child) {
        parent.annotations().stream().filter(tag -> !tag.equals((Object)Tag.Abstract) && !child.annotations().contains(tag)).forEach(xva$0 -> child.addAnnotations(new Tag[]{xva$0}));
    }

    private void resolveVariables(Node parent, Node child) {
        ArrayList<Variable> variables = new ArrayList<Variable>();
        for (Variable variable : parent.variables()) {
            if (this.isOverridden(child, variable)) {
                Variable overridenVariable = this.findVariable(child, variable.name());
                if (overridenVariable == null) continue;
                overridenVariable.addFlags(variable.flags().toArray(new Tag[0]));
                overridenVariable.overriden(true);
                continue;
            }
            variables.add(variable.cloneIt(child));
        }
        child.add(0, variables.toArray(new Variable[0]));
    }

    private Variable findVariable(Node child, String name) {
        for (Variable variable : child.variables()) {
            if (!variable.name().equals(name)) continue;
            return variable;
        }
        return null;
    }

    private boolean isOverridden(NodeContainer child, Node node) {
        for (Node c : child.components()) {
            if (this.isHasReference(c) || !this.areNamesake(node, c) || !c.type().equals(node.type())) continue;
            if (c instanceof NodeImpl && c.parent() == null) {
                ((NodeImpl)c).setParent(node);
            }
            return true;
        }
        return false;
    }

    private boolean areNamesake(Node node, Node c) {
        return c.name() != null && c.name().equals(node.name());
    }

    private boolean isHasReference(Node component) {
        return component instanceof NodeReference && ((NodeReference)component).isHas();
    }

    private boolean isOverridden(Node child, Variable variable) {
        return child.variables().stream().anyMatch(childVar -> childVar.name().equals(variable.name()) && childVar.type().equals((Object)variable.type()));
    }

    private List<Node> getChildrenSorted(Node parent) {
        ArrayList<Node> children = new ArrayList<Node>(parent.children());
        this.sort(children);
        return children;
    }

    private void sort(List<Node> nodes) {
        if (nodes.isEmpty()) {
            return;
        }
        nodes.sort(this.inheritanceComparator());
        Collections.reverse(nodes);
    }

    private Comparator<Node> inheritanceComparator() {
        return new Comparator<Node>(){

            @Override
            public int compare(Node o1, Node o2) {
                return this.maxLevel(o1) - this.maxLevel(o2);
            }

            private int maxLevel(Node node) {
                ArrayList<Integer> levels = new ArrayList<Integer>(Collections.singletonList(0));
                levels.addAll(node.children().stream().map(this::maxLevel).collect(Collectors.toList()));
                levels.sort(Collections.reverseOrder());
                return 1 + (Integer)levels.get(0);
            }

            @Override
            public boolean equals(Object obj) {
                return false;
            }

            public int hashCode() {
                return super.hashCode();
            }
        };
    }
}

