/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.compiler.core.errorcollection;

import io.intino.magritte.lang.model.Element;

public class TaraRuntimeException
extends RuntimeException {
    private final transient Element element;

    public TaraRuntimeException(String message, Element element, Throwable e) {
        super(message, e);
        this.element = element;
    }

    @Override
    public String getMessage() {
        return this.getMessageWithoutLocationText() + this.getLocationText();
    }

    public Element getElement() {
        return this.element;
    }

    public String getMessageWithoutLocationText() {
        return super.getMessage();
    }

    protected String getLocationText() {
        Object answer = ". ";
        if (this.element != null) {
            answer = (String)answer + "At [" + this.element.line() + "] ";
        }
        if (". ".equals(answer)) {
            return "";
        }
        return answer;
    }
}

